/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.rmi.registry;

import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class RegistryImpl
extends UnicastRemoteObject
implements Registry {
    private Hashtable table = new Hashtable();

    public RegistryImpl() throws RemoteException {
        this(1099);
    }

    public RegistryImpl(int port) throws RemoteException {
        this(port, null, null);
    }

    public RegistryImpl(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    public Remote lookup(String name) throws NotBoundException, AccessException {
        Object o = this.table.get(name);
        if (o == null) {
            throw new NotBoundException(name);
        }
        return (Remote)o;
    }

    public void bind(String name, Remote stub) throws AlreadyBoundException {
        Object o = this.table.get(name);
        if (o != null) {
            throw new AlreadyBoundException();
        }
        this.table.put(name, stub);
    }

    public void unbind(String name) throws NotBoundException, AccessException {
        Object o = this.table.remove(name);
        if (o == null) {
            throw new NotBoundException(name);
        }
    }

    public synchronized void rebind(String name, Remote stub) throws AccessException {
        this.table.put(name, stub);
    }

    public synchronized String[] list() throws AccessException {
        Enumeration e = this.table.keys();
        String[] r = new String[this.table.size()];
        int i = 0;
        while (i < this.table.size()) {
            r[i] = (String)e.nextElement();
            ++i;
        }
        return r;
    }
}

