/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.rmi.rmic;

import com.ibm.oti.rmi.rmic.StubGenerator;
import com.ibm.oti.rmi.util.Msg;
import com.ibm.oti.rmi.util.RMIUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Vector;

public class Main {
    static boolean xdebug = false;

    public static void usage() {
        System.err.println();
        System.err.println(Msg.getString("R0013"));
        System.err.println();
        System.err.println(Msg.getString("R0014"));
        System.err.println("\t-ver:<version>\t " + Msg.getString("R0015"));
        System.err.println("\t\t<version> = [1.1 | 1.2 | Compat]");
        System.err.println("\t-cp:<path>\t " + Msg.getString("R0016"));
        System.err.println("\t-d:<destDir>\t " + Msg.getString("R0017"));
        System.err.println("\t-keep\t\t " + Msg.getString("R0018"));
        System.err.println("\t-nocompile\t " + Msg.getString("R0019"));
        System.err.println("\t-g\t\t " + Msg.getString("R0020"));
        System.err.println("\t-verbose\t " + Msg.getString("R0021"));
        System.err.println("\t-nowarn\t\t " + Msg.getString("R0022"));
    }

    public static void main(String[] args) {
        try {
            if (args == null || args.length == 0) {
                Main.usage();
                return;
            }
            int version = -1;
            String classpath = null;
            String bootpath = null;
            String jcl = null;
            File dest = null;
            boolean cDebug = false;
            boolean cVerbose = false;
            boolean keep = false;
            boolean compile = true;
            boolean nowarn = true;
            int i = 0;
            while (i < args.length - 1) {
                if (args[i].startsWith("-ver:")) {
                    String ver = args[i].substring(5);
                    if (ver.equals("1.1")) {
                        version = 0;
                    } else if (ver.equals("1.2")) {
                        version = 1;
                    } else if (ver.equalsIgnoreCase("Compat")) {
                        version = 2;
                    } else {
                        System.err.println(Msg.getString("R0023", ver));
                        Main.usage();
                        System.exit(1);
                    }
                } else if (args[i].startsWith("-cp:")) {
                    classpath = args[i].substring(4);
                } else if (args[i].startsWith("-d:")) {
                    dest = new File(args[i].substring(3));
                } else if (args[i].startsWith("-keep")) {
                    keep = true;
                } else if (args[i].equals("-nocompile")) {
                    compile = false;
                    keep = true;
                } else if (args[i].equals("-g")) {
                    cDebug = true;
                } else if (args[i].equals("-verbose")) {
                    cVerbose = true;
                } else if (args[i].equals("-nowarn")) {
                    nowarn = true;
                } else if (args[i].startsWith("-jcl:")) {
                    jcl = args[i].substring(5);
                } else if (args[i].startsWith("-bp:")) {
                    bootpath = args[i].substring(4);
                } else if (args[i].equals("-Xdebug")) {
                    xdebug = true;
                } else if (args[i].startsWith("-")) {
                    System.err.println(Msg.getString("R0024", args[i]));
                    System.exit(1);
                }
                ++i;
            }
            if (version == -1) {
                version = 2;
            }
            String cPath = null;
            if (classpath == null) {
                classpath = ".";
            }
            Vector<URL> cp = new Vector<URL>();
            int start = 0;
            while (start < classpath.length()) {
                int end = classpath.indexOf(File.pathSeparatorChar, start);
                if (end == -1) {
                    end = classpath.length();
                }
                File f = new File(classpath.substring(start, end));
                String fName = f.getCanonicalPath();
                cPath = cPath == null ? fName : String.valueOf(cPath) + File.pathSeparator + fName;
                fName = fName.replace('\\', '/');
                if (f.isDirectory() && !fName.endsWith("/")) {
                    fName = String.valueOf(fName) + "/";
                }
                cp.add(new URL("file", "", fName));
                start = end + 1;
            }
            URL[] urls = new URL[cp.size()];
            cp.toArray(urls);
            URLClassLoader cLoader = new URLClassLoader(urls, null);
            if (xdebug) {
                int i2 = 0;
                while (i2 < urls.length) {
                    System.out.println("URL[" + i2 + "] " + urls[i2]);
                    ++i2;
                }
            }
            if (dest == null) {
                dest = new File(".");
            }
            Vector<String> cArgs = new Vector<String>();
            if (compile) {
                File rmiFile;
                String destPath = dest.getAbsolutePath();
                if (bootpath == null && (rmiFile = new File(System.getProperty("java.home"), "lib/rmi.zip")).exists()) {
                    cPath = String.valueOf(rmiFile.getAbsolutePath()) + File.pathSeparator + cPath;
                }
                cArgs.add(String.valueOf(System.getProperty("com.ibm.oti.vm.bootstrap.library.path")) + "j9c");
                if (jcl != null) {
                    cArgs.add("-jcl:" + jcl);
                }
                if (bootpath != null) {
                    cArgs.add("-bootclasspath");
                    cArgs.add(bootpath);
                }
                cArgs.add("-classpath");
                cArgs.add(cPath);
                cArgs.add("-d");
                cArgs.add(destPath);
                cArgs.add(cDebug ? "-g" : "-g:lines");
                if (cVerbose) {
                    cArgs.add("-verbose");
                }
                if (nowarn) {
                    cArgs.add("-nowarn");
                }
            }
            int rc = 0;
            int fIndex = cArgs.size();
            int i3 = 0;
            while (i3 < args.length) {
                if (!args[i3].startsWith("-")) {
                    if (Main.generate(args[i3], dest, version, cLoader)) {
                        if (compile) {
                            String file = new File(dest, args[i3].replace('.', File.separatorChar)).getAbsolutePath();
                            cArgs.add(String.valueOf(file) + "_Stub.java");
                            if (version != 1) {
                                cArgs.add(String.valueOf(file) + "_Skel.java");
                            }
                        }
                    } else {
                        rc = 1;
                    }
                }
                ++i3;
            }
            if (cArgs.size() > fIndex) {
                rc |= Main.execJ9c(cArgs);
            }
            if (!keep) {
                i3 = fIndex;
                while (i3 < cArgs.size()) {
                    if (xdebug) {
                        System.out.println("removing: " + cArgs.elementAt(i3));
                    }
                    new File((String)cArgs.elementAt(i3)).delete();
                    ++i3;
                }
            }
            System.exit(rc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static int execJ9c(Vector vargs) {
        Process process;
        Object[] args = new String[vargs.size()];
        vargs.copyInto(args);
        if (xdebug) {
            int i = 0;
            while (i < args.length) {
                System.out.println(String.valueOf(i) + ") " + (String)args[i]);
                ++i;
            }
        }
        try {
            process = Runtime.getRuntime().exec((String[])args);
        }
        catch (IOException e) {
            System.err.println(String.valueOf(Msg.getString("R0025", args[0])) + ": " + e);
            return 1;
        }
        new Thread(Main.readInput(process.getInputStream())).start();
        Main.readInput(process.getErrorStream()).run();
        while (true) {
            try {
                return process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private static Runnable readInput(final InputStream in) {
        return new Runnable(){

            public void run() {
                byte[] buf = new byte[256];
                try {
                    int read;
                    while ((read = in.read(buf)) != -1) {
                        System.out.write(buf, 0, read);
                    }
                }
                catch (IOException iOException) {}
            }
        };
    }

    private static boolean generate(String classNameStr, File dest, int version, ClassLoader cLoader) throws Exception {
        PrintStream p;
        FileOutputStream f;
        Class<?> remoteClass;
        try {
            remoteClass = cLoader.loadClass(classNameStr);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(Msg.getString("R0026", classNameStr));
            return false;
        }
        catch (NoClassDefFoundError ex) {
            System.err.println(String.valueOf(Msg.getString("R0027", classNameStr)) + ": " + ex.getMessage());
            return false;
        }
        Class[] intf = RMIUtil.getAllRemoteInterfaces(remoteClass);
        if (intf.length == 0) {
            System.err.println(Msg.getString("R0028", classNameStr));
            return false;
        }
        String className = remoteClass.getName();
        if (className.lastIndexOf(46) > 0) {
            className = className.substring(0, className.lastIndexOf(46));
            className = className.replace('.', File.separatorChar);
            dest = new File(dest, className);
        }
        dest.mkdirs();
        className = remoteClass.getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        if (version == 2 || version == 0) {
            f = new FileOutputStream(new File(dest, String.valueOf(className) + "_Skel.java"));
            p = new PrintStream(f);
            StubGenerator.genSkel(version, remoteClass, p);
            p.close();
            f.close();
        }
        f = new FileOutputStream(new File(dest, String.valueOf(className) + "_Stub.java"));
        p = new PrintStream(f);
        StubGenerator.genStub(version, remoteClass, p);
        p.close();
        f.close();
        return true;
    }
}

