/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.rmi.rmic;

import com.ibm.oti.rmi.util.Msg;
import com.ibm.oti.rmi.util.RMIUtil;
import com.ibm.oti.util.SHAOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

public class StubGenerator {
    public static final int V11 = 0;
    public static final int V12 = 1;
    public static final int VComp = 2;
    protected static final Class[] rmiImplClasses;
    protected boolean v11;
    protected boolean v12;
    protected boolean vComp;
    protected Class remoteClass;
    protected PrintStream out;
    protected long proxyHash = 0L;
    protected Method[] methods;
    protected Class[] interfaces;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;

    static {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.oti.rmi.registry.RegistryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.ibm.oti.rmi.dgc.DGCImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        rmiImplClasses = classArray;
    }

    public static void genStub(int version, Class remoteClass, PrintStream out) throws IOException {
        new StubGenerator(version, remoteClass, out).genStub();
    }

    public static void genSkel(int version, Class remoteClass, PrintStream out) throws IOException {
        new StubGenerator(version, remoteClass, out).genSkel();
    }

    protected StubGenerator(int version, Class remoteClass, PrintStream out) {
        if (version == 0) {
            this.v11 = true;
            this.vComp = false;
            this.v12 = false;
        } else if (version == 1) {
            this.vComp = false;
            this.v11 = false;
            this.v12 = true;
        } else {
            this.vComp = true;
            this.v12 = true;
            this.v11 = true;
        }
        this.remoteClass = remoteClass;
        this.out = out;
        this.findMethods();
    }

    protected void genStub() throws IOException {
        this.writeHeader();
        this.writeStubClassName();
        this.writeStubClassInit();
        this.writeStubConstructors();
        this.writeStubMethods();
        this.out.print("}");
    }

    protected void genSkel() {
        if (!this.v11) {
            return;
        }
        this.writeHeader();
        this.writeSkelClassName();
        this.writeSkelClassInit();
        this.writeSkelConstructors();
        this.out.println("public Operation[] getOperations() {return ops;}");
        this.out.println();
        this.writeSkelDispatch();
        this.out.print("}");
    }

    protected void writeHeader() {
        if (this.isRmiClass(this.remoteClass)) {
            this.out.println("/*[INCLUDE-IF RMI]*/");
        }
        this.out.println("/*");
        this.out.println(" * " + Msg.getString("R0029"));
        this.out.println(" * " + Msg.getString("R0030"));
        this.out.println(" * " + Msg.getString("R0031"));
        this.out.println(" */");
        String pName = this.packageName();
        if (pName != null) {
            this.out.println("package " + pName + ";");
        }
        if (this.isRmiClass(this.remoteClass)) {
            this.out.println();
            this.out.println("/*");
            this.out.println(" * Licensed Materials - Property of IBM,");
            this.out.println(" * (c) Copyright IBM Corp 1998, 2001");
            this.out.println(" */");
            this.out.println();
        }
        this.out.println();
        this.out.println("import java.rmi.*;");
        this.out.println("import java.rmi.server.*;");
        this.out.println("import java.lang.reflect.*;");
        this.out.println("import java.io.*;");
        this.out.println();
    }

    protected void writeSkelClassName() {
        this.out.println("public class " + this.className() + "_Skel implements Skeleton {");
        this.out.println();
    }

    protected void writeSkelClassInit() {
        this.out.println("private static final Operation ops[];");
        this.out.println();
        this.out.println("static {");
        this.writeOperations();
        this.out.println("}");
        this.out.println();
    }

    protected void writeSkelConstructors() {
        this.out.print("public ");
        this.out.println(String.valueOf(this.className()) + "_Skel() throws java.rmi.RemoteException {}");
        this.out.println();
    }

    protected void writeSkelDispatch() {
        this.out.print("public void dispatch(Remote obj, RemoteCall rc, ");
        this.out.println("int opnum, long hash) throws Exception {");
        this.out.println("\tif(hash != " + this.proxyHash + "L)");
        this.out.println("\t\tthrow new SkeletonMismatchException(\"" + this.className() + "\");");
        this.out.println();
        int i = 0;
        while (i < this.methods.length) {
            this.writeSkelDispatchOp(this.methods[i], i);
            ++i;
        }
        if (this.methods.length > 0) {
            this.out.println("\t} else {");
            this.out.println("\t\tthrow new NoSuchObjectException(" + this.externalMessageString("R0032", null) + "+\" '\" + opnum + \"' \"+" + this.externalMessageString("R0033", null) + ");");
            this.out.println("\t}");
        }
        this.out.println("}");
    }

    protected void writeSkelDispatchOp(Method m, int opNum) {
        int i;
        this.out.print("\t");
        if (opNum > 0) {
            this.out.print("} else ");
        }
        this.out.println("if(opnum == " + opNum + ") {");
        Class<?>[] pTypes = m.getParameterTypes();
        int i2 = 0;
        while (i2 < pTypes.length) {
            this.out.println("\t\t" + this.getTypeName(pTypes[i2]) + " arg" + i2 + ";");
            ++i2;
        }
        if (pTypes.length > 0) {
            this.out.println("\t\ttry {");
            this.out.println("\t\t\tObjectInput ois = rc.getInputStream();");
            boolean catchClassNotFoundException = false;
            i = 0;
            while (i < pTypes.length) {
                if (!pTypes[i].isPrimitive()) {
                    catchClassNotFoundException = true;
                }
                this.out.println("\t\t\targ" + i + " = (" + this.getTypeName(pTypes[i]) + ")ois.read" + this.stringWriteReadObject(pTypes[i]) + "();");
                ++i;
            }
            if (catchClassNotFoundException) {
                this.out.println("\t\t} catch (ClassNotFoundException ex) {");
                this.out.println("\t\t\tthrow new UnmarshalException(" + this.externalMessageString("R0007", null) + ",ex);");
            }
            this.out.println("\t\t} catch (IOException ex) {");
            this.out.println("\t\t\tthrow new UnmarshalException(" + this.externalMessageString("R0007", null) + ",ex);");
            this.out.println("\t\t} finally {");
            this.out.println("\t\t\trc.releaseInputStream();");
            this.out.println("\t\t}");
        }
        Class<?> rType = m.getReturnType();
        this.out.print("\t\t");
        if (rType != Void.TYPE) {
            this.out.print(String.valueOf(this.getTypeName(rType)) + " result = ");
        }
        this.out.print("((" + this.className() + ")obj)." + m.getName() + "(");
        i = 0;
        while (i < pTypes.length) {
            this.out.print("arg" + i);
            if (i + 1 < pTypes.length) {
                this.out.print(", ");
            }
            ++i;
        }
        this.out.println(");");
        this.out.println("\t\ttry {");
        if (rType != Void.TYPE) {
            this.out.println("\t\t\tObjectOutput oos = rc.getResultStream(true);");
            this.out.println("\t\t\toos.write" + this.stringWriteReadObject(rType) + "(result);");
        } else {
            this.out.println("\t\t\trc.getResultStream(true);");
        }
        this.out.println("\t\t} catch (IOException ex) {");
        this.out.println("\t\t\tthrow new UnmarshalException(" + this.externalMessageString("R0008", null) + ",ex);");
        this.out.println("\t\t}");
    }

    protected void writeStubClassName() {
        String[] ints = this.interfaces();
        this.out.print("public class " + this.className() + "_Stub extends RemoteStub implements ");
        this.packageName();
        int i = 0;
        while (i < ints.length) {
            String name = ints[i];
            this.out.print(name);
            if (i + 1 < ints.length) {
                this.out.print(", ");
            }
            ++i;
        }
        this.out.println(" {");
        this.out.println();
    }

    protected void writeStubClassInit() {
        if (this.vComp) {
            this.out.println("private static boolean isJDK11;");
        }
        this.out.println("private static Object ops[] = null;");
        if (this.v12) {
            this.out.println("private static Class remoteClass = null;");
        }
        this.out.println();
        this.out.println("static {");
        if (this.v12) {
            this.out.println("\ttry {");
            String pName = this.packageName();
            if (pName != null) {
                this.out.println("\t\tremoteClass = Class.forName(\"" + pName + "." + this.className() + "\");");
            } else {
                this.out.println("\t\tremoteClass = Class.forName(\"" + this.className() + "\");");
            }
        }
        if (this.vComp) {
            this.out.println("\t\tClass.forName(\"java.rmi.MarshalledObject\");");
            this.out.println("\t\tisJDK11 = false;");
        }
        if (this.v12) {
            this.out.println("\t} catch (ClassNotFoundException ex) {");
        }
        if (this.vComp) {
            this.out.println("\t\tisJDK11 = true;");
        }
        if (this.v12) {
            this.out.println("\t}");
        }
        if (this.vComp) {
            this.out.println("\tif(isJDK11) {");
        }
        if (this.v11) {
            this.writeOperations();
        }
        if (this.vComp) {
            this.out.println("\t} else {");
        }
        if (this.v12) {
            this.writeMethods();
        }
        if (this.vComp) {
            this.out.println("\t}");
        }
        this.out.println("}");
        this.out.println();
    }

    protected void writeStubConstructors() {
        this.out.println("public " + this.className() + "_Stub(RemoteRef ref) throws java.rmi.RemoteException {");
        this.out.println("\tsuper(ref);");
        this.out.println("}");
        this.out.println();
        this.out.println("public " + this.className() + "_Stub() throws java.rmi.RemoteException {");
        this.out.println("\tsuper();");
        this.out.println("}");
        this.out.println();
    }

    protected void writeStubMethods() throws IOException {
        int i = 0;
        while (i < this.methods.length) {
            this.writeStubMethodsName(this.methods[i]);
            if (this.vComp) {
                this.out.println("\tif(isJDK11) {");
            }
            if (this.v11) {
                this.writeStubJDK11Method(this.methods[i], i);
            }
            if (this.vComp) {
                this.out.println("\t} else {");
            }
            if (this.v12) {
                this.writeStubJDK12Method(this.methods[i], i);
            }
            if (this.vComp) {
                this.out.println("\t}");
            }
            this.out.println("}");
            this.out.println();
            ++i;
        }
    }

    protected void writeStubMethodsName(Method m) {
        this.out.print("public ");
        this.out.print(this.getTypeName(m.getReturnType()));
        this.out.print(" " + m.getName() + "(");
        Class<?>[] p = m.getParameterTypes();
        int j = 0;
        while (j < p.length) {
            this.out.print(String.valueOf(this.getTypeName(p[j])) + " p" + j);
            if (j + 1 < p.length) {
                this.out.print(", ");
            }
            ++j;
        }
        this.out.print(") throws ");
        Class<?>[] exs = m.getExceptionTypes();
        int j2 = 0;
        while (j2 < exs.length) {
            this.out.print(exs[j2].getName());
            if (j2 + 1 < exs.length) {
                this.out.print(", ");
            }
            ++j2;
        }
        this.out.println("{");
    }

    protected void writeStubJDK11Method(Method m, int opIndex) {
        this.out.print("\t\tRemoteCall rc = ref.newCall(this,(Operation[])ops, ");
        this.out.println(String.valueOf(opIndex) + ", " + this.proxyHash + "L);");
        Class<?>[] p = m.getParameterTypes();
        if (p.length > 0) {
            this.out.println("\t\ttry {");
            this.out.println("\t\t\tObjectOutput oos = rc.getOutputStream();");
            int j = 0;
            while (j < p.length) {
                this.out.println("\t\t\toos.write" + this.stringWriteReadObject(p[j]) + "(p" + j + ");");
                ++j;
            }
            this.out.println("\t\t} catch (IOException ex) {");
            this.out.print("\t\t\tthrow new MarshalException(");
            this.out.println(String.valueOf(this.externalMessageString("R0010", null)) + ",ex);");
            this.out.println("\t\t}");
        }
        this.out.println("\t\ttry {");
        this.out.println("\t\t\tref.invoke(rc);");
        this.out.println("\t\t} catch (RuntimeException ex) {");
        this.out.println("\t\t\tthrow ex;");
        Class[] exs = m.getExceptionTypes();
        this.select(exs);
        boolean incEx = false;
        int j = 0;
        while (j < exs.length) {
            if (exs[j] != null) {
                Class clazz = exs[j];
                Class<?> clazz2 = class$3;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.Exception");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2) {
                    incEx = true;
                }
                this.out.println("\t\t} catch (" + exs[j].getName() + " ex) {");
                this.out.println("\t\t\tthrow ex;");
            }
            ++j;
        }
        if (!incEx) {
            this.out.println("\t\t} catch (Exception ex) {");
            this.out.println("\t\t\tthrow new UnexpectedException(" + this.externalMessageString("R0038", new String[]{m.getName()}) + ",ex);");
        }
        this.out.println("\t\t}");
        Class<?> rType = m.getReturnType();
        if (rType != Void.TYPE) {
            this.out.println("\t\t" + this.getTypeName(rType) + " result;");
            this.out.println("\t\ttry {");
            this.out.println("\t\t\tObjectInput ois = rc.getInputStream();");
            this.out.println("\t\t\tresult = (" + this.getTypeName(rType) + ")ois.read" + this.stringWriteReadObject(rType) + "();");
            this.out.println("\t\t} catch (RuntimeException ex) {");
            this.out.println("\t\t\tthrow ex;");
            this.out.println("\t\t} catch (Exception ex) {");
            this.out.println("\t\t\tthrow new UnmarshalException(" + this.externalMessageString("R0012", null) + ",ex);");
            this.out.println("\t\t} finally {");
            this.out.println("\t\t\tref.done(rc);");
            this.out.println("\t\t}");
            this.out.println("\t\treturn result;");
        }
    }

    protected void writeStubJDK12Method(Method m, int opIndex) throws IOException {
        this.out.println("\t\ttry {");
        this.out.print("\t\t\t");
        Class<?> rType = m.getReturnType();
        if (rType != Void.TYPE) {
            if (rType.isPrimitive()) {
                this.out.print(String.valueOf(this.wrapperName(rType)) + " result = (" + this.wrapperName(rType) + ")");
            } else {
                this.out.print("return (" + this.getTypeName(rType) + ")");
            }
        }
        this.out.println("ref.invoke(");
        this.out.print("\t\t\t\tthis,(Method)ops[" + opIndex + "], new Object[]{");
        Class<?>[] p = m.getParameterTypes();
        int j = 0;
        while (j < p.length) {
            if (p[j].isPrimitive()) {
                this.out.print("new " + this.wrapperName(p[j]) + "(p" + j + ")");
            } else {
                this.out.print("p" + j);
            }
            if (j + 1 < p.length) {
                this.out.print(", ");
            }
            ++j;
        }
        this.out.print("}, ");
        this.out.print(RMIUtil.hashFor(m));
        this.out.println("L);");
        if (rType != Void.TYPE && rType.isPrimitive()) {
            this.out.println("\t\t\t\treturn result." + this.getTypeName(rType) + "Value();");
        }
        Class[] exs = m.getExceptionTypes();
        this.select(exs);
        boolean incEx = false;
        int j2 = 0;
        while (j2 < exs.length) {
            if (exs[j2] != null) {
                Class clazz = exs[j2];
                Class<?> clazz2 = class$3;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.Exception");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2) {
                    incEx = true;
                }
                this.out.println("\t\t} catch (" + exs[j2].getName() + " ex) {");
                this.out.println("\t\t\tthrow ex;");
            }
            ++j2;
        }
        if (!incEx) {
            this.out.println("\t\t} catch (Exception ex) {");
            this.out.println("\t\t\tthrow new UnexpectedException(" + this.externalMessageString("R0038", new String[]{m.getName()}) + ",ex);");
        }
        this.out.println("\t\t}");
    }

    protected void writeOperations() {
        String[] ops = this.getOperations();
        this.out.println("\t\tops = new Operation[]{");
        int i = 0;
        while (i < ops.length) {
            this.out.print("\t\t\tnew Operation(\"" + ops[i] + "\")");
            if (i + 1 < ops.length) {
                this.out.println(",");
            }
            ++i;
        }
        this.out.println();
        this.out.println("\t\t};");
    }

    protected void writeMethods() {
        String[] mths = this.getMethodString();
        if (mths.length > 0) {
            this.out.println("\t\ttry {");
        }
        this.out.println("\t\t\tops = new Method[]{");
        int i = 0;
        while (i < mths.length) {
            this.out.print("\t\t\t\tClass.forName(\"" + this.interfaces[i].getName() + "\").getMethod(" + mths[i] + ")");
            if (i + 1 < mths.length) {
                this.out.println(",");
            }
            ++i;
        }
        this.out.println();
        this.out.println("\t\t\t};");
        if (mths.length > 0) {
            this.out.println("\t\t} catch (NoSuchMethodException ex) {");
            this.out.println("\t\t\tthrow new RuntimeException(" + this.externalMessageString("R0035", null) + ");");
            this.out.println("\t\t} catch (ClassNotFoundException ex2) {");
            this.out.println("\t\t\tthrow new RuntimeException(" + this.externalMessageString("R0036", null) + ");");
            this.out.println("\t\t}");
        }
    }

    protected String externalMessageString(String messageKey, Object[] args) {
        if (this.isRmiClass(this.remoteClass)) {
            StringBuffer msg = new StringBuffer();
            msg.append("com.ibm.oti.rmi.util.Msg.getString(\"");
            msg.append(messageKey);
            msg.append("\"");
            if (args != null && args.length > 0) {
                int i = 0;
                while (i < args.length) {
                    msg.append("\"");
                    msg.append(args[i].toString());
                    msg.append("\"");
                    if (i < args.length - 1) {
                        msg.append(",");
                    }
                    ++i;
                }
            }
            msg.append(")");
            return msg.toString();
        }
        if (args != null && args.length > 0) {
            return "\"" + Msg.getString(messageKey, args) + "\"";
        }
        return "\"" + Msg.getString(messageKey) + "\"";
    }

    protected String stringWriteReadObject(Class c) {
        if (c.isPrimitive()) {
            if (c == Boolean.TYPE) {
                return "Boolean";
            }
            if (c == Byte.TYPE) {
                return "Byte";
            }
            if (c == Character.TYPE) {
                return "Char";
            }
            if (c == Short.TYPE) {
                return "Short";
            }
            if (c == Integer.TYPE) {
                return "Int";
            }
            if (c == Long.TYPE) {
                return "Long";
            }
            if (c == Float.TYPE) {
                return "Float";
            }
            if (c == Double.TYPE) {
                return "Double";
            }
            return null;
        }
        return "Object";
    }

    protected String wrapperName(Class c) {
        if (c.isPrimitive()) {
            if (c == Boolean.TYPE) {
                return "Boolean";
            }
            if (c == Byte.TYPE) {
                return "Byte";
            }
            if (c == Character.TYPE) {
                return "Character";
            }
            if (c == Short.TYPE) {
                return "Short";
            }
            if (c == Integer.TYPE) {
                return "Integer";
            }
            if (c == Long.TYPE) {
                return "Long";
            }
            if (c == Float.TYPE) {
                return "Float";
            }
            if (c == Double.TYPE) {
                return "Double";
            }
            return null;
        }
        return "Object";
    }

    protected void computeProxyHash(String[] ops) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.oti.rmi.registry.RegistryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.remoteClass.equals(clazz)) {
            this.proxyHash = 4905912898345647071L;
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("com.ibm.oti.rmi.dgc.DGCImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (this.remoteClass.equals(clazz2)) {
                this.proxyHash = -669196253586618813L;
            } else {
                try {
                    SHAOutputStream sha = new SHAOutputStream();
                    DataOutputStream output = new DataOutputStream(sha);
                    int i = 0;
                    while (i < ops.length) {
                        output.writeUTF(ops[i]);
                        ++i;
                    }
                    byte[] h = sha.getHashAsBytes();
                    this.proxyHash = RMIUtil.littleEndianLongAt(h, 0);
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected String[] getOperations() {
        Vector<String> r = new Vector<String>();
        int i = 0;
        while (i < this.methods.length) {
            r.add(this.operationString(this.methods[i]));
            ++i;
        }
        String[] rString = new String[r.size()];
        r.toArray(rString);
        this.computeProxyHash(rString);
        return rString;
    }

    protected String[] getMethodString() {
        String[] r = new String[this.methods.length];
        int i = 0;
        while (i < r.length) {
            String m = "\"" + this.methods[i].getName() + "\", new Class[]{";
            Class<?>[] params = this.methods[i].getParameterTypes();
            int j = 0;
            while (j < params.length) {
                m = String.valueOf(m) + this.getTypeName(params[j]) + ".class";
                if (j + 1 < params.length) {
                    m = String.valueOf(m) + ", ";
                }
                ++j;
            }
            r[i] = m = String.valueOf(m) + "}";
            ++i;
        }
        return r;
    }

    protected void findMethods() {
        TreeMap<String, Object[]> meth = new TreeMap<String, Object[]>();
        Class[] ints = RMIUtil.getAllRemoteInterfaces(this.remoteClass);
        int i = 0;
        while (i < ints.length) {
            Method[] m = ints[i].getMethods();
            int j = 0;
            while (j < m.length) {
                String sig = this.operationString1(m[j]);
                if (!meth.containsKey(sig)) {
                    meth.put(sig, new Object[]{m[j], ints[i]});
                }
                ++j;
            }
            ++i;
        }
        this.methods = new Method[meth.size()];
        this.interfaces = new Class[meth.size()];
        i = 0;
        Iterator it = meth.values().iterator();
        while (it.hasNext()) {
            Object[] value = (Object[])it.next();
            this.methods[i] = (Method)value[0];
            this.interfaces[i] = (Class)value[1];
            ++i;
        }
    }

    protected void select(Class[] array) {
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array.length) {
                if (array[i] != null && array[j] != null && this.isSuperclass(array[j], array[i])) {
                    array[i] = null;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    protected boolean isSuperclass(Class c1, Class c2) {
        boolean b = this.isSuperclass0(c1, c2);
        return b;
    }

    protected boolean isSuperclass0(Class c1, Class c2) {
        Class<?> clazz = class$12;
        if (clazz == null) {
            try {
                clazz = class$12 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> obj = clazz;
        Class c = c2;
        do {
            if (!(c = c.getSuperclass()).equals(c1)) continue;
            return true;
        } while (c != obj && c != null);
        return false;
    }

    protected String operationString(Method m) {
        return String.valueOf(this.operationString0(m)) + " " + this.operationString1(m);
    }

    protected String operationString0(Method m) {
        int dim = 0;
        Class<?> rType = m.getReturnType();
        String rName = rType.getName();
        String r = rType.isArray() ? (rName.charAt(dim = rName.lastIndexOf(91) + 1) == 'L' ? rName.substring(dim + 1, rName.length() - 1) : rName.substring(dim, rName.length())) : this.getTypeName(rType);
        return r;
    }

    protected String operationString1(Method m) {
        String r = String.valueOf(m.getName()) + "(";
        Class<?>[] pTypes = m.getParameterTypes();
        int i = 0;
        while (i < pTypes.length) {
            r = String.valueOf(r) + this.getTypeName(pTypes[i]);
            if (i + 1 < pTypes.length) {
                r = String.valueOf(r) + ", ";
            }
            ++i;
        }
        r = String.valueOf(r) + ")";
        if (m.getReturnType().isArray()) {
            int dim = m.getReturnType().getName().lastIndexOf(91) + 1;
            int i2 = 0;
            while (i2 < dim) {
                r = String.valueOf(r) + "[]";
                ++i2;
            }
        }
        return r;
    }

    protected String getTypeName(Class c) {
        int bIndex;
        if (c.isPrimitive()) {
            if (c == Boolean.TYPE) {
                return "boolean";
            }
            if (c == Byte.TYPE) {
                return "byte";
            }
            if (c == Character.TYPE) {
                return "char";
            }
            if (c == Short.TYPE) {
                return "short";
            }
            if (c == Integer.TYPE) {
                return "int";
            }
            if (c == Long.TYPE) {
                return "long";
            }
            if (c == Float.TYPE) {
                return "float";
            }
            if (c == Double.TYPE) {
                return "double";
            }
            if (c == Void.TYPE) {
                return "void";
            }
            return null;
        }
        if (!c.isArray()) {
            return c.getName();
        }
        String tName = c.getName();
        if (tName.charAt((bIndex = tName.lastIndexOf(91)) + 1) == 'L') {
            tName = tName.substring(bIndex + 2, tName.length() - 1);
        } else {
            char type = tName.charAt(bIndex + 1);
            if (type == 'Z') {
                tName = "boolean";
            }
            if (type == 'B') {
                tName = "byte";
            }
            if (type == 'C') {
                tName = "char";
            }
            if (type == 'S') {
                tName = "short";
            }
            if (type == 'I') {
                tName = "int";
            }
            if (type == 'J') {
                tName = "long";
            }
            if (type == 'F') {
                tName = "float";
            }
            if (type == 'D') {
                tName = "double";
            }
            if (type == 'V') {
                tName = "void";
            }
        }
        int i = 0;
        while (i <= bIndex) {
            tName = String.valueOf(tName) + "[]";
            ++i;
        }
        return tName;
    }

    protected String packageName() {
        String name = this.remoteClass.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return name.substring(0, index);
    }

    protected String className() {
        String name = this.remoteClass.getName();
        int index = name.lastIndexOf(46);
        return name.substring(index + 1, name.length());
    }

    protected String[] interfaces() {
        Class[] ints = RMIUtil.getAllRemoteInterfaces(this.remoteClass);
        String[] r = new String[ints.length];
        int i = 0;
        while (i < r.length) {
            r[i] = ints[i].getName();
            ++i;
        }
        return r;
    }

    protected boolean isRmiClass(Class testClass) {
        int i = 0;
        while (i < rmiImplClasses.length) {
            if (rmiImplClasses[i].equals(testClass)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

