/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.rmi.util;

import com.ibm.oti.util.SHAOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;

public class RMIUtil {
    static final Class objClass;
    static final Class remoteClass;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objClass = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.rmi.Remote");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        remoteClass = clazz2;
    }

    public static Class[] getAllRemoteInterfaces(Class c) {
        Vector remoteInterfaces = new Vector();
        RMIUtil.getAllRemoteInterfaces(c, new Hashtable(16), remoteInterfaces);
        Class[] r = new Class[remoteInterfaces.size()];
        int i = 0;
        while (i < r.length) {
            r[i] = (Class)remoteInterfaces.elementAt(i);
            ++i;
        }
        return r;
    }

    private static boolean getAllRemoteInterfaces(Class c, Hashtable foundInterfaces, Vector result) {
        if (c == remoteClass) {
            return true;
        }
        boolean remote = false;
        Class supercl = c.getSuperclass();
        if (supercl != null && supercl != objClass) {
            remote = RMIUtil.getAllRemoteInterfaces(supercl, foundInterfaces, result);
        }
        Class<?>[] cInterfaces = c.getInterfaces();
        int i = 0;
        while (i < cInterfaces.length) {
            Class<?> cInt = cInterfaces[i];
            if (cInt.isAssignableFrom(remoteClass) || foundInterfaces.containsKey(cInt)) {
                remote = true;
            } else if (RMIUtil.getAllRemoteInterfaces(cInt, foundInterfaces, result)) {
                remote = true;
                foundInterfaces.put(cInt, cInt);
                result.addElement(cInt);
            }
            ++i;
        }
        return remote;
    }

    public static String descriptorFor(Class c) {
        if (c.isArray()) {
            return c.getName().replace('.', '/');
        }
        if (c.isPrimitive()) {
            if (c == Void.TYPE) {
                return "V";
            }
            if (c == Boolean.TYPE) {
                return "Z";
            }
            if (c == Byte.TYPE) {
                return "B";
            }
            if (c == Character.TYPE) {
                return "C";
            }
            if (c == Short.TYPE) {
                return "S";
            }
            if (c == Integer.TYPE) {
                return "I";
            }
            if (c == Long.TYPE) {
                return "J";
            }
            if (c == Float.TYPE) {
                return "F";
            }
            if (c == Double.TYPE) {
                return "D";
            }
            return null;
        }
        return "L" + c.getName().replace('.', '/') + ";";
    }

    private static String descriptorFor(Method m) {
        String r = "(";
        Class<?>[] pTypes = m.getParameterTypes();
        int i = 0;
        while (i < pTypes.length) {
            r = String.valueOf(r) + RMIUtil.descriptorFor(pTypes[i]);
            ++i;
        }
        r = String.valueOf(r) + ")" + RMIUtil.descriptorFor(m.getReturnType());
        return r;
    }

    public static long littleEndianLongAt(byte[] buffer, int position) {
        int startPos;
        long result = 0L;
        int i = startPos = position + 7;
        while (i >= position) {
            result = (result << 8) + (long)(buffer[i] & 0xFF);
            --i;
        }
        return result;
    }

    public static long hashFor(Method m) throws IOException {
        SHAOutputStream sha = new SHAOutputStream();
        DataOutputStream output = new DataOutputStream(sha);
        output.writeUTF(String.valueOf(m.getName()) + RMIUtil.descriptorFor(m));
        byte[] hash = sha.getHashAsBytes();
        return RMIUtil.littleEndianLongAt(hash, 0);
    }
}

