/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.rmi.wire;

import com.ibm.oti.rmi.RMIObjectInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.net.Socket;

public abstract class Protocol {
    public static final short Version = 2;
    public static final byte StreamProtocol = 75;
    public static final byte SingleOpProtocol = 76;
    public static final byte MultiplexProtocol = 77;
    public static final int HeaderPrefix = 1246907721;
    public static final byte CallPrefix = 80;
    public static final byte Ping = 82;
    public static final byte DgcAckPrefix = 84;
    public static final byte ProtocolAck = 78;
    public static final byte ProtocolNotSupported = 79;
    public static final byte ReturnDataPrefix = 81;
    public static final byte PingAck = 83;
    public static final byte ReturnValuePrefix = 1;
    public static final byte ReturnExceptionPrefix = 2;
    Socket conn;
    DataInputStream dis;
    DataOutputStream dos;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    Protocol() throws IOException {
    }

    Protocol(Socket s) throws IOException {
        this.init(s);
    }

    void init(Socket s) throws IOException {
        this.conn = s;
        this.dos = new DataOutputStream(new BufferedOutputStream(this.conn.getOutputStream()));
        this.dis = new DataInputStream(new BufferedInputStream(this.conn.getInputStream()));
    }

    public void flushOutputStream() throws IOException {
        this.dos.flush();
    }

    public InputStream getInputStream() {
        return this.dis;
    }

    public OutputStream getOutputStream() {
        return this.dos;
    }

    public Object readObject(Class c, ObjectInput ois) throws IOException, ClassNotFoundException {
        if (c.isPrimitive()) {
            if (c == Boolean.TYPE) {
                return new Boolean(ois.readBoolean());
            }
            if (c == Byte.TYPE) {
                return new Byte(ois.readByte());
            }
            if (c == Character.TYPE) {
                return new Character(ois.readChar());
            }
            if (c == Short.TYPE) {
                return new Short(ois.readShort());
            }
            if (c == Integer.TYPE) {
                return new Integer(ois.readInt());
            }
            if (c == Long.TYPE) {
                return new Long(ois.readLong());
            }
            if (c == Float.TYPE) {
                return new Float(ois.readFloat());
            }
            if (c == Double.TYPE) {
                return new Double(ois.readDouble());
            }
            return null;
        }
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("java.rmi.Remote");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(clazz.isAssignableFrom(c) || c.getName().startsWith("java.rmi") || c.getName().startsWith("java.lang") || c.getName().startsWith("[Ljava.rmi"))) {
            ((RMIObjectInputStream)ois).setCloader(c.getClassLoader());
        }
        return ois.readObject();
    }

    public void writeObject(Class c, Object result, ObjectOutput oos) throws IOException {
        if (c.isPrimitive()) {
            if (c == Void.TYPE) {
                return;
            }
            if (c == Boolean.TYPE) {
                oos.writeBoolean((Boolean)result);
                return;
            }
            if (c == Byte.TYPE) {
                oos.writeByte(((Byte)result).byteValue());
                return;
            }
            if (c == Character.TYPE) {
                oos.writeChar(((Character)result).charValue());
                return;
            }
            if (c == Short.TYPE) {
                oos.writeShort(((Short)result).shortValue());
                return;
            }
            if (c == Integer.TYPE) {
                oos.writeInt((Integer)result);
                return;
            }
            if (c == Long.TYPE) {
                oos.writeLong((Long)result);
                return;
            }
            if (c == Float.TYPE) {
                oos.writeFloat(((Float)result).floatValue());
                return;
            }
            if (c == Double.TYPE) {
                oos.writeDouble((Double)result);
                return;
            }
        } else {
            oos.writeObject(result);
        }
    }
}

