/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.rmi.wire;

import com.ibm.oti.rmi.EndpointID;
import com.ibm.oti.rmi.wire.Protocol;
import com.ibm.oti.rmi.wire.StreamProtocolClient;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.Socket;
import java.rmi.MarshalException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ProtocolClient
extends Protocol {
    private static final byte Locked = -1;
    private static final byte Invalid = -2;
    private static final byte GCPasses = 3;
    private static final byte GCCollect = 0;
    private byte status = (byte)3;
    static Hashtable connections = new Hashtable();

    static {
        ConnectionGC t = new ConnectionGC("RMI-ConnectionGC");
        t.setDaemon(true);
        t.start();
    }

    protected abstract void sendHeader() throws IOException, MarshalException;

    public abstract void sendMessageCallHeader() throws IOException;

    public abstract void sendMessageReceiver(ObjectOutput var1, ObjID var2, int var3, long var4) throws IOException;

    public abstract void waitReturnHeader() throws IOException;

    public abstract void waitReturnValueHeader(ObjectInput var1) throws Exception;

    public abstract ObjectOutput createObjectOutput() throws IOException;

    public abstract ObjectInput createObjectInput() throws IOException;

    public abstract void close();

    ProtocolClient() throws IOException {
    }

    ProtocolClient(Socket s) throws IOException {
        super(s);
    }

    public static ProtocolClient clientFor(EndpointID epid, byte protocol, RMIClientSocketFactory csf) throws IOException {
        Hashtable hashtable = connections;
        synchronized (hashtable) {
            ProtocolClient pc;
            Vector<ProtocolClient> pcs = (Vector<ProtocolClient>)connections.get(epid);
            if (pcs == null) {
                pcs = new Vector<ProtocolClient>();
                ProtocolClient pc2 = ProtocolClient.newClient(epid, protocol, csf);
                pcs.add(pc2);
                connections.put(epid, pcs);
                pc2.lock();
                return pc2;
            }
            while (true) {
                pc = null;
                try {
                    int i = 0;
                    while (i < pcs.size()) {
                        pc = (ProtocolClient)pcs.elementAt(i);
                        if (pc.isFree()) {
                            pc.lock();
                            pc.conn.getInputStream().available();
                            return pc;
                        }
                        ++i;
                    }
                }
                catch (IOException iOException) {
                    if (pc == null) continue;
                    pc.markInvalid();
                    continue;
                }
                break;
            }
            pc = ProtocolClient.newClient(epid, protocol, csf);
            pcs.add(pc);
            pc.lock();
            return pc;
        }
    }

    private static ProtocolClient newClient(EndpointID epid, int protocol, RMIClientSocketFactory csf) throws IOException {
        if (protocol == 75) {
            return new StreamProtocolClient(epid, csf);
        }
        return null;
    }

    protected void lock() {
        this.status = (byte)-1;
    }

    public void release() {
        Hashtable hashtable = connections;
        synchronized (hashtable) {
            this.status = (byte)3;
        }
    }

    public void markInvalid() {
        Hashtable hashtable = connections;
        synchronized (hashtable) {
            this.status = (byte)-2;
        }
    }

    protected boolean isFree() {
        return this.status > 0;
    }

    static class ConnectionGC
    extends Thread {
        static int socketConnectionTimeOutValue = -1;

        protected ConnectionGC(String name) {
            super(name);
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(ConnectionGC.getConnectionTimeOutValue() / 3);
                }
                catch (InterruptedException interruptedException) {}
                Hashtable hashtable = connections;
                synchronized (hashtable) {
                    Enumeration endpoints = connections.keys();
                    while (endpoints.hasMoreElements()) {
                        EndpointID epid = (EndpointID)endpoints.nextElement();
                        Vector pcs = (Vector)connections.get(epid);
                        ProtocolClient[] pcsArray = new ProtocolClient[pcs.size()];
                        pcs.toArray(pcsArray);
                        int i = 0;
                        while (i < pcsArray.length) {
                            ProtocolClient pc = pcsArray[i];
                            if (pc.status == -2) {
                                pcs.remove(pc);
                                pc.close();
                            }
                            if (pc.isFree()) {
                                ProtocolClient protocolClient = pc;
                                protocolClient.status = (byte)(protocolClient.status - 1);
                                if (pc.status == 0) {
                                    pcs.remove(pc);
                                    pc.close();
                                }
                            }
                            ++i;
                        }
                        if (pcs.size() != 0) continue;
                        connections.remove(epid);
                    }
                }
            }
        }

        static int getConnectionTimeOutValue() {
            if (socketConnectionTimeOutValue == -1) {
                String defaultValue = new Integer(15000).toString();
                String value = (String)AccessController.doPrivileged(new PrivilegedAction(defaultValue){
                    private final /* synthetic */ String val$defaultValue;
                    {
                        this.val$defaultValue = string;
                    }

                    public Object run() {
                        return System.getProperty("com.ibm.oti.rmi.connectionTimeout", this.val$defaultValue);
                    }
                });
                try {
                    socketConnectionTimeOutValue = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    socketConnectionTimeOutValue = 15000;
                }
            }
            return socketConnectionTimeOutValue;
        }
    }
}

