/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.rmi.wire;

import com.ibm.oti.rmi.wire.ProtocolServer;
import com.ibm.oti.rmi.wire.StreamProtocolServer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.server.RMIFailureHandler;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public class RMIServer
extends Thread {
    static int socketReadTimeOutValue = -1;
    private ServerSocket ss;
    private byte protocol;
    private int references = 0;
    static RMIServer defaultServer;
    static Hashtable servers;

    static {
        servers = new Hashtable();
    }

    private RMIServer(String name) {
        super(name);
    }

    public static RMIServer serverFor(int port, byte protocol, RMIServerSocketFactory ssf) throws IOException {
        if (port == 0) {
            Hashtable hashtable = servers;
            synchronized (hashtable) {
                if (defaultServer != null) {
                    return defaultServer;
                }
                defaultServer = RMIServer.startServer(port, protocol, ssf);
                RMIServer.defaultServer.references = 1;
                return defaultServer;
            }
        }
        Hashtable hashtable = servers;
        synchronized (hashtable) {
            RMIServer s = (RMIServer)servers.get(new Integer(port));
            if (s == null) {
                s = RMIServer.startServer(port, protocol, ssf);
            }
            ++s.references;
            servers.put(new Integer(port), s);
            return s;
        }
    }

    public static RMIServer serverFor(int port) {
        if (port == 0) {
            return defaultServer;
        }
        return (RMIServer)servers.get(new Integer(port));
    }

    private static ProtocolServer newServer(Socket s, byte protocol) throws IOException {
        if (protocol == 75) {
            return new StreamProtocolServer(s);
        }
        return null;
    }

    private static RMIServer startServer(int port, byte protocol, RMIServerSocketFactory ssf) throws IOException {
        ServerSocket ss = ssf.createServerSocket(port);
        RMIServer s = new RMIServer("RMI-Accept:" + ss.getLocalPort());
        s.ss = ss;
        s.protocol = protocol;
        s.setDaemon(true);
        s.start();
        return s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        if (this != defaultServer) {
            try {
                this.ss.setSoTimeout(60000);
            }
            catch (SocketException socketException) {}
        }
        while (true) {
            Object s;
            try {
                s = this.ss.accept();
                ((Socket)s).setSoTimeout(RMIServer.getSocketReadTimeOutValue());
                RMIServer.newServer((Socket)s, this.protocol);
                continue;
            }
            catch (InterruptedIOException interruptedIOException) {
                if (this.references > 0) continue;
                s = servers;
                synchronized (s) {
                    if (this.references <= 0) {
                        try {
                            this.ss.close();
                        }
                        catch (IOException iOException) {}
                        if (servers.get(new Integer(this.ss.getLocalPort())) == this) {
                            servers.remove(new Integer(this.ss.getLocalPort()));
                        }
                        return;
                    }
                    continue;
                }
            }
            catch (IOException ex) {
                RMIFailureHandler fh = RMISocketFactory.getFailureHandler();
                if (fh != null && !fh.failure(ex)) return;
                continue;
            }
            break;
        }
    }

    static int getSocketReadTimeOutValue() {
        if (socketReadTimeOutValue == -1) {
            final String defaultValue = new Integer(0x6DDD00).toString();
            String value = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("com.ibm.oti.rmi.readTimeout", defaultValue);
                }
            });
            try {
                socketReadTimeOutValue = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                socketReadTimeOutValue = 0x6DDD00;
            }
        }
        return socketReadTimeOutValue;
    }

    public int getLocalPort() {
        return this.ss.getLocalPort();
    }

    public void decReference() {
        if (this != defaultServer) {
            --this.references;
        }
    }
}

