/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.rmi.wire;

import com.ibm.oti.rmi.EndpointID;
import com.ibm.oti.rmi.RMIObjectInputStream;
import com.ibm.oti.rmi.RMIObjectOutputStream;
import com.ibm.oti.rmi.util.Msg;
import com.ibm.oti.rmi.wire.ProtocolClient;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.UID;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class StreamProtocolClient
extends ProtocolClient {
    static int handshakeTimeoutValue = -1;

    StreamProtocolClient(EndpointID epid, RMIClientSocketFactory csf) throws IOException {
        this.startClient(epid, csf);
    }

    void startClient(EndpointID epid, RMIClientSocketFactory csf) throws IOException {
        String epidString = String.valueOf(epid.getHost()) + ":" + epid.getPort();
        try {
            Socket s = csf.createSocket(epid.getHost(), epid.getPort());
            this.init(s);
        }
        catch (UnknownHostException e) {
            throw new java.rmi.UnknownHostException(String.valueOf(Msg.getString("R0055")) + epidString, e);
        }
        catch (ConnectException e) {
            throw new java.rmi.ConnectException(String.valueOf(Msg.getString("R0056")) + epidString, e);
        }
        catch (IOException e) {
            throw new ConnectIOException(String.valueOf(Msg.getString("R0057")) + epidString, e);
        }
        this.sendHeader();
    }

    public void close() {
        try {
            this.conn.close();
        }
        catch (IOException iOException) {}
    }

    protected void sendHeader() throws IOException, MarshalException {
        this.dos.writeInt(1246907721);
        this.dos.writeShort(2);
        this.dos.writeByte(75);
        this.dos.flush();
        byte protocolAck = this.dis.readByte();
        if (protocolAck != 78) {
            try {
                this.conn.close();
            }
            catch (IOException iOException) {}
            throw new MarshalException(Msg.getString("R0037"));
        }
        this.dis.readUTF();
        this.dis.readInt();
        this.dos.writeUTF(this.conn.getInetAddress().getHostAddress());
        this.dos.writeInt(this.conn.getPort());
        this.dos.flush();
    }

    static int gethandshakeTimeoutValue() {
        if (handshakeTimeoutValue == -1) {
            final String defaultValue = new Integer(60000).toString();
            String value = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("com.ibm.oti.rmi.handshakeTimeout", defaultValue);
                }
            });
            try {
                handshakeTimeoutValue = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                handshakeTimeoutValue = 60000;
            }
        }
        return handshakeTimeoutValue;
    }

    public void sendMessageCallHeader() throws IOException {
        this.dos.writeByte(80);
    }

    public void sendMessageReceiver(ObjectOutput oos, ObjID id, int operation, long hash) throws IOException {
        id.write(oos);
        oos.writeInt(operation);
        oos.writeLong(hash);
        oos.flush();
    }

    public void waitReturnHeader() throws IOException {
        this.dis.readByte();
    }

    public void waitReturnValueHeader(ObjectInput ois) throws Exception {
        byte prefix = ois.readByte();
        UID.read(ois);
        if (prefix == 2) {
            Exception ex;
            try {
                ex = (Exception)ois.readObject();
            }
            catch (Exception e) {
                this.markInvalid();
                throw new RemoteException(Msg.getString("R0052"), e);
            }
            this.markInvalid();
            throw ex;
        }
    }

    public ObjectOutput createObjectOutput() throws IOException {
        return new RMIObjectOutputStream(this.dos);
    }

    public ObjectInput createObjectInput() throws IOException {
        return new RMIObjectInputStream(this.dis);
    }
}

