/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.rmi.wire;

import com.ibm.oti.rmi.RMIObjectInputStream;
import com.ibm.oti.rmi.RMIObjectOutputStream;
import com.ibm.oti.rmi.RMIServerTable;
import com.ibm.oti.rmi.RemoteCallServer;
import com.ibm.oti.rmi.UnicastRef;
import com.ibm.oti.rmi.util.Msg;
import com.ibm.oti.rmi.wire.CallData;
import com.ibm.oti.rmi.wire.ProtocolServer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnexpectedException;
import java.rmi.UnmarshalException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteServer;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonNotFoundException;
import java.rmi.server.UID;

public class StreamProtocolServer
extends ProtocolServer
implements Runnable {
    public static final String ThreadPrefix = "RMI-ServerConnection:";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    StreamProtocolServer(Socket s) throws IOException {
        this.startServer(s);
    }

    public void run() {
        RMIObjectInputStream ois;
        CallData data;
        try {
            this.waitHeader();
        }
        catch (IOException iOException) {
            return;
        }
        do {
            try {
                this.waitMessageCallHeader();
            }
            catch (InterruptedIOException interruptedIOException) {
                try {
                    this.conn.close();
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IOException iOException) {
                try {
                    this.conn.close();
                }
                catch (IOException iOException2) {}
                return;
            }
            try {
                ois = new RMIObjectInputStream(this.dis);
                data = this.waitMessageReceiver(ois);
            }
            catch (IOException ex) {
                this.sendException(new UnmarshalException(Msg.getString("R0038", ""), ex));
                return;
            }
        } while (this.dispatch(data, ois));
        try {
            this.conn.close();
        }
        catch (IOException iOException) {}
    }

    private void startServer(Socket s) throws IOException {
        this.init(s);
        Thread serv = new Thread(null, this, ThreadPrefix + s.getInetAddress().getHostAddress());
        serv.start();
    }

    public void waitHeader() throws IOException {
        try {
            int header = this.dis.readInt();
            this.dis.readShort();
            byte protocol = this.dis.readByte();
            if (header != 1246907721 || protocol != 75) {
                this.dos.write(79);
                this.conn.close();
                return;
            }
            this.dos.write(78);
            this.dos.writeUTF(this.conn.getInetAddress().getHostAddress());
            this.dos.writeInt(this.conn.getPort());
            this.dos.flush();
            this.dis.readUTF();
            this.dis.readInt();
        }
        catch (IOException ex) {
            try {
                this.conn.close();
            }
            catch (IOException iOException) {}
            throw ex;
        }
    }

    public void waitMessageCallHeader() throws IOException {
        while (true) {
            int read;
            if ((read = this.dis.read()) == -1) {
                throw new IOException(Msg.getString("R0039"));
            }
            if (read == 82) {
                this.dos.writeByte(83);
                this.dos.flush();
                continue;
            }
            if (read == 80) {
                return;
            }
            if (read != 84) break;
            UID.read(this.dis);
        }
    }

    public CallData waitMessageReceiver(ObjectInput ois) throws IOException {
        ObjID receiver = ObjID.read(ois);
        int operation = ois.readInt();
        long hash = ois.readLong();
        return new CallData(receiver, operation, hash, null);
    }

    private void sendException(Throwable ex) {
        try {
            this.sendReturnHeader();
            RMIObjectOutputStream oos = new RMIObjectOutputStream(this.dos);
            this.sendReturnValueHeader(false, oos);
            oos.writeObject(ex);
            oos.flush();
            this.logException(ex);
        }
        catch (IOException iOException) {
            try {
                this.conn.close();
            }
            catch (IOException iOException2) {}
        }
    }

    private void logException(Throwable ex) {
        try {
            PrintStream logger = RemoteServer.getLog();
            if (logger != null) {
                this.conn.getInetAddress();
                String clientAddress = InetAddress.getLocalHost().getHostAddress();
                logger.print("[" + clientAddress + "] ");
                ex.printStackTrace(logger);
            }
        }
        catch (Exception exception) {}
    }

    private void logMethodCall(Remote obj, String methodString) {
        try {
            PrintStream logger = RemoteServer.getLog();
            if (logger != null) {
                this.conn.getInetAddress();
                String clientAddress = InetAddress.getLocalHost().getHostAddress();
                logger.println("[" + clientAddress + ": " + obj.getClass().getName() + "[" + obj.hashCode() + "]" + ": " + methodString + "]");
            }
        }
        catch (Exception exception) {}
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean dispatch(CallData data, ObjectInput ois) {
        block31: {
            block30: {
                obj = RMIServerTable.getObj(data.id());
                if (obj == null) {
                    this.sendException(new NoSuchObjectException(String.valueOf(Msg.getString("R0058")) + data.id()));
                    return false;
                }
                RMIServerTable.increaseCallCount(data.id());
                try {
                    if (data.opNumber() == -1) {
                        m = RMIServerTable.getMethod(obj, data.hash());
                        if (m == null) {
                            this.sendException(new UnmarshalException(Msg.getString("R0040", obj.getClass(), new Long(data.hash()))));
                            var10_6 = null;
                            break block30;
                        }
                        args = new Object[m.getParameterTypes().length];
                        try {
                            i = 0;
                            while (i < args.length) {
                                args[i] = this.readObject(m.getParameterTypes()[i], ois);
                                ++i;
                            }
                        }
                        catch (Exception ex) {
                            this.sendException(new ServerException(Msg.getString("R0059"), new UnmarshalException(Msg.getString("R0007"), ex)));
                            var10_7 = null;
                            RMIServerTable.decreaseCallCount(data.id());
                            return false;
                        }
                        this.logMethodCall(obj, m.toString());
                        try {
                            result = m.invoke((Object)obj, args);
                        }
                        catch (InvocationTargetException ex) {
                            t = ex.getTargetException();
                            this.handleInvocationTargetException(m, t);
                            var10_8 = null;
                            RMIServerTable.decreaseCallCount(data.id());
                            return false;
                        }
                        catch (Exception ex) {
                            this.sendException(ex);
                            var10_9 = null;
                            RMIServerTable.decreaseCallCount(data.id());
                            return false;
                        }
                        try {
                            this.sendReturnHeader();
                            oos = new RMIObjectOutputStream(this.dos);
                            this.sendReturnValueHeader(true, oos);
                            this.writeObject(m.getReturnType(), result, oos);
                            oos.flush();
                            break block31;
                        }
                        catch (Exception v0) {
                            var10_10 = null;
                            RMIServerTable.decreaseCallCount(data.id());
                            return false;
                        }
                    }
                    objClass = obj.getClass();
                    try {
                        annotation = RMIClassLoader.getClassAnnotation(objClass);
                    }
                    catch (Exception ex) {
                        this.sendException(new UnmarshalException(Msg.getString("R0041", objClass), ex));
                        var10_11 = null;
                        RMIServerTable.decreaseCallCount(data.id());
                        return false;
                    }
                    try {
                        v1 = StreamProtocolServer.class$0;
                        if (v1 == null) {
                            try {
                                v2 = Class.forName("com.ibm.oti.rmi.dgc.DGCImpl");
                            }
                            catch (ClassNotFoundException v3) {
                                throw new NoClassDefFoundError(v3.getMessage());
                            }
                            v1 = StreamProtocolServer.class$0 = v2;
                        }
                        if (objClass == v1) ** GOTO lbl-1000
                        v4 = StreamProtocolServer.class$1;
                        if (v4 == null) {
                            try {
                                v5 = Class.forName("com.ibm.oti.rmi.registry.RegistryImpl");
                            }
                            catch (ClassNotFoundException v6) {
                                throw new NoClassDefFoundError(v6.getMessage());
                            }
                            v4 = StreamProtocolServer.class$1 = v5;
                        }
                        if (objClass == v4) lbl-1000:
                        // 2 sources

                        {
                            v7 = Class.forName(String.valueOf(objClass.getName()) + "_Skel");
                        } else {
                            v7 = RMIClassLoader.loadClass(annotation, String.valueOf(objClass.getName()) + "_Skel");
                        }
                        skelClass = v7;
                        skel = (Skeleton)skelClass.newInstance();
                    }
                    catch (ClassNotFoundException ex) {
                        this.sendException(new SkeletonNotFoundException(String.valueOf(objClass.getName()) + "_Skel", ex));
                        var10_12 = null;
                        RMIServerTable.decreaseCallCount(data.id());
                        return false;
                    }
                    catch (Exception ex) {
                        this.sendException(new SkeletonNotFoundException(Msg.getString("R0006", String.valueOf(objClass.getName()) + "_Skel"), ex));
                        var10_13 = null;
                        RMIServerTable.decreaseCallCount(data.id());
                        return false;
                    }
                    remoteCall = new RemoteCallServer(this, ois);
                    methodString = null;
                    try {
                        methodString = skel.getOperations()[data.opNumber()].toString();
                    }
                    catch (Exception v8) {}
                    this.logMethodCall(obj, methodString);
                    try {
                        skel.dispatch(obj, remoteCall, data.opNumber(), data.hash());
                        remoteCall.flush();
                        break block31;
                    }
                    catch (Exception ex) {
                        this.sendException(ex);
                        var10_14 = null;
                        RMIServerTable.decreaseCallCount(data.id());
                        return false;
                    }
                }
                catch (Throwable var11_33) {
                    var10_15 = null;
                    RMIServerTable.decreaseCallCount(data.id());
                    throw var11_33;
                }
            }
            RMIServerTable.decreaseCallCount(data.id());
            return false;
        }
        var10_16 = null;
        RMIServerTable.decreaseCallCount(data.id());
        return true;
    }

    private void handleInvocationTargetException(Method m, Throwable t) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.rmi.RemoteException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(t.getClass())) {
            this.sendException(new ServerException(Msg.getString("R0059"), (RemoteException)t));
            return;
        }
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("java.lang.Error");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.isAssignableFrom(t.getClass())) {
            this.sendException(new ServerError(Msg.getString("R0060"), (Error)t));
            return;
        }
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("java.lang.RuntimeException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.isAssignableFrom(t.getClass())) {
            this.sendException((RuntimeException)t);
            return;
        }
        boolean exceptionIsDeclared = false;
        Class<?>[] exceptions = m.getExceptionTypes();
        int i = 0;
        while (i < exceptions.length) {
            if (exceptions[i].isAssignableFrom(t.getClass())) {
                exceptionIsDeclared = true;
                break;
            }
            ++i;
        }
        if (exceptionIsDeclared) {
            this.sendException(t);
            return;
        }
        this.sendException(new UnexpectedException(null, (Exception)t));
    }

    public void sendReturnHeader() throws IOException {
        this.dos.writeByte(81);
    }

    public void sendReturnValueHeader(boolean success, ObjectOutput oos) throws IOException {
        if (success) {
            oos.writeByte(1);
        } else {
            oos.writeByte(2);
        }
        oos.flush();
        UnicastRef.LocalUID.write(oos);
        oos.flush();
    }
}

