/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import com.ibm.oti.rmi.RMIObjectInputStream;
import com.ibm.oti.rmi.RMIObjectOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.rmi.server.RMIClassLoader;

public final class MarshalledObject
implements Serializable {
    private static final long serialVersionUID = 8988374069173025854L;
    int hash;
    byte[] locBytes;
    byte[] objBytes;

    public MarshalledObject(Object o) throws IOException {
        if (o != null) {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            RMIMarshalledObjectOutputStream oos = new RMIMarshalledObjectOutputStream(ba);
            oos.writeObject(o);
            oos.close();
            this.objBytes = ba.toByteArray();
            this.locBytes = oos.getAnnotations().toByteArray();
            this.hash = o.hashCode();
        }
    }

    public Object get() throws IOException, ClassNotFoundException {
        if (this.objBytes == null) {
            return null;
        }
        ByteArrayInputStream ba = new ByteArrayInputStream(this.objBytes);
        ByteArrayInputStream ba2 = new ByteArrayInputStream(this.locBytes);
        RMIMarshalledObjectInputStream ois = new RMIMarshalledObjectInputStream(ba, ba2);
        return ois.readObject();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (!(o instanceof MarshalledObject)) {
            return false;
        }
        MarshalledObject mo = (MarshalledObject)o;
        if (this.hash != mo.hash) {
            return false;
        }
        if (this.objBytes == null && mo.objBytes != null) {
            return false;
        }
        return this.objBytes == null || mo.objBytes != null;
    }

    class RMIMarshalledObjectInputStream
    extends RMIObjectInputStream {
        transient ObjectInputStream oisAnnotations;

        protected RMIMarshalledObjectInputStream(InputStream in, ByteArrayInputStream ba) throws StreamCorruptedException, IOException {
            super(in);
            this.oisAnnotations = new ObjectInputStream(ba);
        }

        protected Class resolveClass(ObjectStreamClass osClass) throws IOException, ClassNotFoundException {
            String annotation = (String)this.oisAnnotations.readObject();
            return RMIClassLoader.loadClass(annotation, osClass.getName());
        }
    }

    class RMIMarshalledObjectOutputStream
    extends RMIObjectOutputStream {
        transient ObjectOutputStream oosAnnotations;
        transient ByteArrayOutputStream baAnnotations = new ByteArrayOutputStream();

        protected RMIMarshalledObjectOutputStream(OutputStream out) throws StreamCorruptedException, IOException {
            super(out);
            this.oosAnnotations = new ObjectOutputStream(this.baAnnotations);
        }

        protected void annotateClass(Class aClass) throws IOException {
            String annotation = RMIClassLoader.getClassAnnotation(aClass);
            this.oosAnnotations.writeObject(annotation);
        }

        protected ByteArrayOutputStream getAnnotations() throws IOException {
            this.oosAnnotations.flush();
            return this.baAnnotations;
        }
    }
}

