/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import com.ibm.oti.rmi.util.Msg;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RemoteObject;

public final class Naming {
    private Naming() {
    }

    public static Remote lookup(String url) throws RemoteException, MalformedURLException, NotBoundException {
        Name n = new Name(url);
        Registry r = Naming.registryStub(n.host, n.port);
        return r.lookup(n.objName);
    }

    public static void bind(String url, Remote obj) throws AlreadyBoundException, MalformedURLException, RemoteException {
        if (obj == null) {
            throw new NullPointerException();
        }
        Name n = new Name(url);
        Naming.chechAccess(n.host);
        Registry r = Naming.registryStub(n.host, n.port);
        r.bind(n.objName, RemoteObject.toStub(obj));
    }

    public static void unbind(String url) throws RemoteException, NotBoundException, MalformedURLException {
        Name n = new Name(url);
        Naming.chechAccess(n.host);
        Registry r = Naming.registryStub(n.host, n.port);
        r.unbind(n.objName);
    }

    public static void rebind(String url, Remote obj) throws RemoteException, MalformedURLException {
        if (obj == null) {
            throw new NullPointerException();
        }
        Name n = new Name(url);
        Naming.chechAccess(n.host);
        Registry r = Naming.registryStub(n.host, n.port);
        r.rebind(n.objName, RemoteObject.toStub(obj));
    }

    public static String[] list(String url) throws RemoteException, MalformedURLException {
        Name n = new Name(url);
        Registry r = Naming.registryStub(n.host, n.port);
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        String[] newList = r.list();
        int i = 0;
        while (i < newList.length) {
            newList[i] = String.valueOf(url) + newList[i];
            ++i;
        }
        return newList;
    }

    private static void chechAccess(String host) throws AccessException, RemoteException {
        if (host.equals("localhost") || host.equals("127.0.0.1")) {
            return;
        }
        try {
            if (InetAddress.getByName(host).equals(InetAddress.getLocalHost())) {
                return;
            }
        }
        catch (java.net.UnknownHostException e) {
            throw new UnknownHostException(String.valueOf(Msg.getString("R0055")) + host, e);
        }
        throw new AccessException("A remote object can not be bound in a registry in another host.");
    }

    private static Registry registryStub(String host, int port) throws RemoteException {
        return LocateRegistry.getRegistry(host, port);
    }

    static class Name {
        String host;
        int port;
        String objName;

        Name(String urlString) throws MalformedURLException {
            if (urlString.startsWith("rmi:")) {
                urlString = urlString.substring(4);
                urlString = "http:" + urlString;
            } else {
                if (urlString.indexOf(":/") != -1) {
                    throw new MalformedURLException("No need to specify protocol: " + urlString);
                }
                urlString = urlString.startsWith("//") ? "http:" + urlString : (urlString.startsWith("/") ? "http://localhost" + urlString : "http://localhost/" + urlString);
            }
            URL url = new URL(urlString);
            this.host = url.getHost();
            this.port = url.getPort();
            this.objName = url.getFile();
            if (this.objName.startsWith("/")) {
                this.objName = this.objName.substring(1, this.objName.length());
            }
            if (this.host == null || this.host.length() == 0) {
                this.host = "localhost";
            }
            if (this.port < 0) {
                this.port = 1099;
            }
        }
    }
}

