/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.dgc;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;

public final class VMID
implements Serializable {
    private static final long serialVersionUID = -538642295484486218L;
    byte[] addr;
    UID uid;
    private static InetAddress localAddress;

    static {
        try {
            localAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {}
    }

    public VMID() {
        if (localAddress != null) {
            this.addr = localAddress.getAddress();
        }
        this.uid = new UID();
    }

    public boolean equals(Object o) {
        if (!(o instanceof VMID)) {
            return false;
        }
        VMID id = (VMID)o;
        if (this.uid != null && this.uid.equals(id.uid)) {
            if (this.addr != null) {
                if (this.addr.length != id.addr.length) {
                    return false;
                }
                int i = 0;
                while (i < this.addr.length) {
                    if (this.addr[i] != id.addr[i]) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.uid.hashCode() * this.addr[this.addr.length - 1];
    }

    public String toString() {
        if (this.addr == null) {
            return "VMID:[0.0.0.0|" + this.uid + "]";
        }
        return "VMID:[" + this.addr[0] + "." + this.addr[1] + "." + this.addr[2] + "." + this.addr[3] + "||" + this.uid + "]";
    }

    public static boolean isUnique() {
        return localAddress != null;
    }
}

