/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import com.ibm.oti.rmi.RMIServerTable;
import com.ibm.oti.rmi.UnicastRef;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.rmi.server.UID;

public final class ObjID
implements Serializable {
    public static final int REGISTRY_ID = 0;
    public static final int ACTIVATOR_ID = 1;
    public static final int DGC_ID = 2;
    private static final long serialVersionUID = -6386392263968365220L;
    long objNum;
    UID space;
    static long instanceCount = 3L;

    public ObjID() {
        this.space = UnicastRef.LocalUID;
        this.objNum = instanceCount * 100L;
        this.objNum += (long)(RMIServerTable.idIndex() * 10);
        ++instanceCount;
    }

    public ObjID(int num) {
        this.space = new UID(0);
        this.objNum = num;
    }

    private ObjID(long num, UID s) {
        this.space = s;
        this.objNum = num;
    }

    public void write(ObjectOutput out) throws IOException {
        out.writeLong(this.objNum);
        this.space.write(out);
    }

    public static ObjID read(ObjectInput in) throws IOException {
        return new ObjID(in.readLong(), UID.read(in));
    }

    public int hashCode() {
        return (int)this.objNum;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjID) {
            ObjID o = (ObjID)obj;
            return this.objNum == o.objNum && this.space.equals(o.space);
        }
        return false;
    }

    public String toString() {
        return "ObjID:[" + this.objNum + "]";
    }
}

