/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import com.ibm.oti.rmi.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

public class RMIClassLoader {
    private static String codebase;
    private static boolean isCodebaseSet;
    private static WeakHashMap weakLoaders;

    static {
        isCodebaseSet = false;
        weakLoaders = new WeakHashMap(20);
    }

    private RMIClassLoader() {
    }

    public static ClassLoader getClassLoader(String codebase) throws MalformedURLException, SecurityException {
        if (codebase == null) {
            codebase = RMIClassLoader.getCodebase();
        }
        if (codebase == null) {
            codebase = "";
        }
        StringTokenizer tokenizer = new StringTokenizer(codebase, " ");
        String annotation = "";
        URL[] urls = new URL[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            URL url = new URL(tokenizer.nextToken());
            RMIClassLoader.checkPermission(url);
            urls[i] = url;
            ++i;
            annotation = String.valueOf(annotation) + " " + url.toExternalForm();
        }
        if (!annotation.equals("")) {
            annotation = annotation.trim();
        }
        URLClassLoader cLoader = null;
        ClassLoader parent = VM.getNonBootstrapClassLoader();
        if (parent == null) {
            parent = Thread.currentThread().getContextClassLoader();
        }
        WeakHashMap weakHashMap = weakLoaders;
        synchronized (weakHashMap) {
            Hashtable<String, URLClassLoader> loaders = (Hashtable<String, URLClassLoader>)weakLoaders.get(parent);
            if (loaders == null) {
                loaders = new Hashtable<String, URLClassLoader>(8);
                weakLoaders.put(parent, loaders);
            } else {
                cLoader = (URLClassLoader)loaders.get(annotation);
            }
            if (cLoader == null) {
                cLoader = URLClassLoader.newInstance(urls, parent);
                loaders.put(annotation, cLoader);
            }
        }
        return cLoader;
    }

    private static void checkPermission(URL url) throws SecurityException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                security.checkPermission(url.openConnection().getPermission());
            }
            catch (IOException ex) {
                throw new SecurityException(String.valueOf(Msg.getString("R0046")) + ": " + ex);
            }
        }
    }

    public static Class loadClass(String clName) throws MalformedURLException, ClassNotFoundException {
        return RMIClassLoader.loadClass(RMIClassLoader.getCodebase(), clName);
    }

    public static Class loadClass(URL codebase, String clName) throws MalformedURLException, ClassNotFoundException {
        if (codebase == null) {
            return RMIClassLoader.loadClass(RMIClassLoader.getCodebase(), clName);
        }
        return RMIClassLoader.loadClass(codebase.toExternalForm(), clName);
    }

    public static Class loadClass(String codebase, String clName) throws MalformedURLException, ClassNotFoundException {
        if (codebase == null) {
            codebase = RMIClassLoader.getCodebase();
        }
        ClassLoader cLoader = RMIClassLoader.getClassLoader(codebase);
        return Class.forName(clName, true, cLoader);
    }

    public static String getClassAnnotation(Class cl) {
        ClassLoader clClassLoader = cl.getClassLoader();
        if (clClassLoader == null) {
            return null;
        }
        ClassLoader cloader_nonboot = VM.getNonBootstrapClassLoader();
        ClassLoader cloader_thread = Thread.currentThread().getContextClassLoader();
        ClassLoader cloader_system = ClassLoader.getSystemClassLoader();
        if (clClassLoader.equals(cloader_nonboot) || clClassLoader.equals(cloader_thread) || clClassLoader.equals(cloader_system)) {
            return RMIClassLoader.getCodebase();
        }
        if (clClassLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)clClassLoader;
            URL[] urls = urlClassLoader.getURLs();
            String annotation = "";
            int i = 0;
            while (i < urls.length) {
                annotation = String.valueOf(annotation) + " " + urls[i].toExternalForm();
                ++i;
            }
            if (!annotation.equals("")) {
                annotation = annotation.trim();
            }
            return annotation;
        }
        return RMIClassLoader.getCodebase();
    }

    public static Object getSecurityContext(ClassLoader loader) {
        if (loader instanceof URLClassLoader) {
            return ((URLClassLoader)loader).getURLs()[0];
        }
        return null;
    }

    private static String getCodebase() {
        if (isCodebaseSet) {
            return codebase;
        }
        codebase = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.rmi.server.codebase");
            }
        });
        isCodebaseSet = true;
        return codebase;
    }
}

