/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import com.ibm.oti.rmi.util.Msg;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Date;

class RMILogStream
extends PrintStream {
    private StringBuffer sbuf;

    protected RMILogStream(OutputStream out) {
        super(out);
    }

    public void write(int oneByte) {
        if (this.out == null) {
            this.setError();
            return;
        }
        try {
            if (this.sbuf == null) {
                this.sbuf = new StringBuffer();
            }
            this.sbuf.append((char)oneByte);
            if ((oneByte & 0xFF) == 10) {
                String prefix = String.valueOf(new Date().toString()) + ":RMI:RMI TCP Connection()-" + InetAddress.getLocalHost().getHostAddress() + ":";
                String message = this.sbuf.toString();
                this.out.write((String.valueOf(prefix) + message).getBytes());
                this.out.flush();
                this.sbuf = null;
            }
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(byte[] buffer, int offset, int count) {
        if (buffer == null) throw new NullPointerException();
        if (offset < 0 || offset > buffer.length || count < 0 || count > buffer.length - offset) throw new ArrayIndexOutOfBoundsException(Msg.getString("R0047"));
        if (this.out == null) {
            this.setError();
            return;
        }
        int i = offset;
        while (i < offset + count) {
            this.write(buffer[i]);
            ++i;
        }
    }
}

