/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import com.ibm.oti.rmi.DefaultSocketFactory;
import com.ibm.oti.rmi.util.Msg;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIFailureHandler;
import java.rmi.server.RMIServerSocketFactory;

public abstract class RMISocketFactory
implements RMIClientSocketFactory,
RMIServerSocketFactory {
    private static final RMISocketFactory defaultSocketFactory = new DefaultSocketFactory();
    private static RMISocketFactory socketFactory = null;
    private static RMIFailureHandler failureHandler = null;

    public abstract Socket createSocket(String var1, int var2) throws IOException;

    public abstract ServerSocket createServerSocket(int var1) throws IOException;

    public static void setSocketFactory(RMISocketFactory fac) throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        if (socketFactory != null) {
            throw new IOException(Msg.getString("R0048"));
        }
        socketFactory = fac;
    }

    public static RMISocketFactory getSocketFactory() {
        return socketFactory;
    }

    public static RMISocketFactory getDefaultSocketFactory() {
        return defaultSocketFactory;
    }

    public static void setFailureHandler(RMIFailureHandler fh) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        failureHandler = fh;
    }

    public static RMIFailureHandler getFailureHandler() {
        return failureHandler;
    }
}

