/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import com.ibm.oti.rmi.RMIServerTable;
import com.ibm.oti.rmi.util.Msg;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.UnmarshalException;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;

public abstract class RemoteObject
implements Serializable,
Remote {
    private static final long serialVersionUID = -3215090123894869218L;
    protected transient RemoteRef ref;

    protected RemoteObject() {
    }

    protected RemoteObject(RemoteRef r) {
        this.ref = r;
    }

    public RemoteRef getRef() {
        return this.ref;
    }

    public static Remote toStub(Remote obj) throws NoSuchObjectException {
        if (obj == null) {
            throw new NoSuchObjectException(Msg.getString("R0044"));
        }
        if (obj instanceof RemoteStub) {
            return obj;
        }
        RemoteStub o = RMIServerTable.getStub(obj);
        if (o == null) {
            throw new NoSuchObjectException(Msg.getString("R0044"));
        }
        return o;
    }

    public int hashCode() {
        int hash = this.ref == null ? super.hashCode() : this.ref.remoteHashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoteObject) {
            RemoteObject o = (RemoteObject)obj;
            if (this.ref != null && o.ref != null) {
                return this.ref.remoteEquals(o.ref);
            }
            return super.equals(obj);
        }
        return false;
    }

    public String toString() {
        if (this.ref == null) {
            return super.toString();
        }
        return String.valueOf(this.getClass().getName()) + ":[" + this.ref.remoteToString() + "]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String refClassName = in.readUTF();
        if (refClassName.length() == 0) {
            in.readObject();
        } else {
            try {
                refClassName = "com.ibm.oti.rmi." + refClassName;
                this.ref = (RemoteRef)Class.forName(refClassName).newInstance();
                this.ref.readExternal(in);
            }
            catch (IllegalAccessException ex) {
                throw new UnmarshalException(refClassName, ex);
            }
            catch (InstantiationException ex) {
                throw new UnmarshalException(refClassName, ex);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        if (this.ref == null) {
            throw new MarshalException(Msg.getString("R0045"));
        }
        String refClassName = this.ref.getRefClass(null);
        out.writeUTF(refClassName);
        if (refClassName.length() == 0) {
            out.writeObject(this.ref);
        } else {
            this.ref.writeExternal(out);
        }
    }
}

