/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.server.RMILogStream;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class RemoteServer
extends RemoteObject {
    private static final long serialVersionUID = -4100238210092549637L;
    private static PrintStream log;
    private static boolean logCalls;

    static {
        logCalls = false;
        String logCallsProperty = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.rmi.server.logCalls", "false");
            }
        });
        logCalls = logCallsProperty.equalsIgnoreCase("true");
    }

    protected RemoteServer() {
    }

    protected RemoteServer(RemoteRef r) {
        super(r);
    }

    public static String getClientHost() throws ServerNotActiveException {
        String serverThreadPrefix = "RMI-ServerConnection:";
        String threadName = Thread.currentThread().getName();
        if (threadName == null || !threadName.startsWith(serverThreadPrefix)) {
            throw new ServerNotActiveException();
        }
        return threadName.substring(serverThreadPrefix.length());
    }

    public static void setLog(OutputStream out) {
        if (out == null) {
            log = null;
            logCalls = false;
        } else {
            log = new RMILogStream(out);
            logCalls = true;
        }
    }

    public static PrintStream getLog() {
        if (logCalls && log != null) {
            return new PrintStream(log);
        }
        return null;
    }
}

