/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Random;

public final class UID
implements Serializable {
    private static final long serialVersionUID = 1086053664494604050L;
    static short instanceCount = 0;
    private static long loadTime = System.currentTimeMillis();
    private static Random random;
    short count;
    long time;
    int unique;

    static {
        try {
            random = new SecureRandom();
        }
        catch (RuntimeException runtimeException) {
            random = new Random();
        }
    }

    public UID() {
        this.count = instanceCount = (short)(instanceCount + 1);
        this.unique = random.nextInt();
        this.time = loadTime;
    }

    public UID(short num) {
        this.count = num;
        this.time = 0L;
        this.unique = 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UID) {
            UID o = (UID)obj;
            return this.time == o.time && this.count == o.count && this.unique == o.unique;
        }
        return false;
    }

    public int hashCode() {
        return this.count;
    }

    public String toString() {
        return "UID:[" + this.unique + ":" + this.time + ":" + this.count + "]";
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.unique);
        out.writeLong(this.time);
        out.writeShort(this.count);
    }

    public static UID read(DataInput in) throws IOException {
        int u = in.readInt();
        long t = in.readLong();
        short c = in.readShort();
        UID uid = new UID(c);
        uid.time = t;
        uid.unique = u;
        return uid;
    }
}

