/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import com.ibm.oti.rmi.RMIServerTable;
import com.ibm.oti.rmi.UnicastRef;
import com.ibm.oti.rmi.UnicastRef2;
import com.ibm.oti.rmi.UnicastServerRef;
import com.ibm.oti.rmi.UnicastServerRef2;
import com.ibm.oti.rmi.dgc.DGCImpl;
import com.ibm.oti.rmi.registry.RegistryImpl;
import com.ibm.oti.rmi.util.Msg;
import com.ibm.oti.rmi.wire.RMIServer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.StubNotFoundException;
import java.rmi.server.ExportException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerCloneException;

public class UnicastRemoteObject
extends RemoteServer {
    private static final long serialVersionUID = 4974527148936298033L;
    RMIClientSocketFactory csf;
    int port;
    RMIServerSocketFactory ssf;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected UnicastRemoteObject() throws RemoteException {
        this(0);
    }

    protected UnicastRemoteObject(int portNumber) throws RemoteException {
        this(portNumber, null, null);
    }

    protected UnicastRemoteObject(int portNumber, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        this.port = portNumber;
        this.csf = csf;
        this.ssf = ssf;
        UnicastRemoteObject.exportObject(this, this.port, csf, ssf);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            UnicastRemoteObject clone = (UnicastRemoteObject)super.clone();
            UnicastRemoteObject.exportObject(clone, clone.port, clone.csf, clone.ssf);
            return clone;
        }
        catch (RemoteException ex) {
            throw new ServerCloneException(Msg.getString("R0049"), ex);
        }
    }

    public static RemoteStub exportObject(Remote obj) throws RemoteException {
        return (RemoteStub)UnicastRemoteObject.exportObject(obj, 0);
    }

    public static Remote exportObject(Remote obj, int port) throws RemoteException {
        return UnicastRemoteObject.exportObject(obj, port, null, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Remote exportObject(Remote obj, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        try {
            if (!(obj instanceof RegistryImpl)) {
                DGCImpl.initDGC();
            }
            if (obj instanceof DGCImpl) {
                id = new ObjID(2);
            } else {
                if (ssf == null) {
                    ssf = RMISocketFactory.getSocketFactory();
                }
                if (ssf == null) {
                    ssf = RMISocketFactory.getDefaultSocketFactory();
                }
                server = RMIServer.serverFor(port, (byte)75, ssf);
                port = server.getLocalPort();
                id = obj instanceof RegistryImpl != false ? new ObjID(0) : new ObjID();
            }
            if (RMIServerTable.getObj(id) != null) {
                throw new ExportException(Msg.getString("R0050"));
            }
            if (obj instanceof RemoteObject) {
                serverRef = null;
                serverRef = csf == null ? new UnicastServerRef(port, id) : new UnicastServerRef2(port, id, csf, ssf);
                ((RemoteObject)obj).ref = serverRef;
            }
            ref = null;
            ref = csf == null ? new UnicastRef(port, id) : new UnicastRef2(port, id, csf);
            if (obj instanceof DGCImpl || obj instanceof RegistryImpl) {
                ref.setDeathTime(0x7FFFFFFFFFFFFFFFL);
            }
            annotation = RMIClassLoader.getClassAnnotation(obj.getClass());
            objClass = obj.getClass();
            v0 = UnicastRemoteObject.class$0;
            if (v0 == null) {
                try {
                    v0 = UnicastRemoteObject.class$0 = Class.forName("com.ibm.oti.rmi.dgc.DGCImpl");
                }
                catch (ClassNotFoundException v1) {
                    throw new NoClassDefFoundError(v1.getMessage());
                }
            }
            if (objClass == v0) ** GOTO lbl-1000
            v2 = UnicastRemoteObject.class$1;
            if (v2 == null) {
                try {
                    v2 = UnicastRemoteObject.class$1 = Class.forName("com.ibm.oti.rmi.registry.RegistryImpl");
                }
                catch (ClassNotFoundException v3) {
                    throw new NoClassDefFoundError(v3.getMessage());
                }
            }
            if (objClass == v2) lbl-1000:
            // 2 sources

            {
                v4 = Class.forName(String.valueOf(objClass.getName()) + "_Stub");
            } else {
                v4 = RMIClassLoader.loadClass(annotation, String.valueOf(objClass.getName()) + "_Stub");
            }
            objStubClass = v4;
            try {
                v5 = new Class[1];
                v6 = UnicastRemoteObject.class$2;
                if (v6 == null) {
                    try {
                        v6 = UnicastRemoteObject.class$2 = Class.forName("java.rmi.server.RemoteRef");
                    }
                    catch (ClassNotFoundException v7) {
                        throw new NoClassDefFoundError(v7.getMessage());
                    }
                }
                v5[0] = v6;
                c = objStubClass.getConstructor(v5);
                stub = (RemoteStub)c.newInstance(new Object[]{ref});
            }
            catch (NoSuchMethodException ex) {
                throw new RemoteException(null, ex);
            }
            catch (InvocationTargetException ex) {
                throw new RemoteException(null, ex);
            }
            catch (InstantiationException ex) {
                throw new RemoteException(null, ex);
            }
            RMIServerTable.putServer(obj, stub, id);
            return stub;
        }
        catch (ExportException ex) {
            throw ex;
        }
        catch (ClassNotFoundException ex) {
            throw new StubNotFoundException(Msg.getString("R0004", String.valueOf(obj.getClass().getName()) + "_Stub"), ex);
        }
        catch (IllegalAccessException ex) {
            throw new StubNotFoundException(Msg.getString("R0005", String.valueOf(obj.getClass().getName()) + "_Stub(RemoteRef r)"), ex);
        }
        catch (IOException ex) {
            throw new ExportException(Msg.getString("R0051", obj), ex);
        }
    }

    public static boolean unexportObject(Remote obj, boolean force) throws NoSuchObjectException {
        RemoteStub stub = RMIServerTable.getStub(obj);
        if (stub == null) {
            throw new NoSuchObjectException("null");
        }
        if (RMIServerTable.removeServer(obj, force)) {
            UnicastRef ref = (UnicastRef)stub.getRef();
            RMIServer s = RMIServer.serverFor(ref.getPort());
            if (s != null) {
                s.decReference();
            }
            return true;
        }
        return false;
    }
}

