/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.applicationclient;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.client.factory.jdbc.UnsupportedPropertyException;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.ws.client.applicationclient.JMSPropertiesRefAddr;
import com.ibm.ws.client.applicationclient.Utility;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class ClientJMSFactory
implements ObjectFactory {
    private static final TraceComponent tc = Tr.register(class$com$ibm$ws$client$applicationclient$ClientJMSFactory == null ? (class$com$ibm$ws$client$applicationclient$ClientJMSFactory = ClientJMSFactory.class$("com.ibm.ws.client.applicationclient.ClientJMSFactory")) : class$com$ibm$ws$client$applicationclient$ClientJMSFactory, null, "com.ibm.ws.client.applicationclient.ResourceBundle");
    private static final Class[] setterParamList = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ClientJMSFactory.class$("java.lang.String")) : class$java$lang$String};
    public static final String JMS_CLASSNAME = "com.ibm.ws.client.applicationclient.jms.classname";
    public static final String JMS_CLASSPATH = "com.ibm.ws.client.applicationclient.jms.classpath";
    public static final String CHANNEL = "WAS.JMS.SVRCONN";
    public static final String BROKER_PUB_Q = "SYSTEM.BROKER.DEFAULT.STREAM";
    public static final String QUEUE_NAME_PREFIX = "WQ_";
    public static final String CELL_NAME = "%cellName%";
    public static final Integer QUEUED_PORT = new Integer(5558);
    public static final Integer DIRECT_PORT = new Integer(5559);
    public static final String DEFAULT_SOAP_PORT = new String("8880");
    public static final String DEFAULT_RMI_PORT = new String("2809");
    public static final String ADMIN_CONNECTOR_TYPE_PROP = "appclient.adminConnectorType";
    public static final String ADMIN_CONNECTOR_HOST_PROP = "appclient.adminConnectorHost";
    public static final String ADMIN_CONNECTOR_PORT_PROP = "appclient.adminConnectorPort";
    public static final String ADMIN_CONNECTOR_USER_PROP = "appclient.adminConnectorUser";
    public static final String ADMIN_CONNECTOR_PASSWORD_PROP = "appclient.adminConnectorPassword";
    private static final int WAS_QUEUED_PORT_TYPE = 0;
    private static final int WAS_DIRECT_PORT_TYPE = 1;
    static /* synthetic */ Class class$com$ibm$ws$client$applicationclient$ClientJMSFactory;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$util$Properties;

    public static Reference getJMSReference(Properties properties, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJMSReference");
        }
        Reference reference = new Reference(string, new JMSPropertiesRefAddr("JMSProperties", properties), (class$com$ibm$ws$client$applicationclient$ClientJMSFactory == null ? (class$com$ibm$ws$client$applicationclient$ClientJMSFactory = ClientJMSFactory.class$("com.ibm.ws.client.applicationclient.ClientJMSFactory")) : class$com$ibm$ws$client$applicationclient$ClientJMSFactory).getName(), null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJMSReference");
        }
        return reference;
    }

    public static Integer getBrokerVersion_V1() {
        return new Integer(0);
    }

    public static Integer getBrokerVersion_V2() {
        return new Integer(1);
    }

    public static Integer getWASBrokerVersion() {
        return ClientJMSFactory.getBrokerVersion_V2();
    }

    public static Integer getTransportClient() {
        return new Integer(1);
    }

    public static Integer getTransportDirect() {
        return new Integer(2);
    }

    public static int getNormalIntegerEncoding() {
        return 1;
    }

    public static int getReversedIntegerEncoding() {
        return 2;
    }

    public static int getNormalDecimalEncoding() {
        return 16;
    }

    public static int getReversedDecimalEncoding() {
        return 32;
    }

    public static int getIEEENormalFloatEncoding() {
        return 256;
    }

    public static int getIEEEReversedFloatEncoding() {
        return 512;
    }

    public static int getS390FloatEncoding() {
        return 768;
    }

    public static int getNativeEncoding() {
        return 273;
    }

    public Object getJMSObject(Reference reference) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJMSObject");
        }
        String string = reference.getClassName();
        Properties properties = null;
        Object var5_4 = null;
        try {
            RefAddr refAddr = reference.get("JMSProperties");
            if (refAddr == null) {
                return null;
            }
            try {
                properties = (Properties)refAddr.getContent();
            }
            catch (ClassCastException classCastException) {
                Utility.printWarning(tc, Utility.getMessage("jmsfac.nojmsclass"));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getJMSObject");
                }
                return null;
            }
            ClassLoader classLoader = null;
            String string2 = properties.getProperty(JMS_CLASSPATH);
            if (string2 != null) {
                classLoader = Utility.getResourceClassLoader(tc, string2, null);
            } else {
                classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
            }
            String string3 = properties.getProperty(JMS_CLASSNAME);
            Class<?> clazz = classLoader.loadClass(string3);
            var5_4 = clazz.newInstance();
            PropertyDescriptor[] propertyDescriptorArray = this.getPropertyDescriptors(clazz);
            Enumeration<Object> enumeration = properties.keys();
            String string4 = null;
            while (enumeration.hasMoreElements()) {
                CharSequence charSequence;
                String string5;
                String string6;
                String string7 = (String)enumeration.nextElement();
                if ((string7.equalsIgnoreCase("queueManager") || string7.equalsIgnoreCase("baseQueueManagerName") || string7.equalsIgnoreCase("brokerQueueManager")) && properties.getProperty(string7).indexOf(CELL_NAME) != -1) {
                    string6 = ClientJMSFactory.getCellName();
                    string5 = properties.getProperty(string7);
                    int n = string5.indexOf(CELL_NAME);
                    charSequence = new StringBuffer(properties.getProperty(string7));
                    ((StringBuffer)charSequence).replace(n, n += CELL_NAME.length(), string6);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting {0} to {1}", new Object[]{string7, charSequence});
                    }
                    properties.setProperty(string7, ((StringBuffer)charSequence).toString());
                }
                if (string7.equalsIgnoreCase("port")) {
                    string6 = "0";
                    string5 = properties.getProperty(string7);
                    if (string5.equals("DIRECT") || string5.equals("QUEUED")) {
                        try {
                            AdminClient adminClient = AdminClientFactory.createAdminClient((Properties)ClientJMSFactory.getAdminConnectionProps(properties));
                            charSequence = properties.getProperty("node");
                            string6 = ClientJMSFactory.getWASCFPort(adminClient, (String)charSequence, string5).toString();
                            string4 = ClientJMSFactory.getWASCFHost(adminClient, (String)charSequence);
                            if (string4 != null) {
                                this.setProperty("hostName", string4, var5_4, propertyDescriptorArray);
                            }
                        }
                        catch (Throwable throwable) {
                            Utility.printWarning(tc, throwable);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting {0} to {1}", new Object[]{string7, string6});
                        }
                        properties.setProperty(string7, string6);
                    }
                }
                if (string7.equalsIgnoreCase(JMS_CLASSNAME) || string7.equalsIgnoreCase(JMS_CLASSPATH) || string7.equalsIgnoreCase("node") || string7.equalsIgnoreCase(ADMIN_CONNECTOR_TYPE_PROP) || string7.equalsIgnoreCase(ADMIN_CONNECTOR_HOST_PROP) || string7.equalsIgnoreCase(ADMIN_CONNECTOR_PORT_PROP) || string7.equalsIgnoreCase(ADMIN_CONNECTOR_USER_PROP) || string7.equalsIgnoreCase(ADMIN_CONNECTOR_PASSWORD_PROP) || string7.equalsIgnoreCase("soapConnectorPort")) continue;
                try {
                    string6 = properties.getProperty(string7);
                    this.setProperty(string7, string6, var5_4, propertyDescriptorArray);
                }
                catch (Throwable throwable) {
                    Utility.printWarning(throwable);
                }
            }
            if (tc.isDebugEnabled()) {
                this.dumpJMSClassPropertyValues(propertyDescriptorArray, var5_4);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJMSObject");
        }
        return var5_4;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance");
        }
        Reference reference = null;
        try {
            reference = (Reference)object;
        }
        catch (ClassCastException classCastException) {
            Utility.printWarning(tc, Utility.getMessage("jmsfac.noreference"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getObjectInstance");
            }
            return null;
        }
        Object object2 = this.getJMSObject(reference);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectInstance");
        }
        return object2;
    }

    private PropertyDescriptor[] getPropertyDescriptors(Class clazz) throws IntrospectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyDescriptors", clazz);
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyDescriptors", propertyDescriptorArray);
        }
        return propertyDescriptorArray;
    }

    private PropertyDescriptor findPropertyDescriptorFor(String string, PropertyDescriptor[] propertyDescriptorArray) {
        if (tc.isEventEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findPropertyDescriptorFor", new Object[]{string, propertyDescriptorArray});
        }
        PropertyDescriptor propertyDescriptor = null;
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            if (!propertyDescriptorArray[i].getName().equals(string)) continue;
            propertyDescriptor = propertyDescriptorArray[i];
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findPropertyDescriptorFor", propertyDescriptor);
        }
        return propertyDescriptor;
    }

    private void setProperty(String string, Object object, Object object2, PropertyDescriptor[] propertyDescriptorArray) throws UnsupportedPropertyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperty");
        }
        Class<?> clazz = object2.getClass();
        PropertyDescriptor propertyDescriptor = this.findPropertyDescriptorFor(string, propertyDescriptorArray);
        if (propertyDescriptor == null) {
            String[] stringArray = new String[]{string, clazz.toString()};
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jmsfac.missingsettermethod", stringArray);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setProperty");
            }
            throw new UnsupportedPropertyException(Utility.getMessage("jmsfac.missingsettermethod", stringArray));
        }
        Object object3 = this.convertToDeclaredPropertyType(object, propertyDescriptor);
        Method method = propertyDescriptor.getWriteMethod();
        if (method == null) {
            String[] stringArray = new String[]{string, clazz.toString()};
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jmsfac.missingsettermethod", stringArray);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setProperty");
            }
            throw new UnsupportedPropertyException(Utility.getMessage("jmsfac.missingsettermethod", stringArray));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Got write method", method);
        }
        Object[] objectArray = new Object[]{object3};
        try {
            method.invoke(object2, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            String[] stringArray = new String[]{string, clazz.toString(), illegalAccessException.getMessage()};
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jmsfac.illegalaccessProperty", stringArray);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setProperty");
            }
            throw new UnsupportedPropertyException(Utility.getMessage("jmsfac.illegalaccessProperty", stringArray));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String[] stringArray = new String[]{string, clazz.toString(), illegalArgumentException.getMessage()};
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jmsfac.illegalargument", stringArray);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setProperty");
            }
            throw new UnsupportedPropertyException(Utility.getMessage("jmsfac.illegalargument", stringArray));
        }
        catch (InvocationTargetException invocationTargetException) {
            String[] stringArray = new String[]{string, clazz.toString(), invocationTargetException.getTargetException().getMessage()};
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jmsfac.invocationerror", stringArray);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setProperty");
            }
            throw new UnsupportedPropertyException(Utility.getMessage("jmsfac.invocationerror", stringArray));
        }
    }

    private Object convertToDeclaredPropertyType(Object object, PropertyDescriptor propertyDescriptor) {
        Object object2;
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "convertToDeclaredPropertyType", new Object[]{object, propertyDescriptor});
            }
            object2 = object;
            Class<?> clazz = propertyDescriptor.getPropertyType();
            if (clazz.isAssignableFrom(class$java$lang$String == null ? (class$java$lang$String = ClientJMSFactory.class$("java.lang.String")) : class$java$lang$String)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "convertToDeclaredPropertyType", object);
                }
                return object;
            }
            Class<?> clazz2 = object.getClass();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "GivenPropertyType=" + clazz2.getName() + "; DeclaredPropertyType = " + clazz.getName());
            }
            if (!clazz.isAssignableFrom(clazz2)) {
                try {
                    String string = (String)object;
                    if (clazz.isAssignableFrom(Integer.TYPE) || clazz.isAssignableFrom(class$java$lang$Integer == null ? (class$java$lang$Integer = ClientJMSFactory.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                        object2 = Integer.valueOf(string);
                    } else if (clazz.isAssignableFrom(Long.TYPE) || clazz.isAssignableFrom(class$java$lang$Long == null ? (class$java$lang$Long = ClientJMSFactory.class$("java.lang.Long")) : class$java$lang$Long)) {
                        object2 = Long.valueOf(string);
                    } else if (clazz.isAssignableFrom(class$java$util$Properties == null ? (class$java$util$Properties = ClientJMSFactory.class$("java.util.Properties")) : class$java$util$Properties)) {
                        object2 = this.convertStringToProperties(string);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Conversion to declared method type " + clazz.getName() + " will not occur because class is unknown.");
                    }
                }
                catch (ClassCastException classCastException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Attempt to cast property to String because the given property type and the declared method type are different failed", classCastException);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug(tc, "Attempt to convert property to Integer because the declared method is int/Integer failed", numberFormatException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToDeclaredPropertyType", object2);
        }
        return object2;
    }

    private Properties convertStringToProperties(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertStringToProperties", string);
        }
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";=");
        while (stringTokenizer.hasMoreTokens()) {
            properties.setProperty(stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertStringToProperties", properties);
        }
        return properties;
    }

    private void dumpJMSClassPropertyValues(PropertyDescriptor[] propertyDescriptorArray, Object object) {
        Tr.debug(tc, "Class Property values:\n");
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            try {
                Method method = propertyDescriptorArray[i].getReadMethod();
                Object object2 = method.invoke(object, null);
                if (object2 == null || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, propertyDescriptorArray[i].getName() + "=" + object2.toString());
                continue;
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, throwable.getMessage());
            }
        }
    }

    public static String getHostName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHostName");
        }
        if (System.getProperty("com.ibm.CORBA.BootstrapHost", null) == null || System.getProperty("com.ibm.CORBA.BootstrapHost", null).equals("")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getHostName");
            }
            return "localhost";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHostName");
        }
        return System.getProperty("com.ibm.CORBA.BootstrapHost");
    }

    public static String getSoapPort(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSoapPort");
        }
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "returning soap port {0}", new Object[]{DEFAULT_SOAP_PORT});
                }
                return Integer.toString(n);
            }
            catch (NumberFormatException numberFormatException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "the parameter could not be read properly.  Returning default soap port {0}", new Object[]{DEFAULT_SOAP_PORT});
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getSoapPort");
                }
                return DEFAULT_SOAP_PORT;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Soap port is not set.  Returning default soap port {0}", new Object[]{DEFAULT_SOAP_PORT});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSoapPort");
        }
        return DEFAULT_SOAP_PORT;
    }

    public static Integer getWASCFPort(AdminClient adminClient, String string, String string2) {
        Integer n;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getWASCFPort", string);
            }
            try {
                ObjectName objectName = new ObjectName("WebSphere:name=" + string + "JMSServer,*");
                Set set = adminClient.queryNames(objectName, null);
                if (set.size() != 1 && tc.isDebugEnabled()) {
                    Tr.debug(tc, "There are {0} repositories", new Object[]{new Integer(set.size())});
                }
                Object[] objectArray = set.toArray();
                ObjectName objectName2 = (ObjectName)objectArray[0];
                n = string2.equals("DIRECT") ? (Integer)adminClient.invoke(objectName2, "getDirectPort", null, null) : (Integer)adminClient.invoke(objectName2, "getQueuedPort", null, null);
            }
            catch (Exception exception) {
                n = string2.equals("DIRECT") ? DIRECT_PORT : QUEUED_PORT;
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, exception.getMessage());
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Returning default " + string2 + " port {0}", new Object[]{n});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWASCFPort", string);
        }
        return n;
    }

    public static String getCellName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellName");
        }
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", System.getProperty("java.naming.factory.initial"));
            InitialContext initialContext = new InitialContext(hashtable);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCellName");
            }
            return (String)initialContext.lookup("cell/cellname");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, exception.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCellName");
            }
            return null;
        }
    }

    private static String getWASCFHost(AdminClient adminClient, String string) {
        String string2 = null;
        try {
            ObjectName objectName = new ObjectName("WebSphere:type=JVM,node=" + string + ",*");
            Set set = adminClient.queryNames(objectName, null);
            if (set.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using default hostname.");
                }
                string2 = ClientJMSFactory.getHostName();
            } else {
                Object[] objectArray = set.toArray();
                string2 = (String)adminClient.getAttribute((ObjectName)objectArray[0], "node");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "hostname retrieved from mbean.");
                }
            }
        }
        catch (Throwable throwable) {
            Utility.printWarning(tc, throwable);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred - using default hostname");
            }
            string2 = ClientJMSFactory.getHostName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "jmsHostName=" + string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWASCFHost", string);
        }
        return string2;
    }

    private static Properties getAdminConnectionProps(Properties properties) {
        String string;
        Properties properties2 = new Properties();
        properties2.setProperty("type", ClientJMSFactory.getAdminConnectorType(properties));
        properties2.setProperty("host", ClientJMSFactory.getAdminHostName(properties));
        properties2.setProperty("port", ClientJMSFactory.getAdminPort(properties));
        properties2.setProperty("securityEnabled", "true");
        String string2 = properties.getProperty(ADMIN_CONNECTOR_USER_PROP, null);
        if (!Utility.isStringEmpty(string2)) {
            properties2.setProperty("username", string2);
        }
        if (!Utility.isStringEmpty(string = properties.getProperty(ADMIN_CONNECTOR_PASSWORD_PROP, null))) {
            properties2.setProperty("password", string);
        }
        if (tc.isDebugEnabled()) {
            Properties properties3 = new Properties();
            properties3.setProperty("password", "");
            Tr.debug(tc, "Admin Connection Properties: \n" + Utility.propertiesToStringFormattedHidePW("resource.prop", properties2, properties3));
        }
        return properties2;
    }

    private static String getAdminConnectorType(Properties properties) {
        String string = properties.getProperty(ADMIN_CONNECTOR_TYPE_PROP, null);
        if (string != null && string.equalsIgnoreCase("RMI")) {
            return "RMI";
        }
        return "SOAP";
    }

    private static String getAdminHostName(Properties properties) {
        String string = properties.getProperty(ADMIN_CONNECTOR_HOST_PROP, null);
        if (string != null) {
            return string;
        }
        return ClientJMSFactory.getHostName();
    }

    private static String getAdminPort(Properties properties) {
        block5: {
            String string = properties.getProperty(ADMIN_CONNECTOR_PORT_PROP, null);
            if (string != null) {
                try {
                    int n = Integer.parseInt(string);
                    return string;
                }
                catch (NumberFormatException numberFormatException) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "the port parameter [" + string + "] is not numeric.");
                }
            }
        }
        if (ClientJMSFactory.getAdminConnectorType(properties).equalsIgnoreCase("SOAP")) {
            return ClientJMSFactory.getSoapPort(properties.getProperty("soapConnectorPort"));
        }
        if (ClientJMSFactory.getAdminConnectorType(properties).equalsIgnoreCase("RMI")) {
            return DEFAULT_RMI_PORT;
        }
        return "0";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

