/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.models.base.resources.jdbc.DataSource;
import com.ibm.ws.client.ccrct.ConfigPropertyEditor;
import com.ibm.ws.client.ccrct.Utility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class CustomPanel
extends JPanel
implements ActionListener {
    private JTable table;
    private JScrollPane scrollPane;
    private ConfigPropertyEditor customPropertyEditor;
    private int gridy;
    private JPanel propertyButtonPanel;
    private JButton addButton;
    private JButton removeButton;
    private ActionListener actionListener;
    private JPanel propertiesPanel;
    private GridBagConstraints gbc;
    private GridBagLayout gbl;
    private GridBagConstraints pgbc;
    private Properties props = null;

    public void init() {
        this.setName("CustomPanel");
        this.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        this.gbc.insets = new Insets(6, 6, 6, 6);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.propertiesPanel = new JPanel();
        this.gbl = new GridBagLayout();
        this.pgbc = new GridBagConstraints();
        this.propertiesPanel.setLayout(this.gbl);
        this.pgbc.fill = 2;
        this.pgbc.anchor = 11;
        this.pgbc.insets = new Insets(6, 6, 6, 6);
        this.pgbc.gridx = 0;
        this.gridy = this.pgbc.gridy = 0;
        String string = Utility.getMessage("helper.customPropertiesTitle");
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(), string);
        this.propertiesPanel.setBorder(titledBorder);
        this.pgbc.gridx = 0;
        this.pgbc.gridy = this.gridy;
    }

    public CustomPanel() {
        this.init();
        this.createCustomPropertyEditor(this.props);
        this.createPropertiesButtonPanel();
        JScrollPane jScrollPane = new JScrollPane(this.customPropertyEditor);
        this.propertiesPanel.add((Component)jScrollPane, this.pgbc);
        this.pgbc.gridx = 1;
        this.pgbc.gridy = this.gridy++;
        this.propertiesPanel.add((Component)this.propertyButtonPanel, this.pgbc);
        this.add(this.propertiesPanel);
    }

    public CustomPanel(J2EEResourceProvider j2EEResourceProvider) {
        Object object;
        this.init();
        this.props = new Properties();
        if (j2EEResourceProvider.getPropertySet() != null) {
            object = j2EEResourceProvider.getPropertySet();
            Iterator iterator = object.getResourceProperties().iterator();
            while (iterator.hasNext()) {
                J2EEResourceProperty j2EEResourceProperty = (J2EEResourceProperty)iterator.next();
                this.props.setProperty(j2EEResourceProperty.getName(), j2EEResourceProperty.getValue());
            }
        }
        this.createCustomPropertyEditor(this.props);
        this.createPropertiesButtonPanel();
        object = new JScrollPane(this.customPropertyEditor);
        this.propertiesPanel.add((Component)object, this.pgbc);
        this.pgbc.gridx = 1;
        this.pgbc.gridy = this.gridy++;
        this.propertiesPanel.add((Component)this.propertyButtonPanel, this.pgbc);
        this.add(this.propertiesPanel);
    }

    public CustomPanel(J2EEResourceFactory j2EEResourceFactory) {
        Object object;
        this.init();
        this.props = new Properties();
        if (j2EEResourceFactory.getPropertySet() != null) {
            object = j2EEResourceFactory.getPropertySet();
            Iterator iterator = object.getResourceProperties().iterator();
            if (j2EEResourceFactory instanceof DataSource) {
                while (iterator.hasNext()) {
                    J2EEResourceProperty j2EEResourceProperty = (J2EEResourceProperty)iterator.next();
                    if (j2EEResourceProperty.getName().equals("user") || j2EEResourceProperty.getName().equals("password")) continue;
                    this.props.setProperty(j2EEResourceProperty.getName(), j2EEResourceProperty.getValue());
                }
            } else {
                while (iterator.hasNext()) {
                    J2EEResourceProperty j2EEResourceProperty = (J2EEResourceProperty)iterator.next();
                    this.props.setProperty(j2EEResourceProperty.getName(), j2EEResourceProperty.getValue());
                }
            }
        }
        this.createCustomPropertyEditor(this.props);
        this.createPropertiesButtonPanel();
        object = new JScrollPane(this.customPropertyEditor);
        this.propertiesPanel.add((Component)object, this.pgbc);
        this.pgbc.gridx = 1;
        this.pgbc.gridy = this.gridy++;
        this.propertiesPanel.add((Component)this.propertyButtonPanel, this.pgbc);
        this.add(this.propertiesPanel);
    }

    public ConfigPropertyEditor getCustomPropertyEditor() {
        return this.customPropertyEditor;
    }

    private void createCustomPropertyEditor(Properties properties) {
        Vector<String> vector = new Vector<String>();
        vector.addElement(Utility.getMessage("helper.customNameLabel"));
        vector.addElement(Utility.getMessage("helper.customValueLabel"));
        if (properties == null) {
            properties = new Properties();
        }
        this.customPropertyEditor = new ConfigPropertyEditor(vector, properties, false);
    }

    private void createPropertiesButtonPanel() {
        this.removeButton = new JButton();
        this.removeButton.setText(Utility.getMessage("helper.removeButton"));
        this.removeButton.setActionCommand("Remove");
        this.removeButton.addActionListener(this);
        this.addButton = new JButton();
        this.addButton.setText(Utility.getMessage("helper.addButton"));
        this.addButton.setActionCommand("Add");
        this.addButton.addActionListener(this);
        this.propertyButtonPanel = new JPanel();
        this.propertyButtonPanel.setLayout(new GridLayout(2, 1, 0, 12));
        this.propertyButtonPanel.add((Component)this.addButton, 0);
        this.propertyButtonPanel.add((Component)this.removeButton, 1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Add")) {
            this.customPropertyEditor.newProperty();
        } else if (string.equals("Remove")) {
            this.customPropertyEditor.removeProperty();
            this.revalidate();
        }
    }
}

