/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ejs.models.base.resources.mail.MailProvider;
import com.ibm.ejs.models.base.resources.mail.MailSession;
import com.ibm.ejs.models.base.resources.mail.ProtocolProvider;
import com.ibm.ws.client.ccrct.ConfigPropertyEditor;
import com.ibm.ws.client.ccrct.ProtocolProviderPropertyEditor;
import com.ibm.ws.client.ccrct.Utility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class ProtocolProviderPanel
extends JPanel
implements ActionListener {
    private JScrollPane scrollPane;
    private ProtocolProviderPropertyEditor protocolProviderEditor;
    private int gridy;
    private JPanel propertyButtonPanel;
    private JButton addButton;
    private JButton removeButton;
    private ActionListener actionListener;
    private GridBagLayout gbl;
    private GridBagConstraints pgbc;
    private Vector props = null;
    private MailProvider _mailProvider = null;
    private ImageIcon warningImage = new ImageIcon(this.getClass().getResource("images/warning.gif"));
    private ImageIcon informationImage = new ImageIcon(this.getClass().getResource("images/information.gif"));
    private ImageIcon criticalImage = new ImageIcon(this.getClass().getResource("images/critical.gif"));

    public void init() {
        this.setName("ProtocolProviderPanel");
        this.gbl = new GridBagLayout();
        this.pgbc = new GridBagConstraints();
        this.setLayout(this.gbl);
        this.pgbc.fill = 2;
        this.pgbc.anchor = 18;
        this.pgbc.insets = new Insets(6, 6, 6, 6);
        this.pgbc.gridx = 0;
        this.gridy = this.pgbc.gridy = 0;
        String string = Utility.getMessage("protocolprovider.title");
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(), string);
        this.setBorder(titledBorder);
    }

    public ProtocolProviderPanel() {
        this.init();
        this.createProtocolPropertyEditor(this.props);
        this.createPropertiesButtonPanel();
        this.scrollPane = new JScrollPane(this.protocolProviderEditor);
        this.pgbc.gridx = 0;
        this.pgbc.gridy = 0;
        this.pgbc.fill = 1;
        this.pgbc.weightx = 0.9;
        this.pgbc.weighty = 0.9;
        this.add((Component)this.scrollPane, this.pgbc);
        this.pgbc.gridx = 1;
        this.pgbc.gridy = 0;
        this.pgbc.fill = 2;
        this.pgbc.weightx = 0.1;
        this.pgbc.weighty = 0.1;
        this.add((Component)this.propertyButtonPanel, this.pgbc);
    }

    public ProtocolProviderPanel(MailProvider mailProvider) {
        this.init();
        this._mailProvider = mailProvider;
        this.props = new Vector();
        if (mailProvider.getProtocolProviders() != null) {
            Iterator iterator = mailProvider.getProtocolProviders().iterator();
            while (iterator.hasNext()) {
                Vector<String> vector = new Vector<String>();
                ProtocolProvider protocolProvider = (ProtocolProvider)iterator.next();
                vector.addElement(protocolProvider.getProtocol());
                vector.addElement(protocolProvider.getClassname());
                vector.addElement(protocolProvider.getType().getName());
                this.props.addElement(vector);
            }
        }
        this.createProtocolPropertyEditor(this.props);
        this.createPropertiesButtonPanel();
        this.scrollPane = new JScrollPane(this.protocolProviderEditor);
        this.pgbc.gridx = 0;
        this.pgbc.gridy = 0;
        this.pgbc.fill = 1;
        this.pgbc.weightx = 0.9;
        this.pgbc.weighty = 0.9;
        this.add((Component)this.scrollPane, this.pgbc);
        this.pgbc.gridx = 1;
        this.pgbc.gridy = 0;
        this.pgbc.fill = 2;
        this.pgbc.weightx = 0.1;
        this.pgbc.weighty = 0.1;
        this.add((Component)this.propertyButtonPanel, this.pgbc);
    }

    public ProtocolProviderPanel(Vector vector) {
        this.init();
        this.createProtocolPropertyEditor(vector);
        this.createPropertiesButtonPanel();
        this.scrollPane = new JScrollPane(this.protocolProviderEditor);
        this.pgbc.gridx = 0;
        this.pgbc.gridy = 0;
        this.pgbc.fill = 1;
        this.pgbc.weightx = 0.9;
        this.pgbc.weighty = 0.9;
        this.add((Component)this.scrollPane, this.pgbc);
        this.pgbc.gridx = 1;
        this.pgbc.gridy = 0;
        this.pgbc.fill = 2;
        this.pgbc.weightx = 0.1;
        this.pgbc.weighty = 0.1;
        this.add((Component)this.propertyButtonPanel, this.pgbc);
    }

    public ConfigPropertyEditor getProtocolPropertyEditor() {
        return this.protocolProviderEditor;
    }

    private void createProtocolPropertyEditor(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement(Utility.getMessage("protocolprovider.protocolColumnLabel"));
        vector2.addElement(Utility.getMessage("protocolprovider.classnameColumnLabel"));
        vector2.addElement(Utility.getMessage("protocolprovider.typeColumnLabel"));
        this.protocolProviderEditor = new ProtocolProviderPropertyEditor(vector2, null, vector, false);
    }

    private void createPropertiesButtonPanel() {
        this.removeButton = new JButton();
        this.removeButton.setText(Utility.getMessage("helper.removeButton"));
        this.removeButton.setActionCommand("Remove");
        this.removeButton.addActionListener(this);
        this.addButton = new JButton();
        this.addButton.setText(Utility.getMessage("helper.addButton"));
        this.addButton.setActionCommand("Add");
        this.addButton.addActionListener(this);
        this.propertyButtonPanel = new JPanel();
        this.propertyButtonPanel.setLayout(new GridLayout(2, 1, 0, 12));
        this.propertyButtonPanel.add((Component)this.addButton, 0);
        this.propertyButtonPanel.add((Component)this.removeButton, 1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Add")) {
            this.protocolProviderEditor.newProperty();
            this.repaint();
        } else if (string.equals("Remove")) {
            boolean bl = true;
            if (this._mailProvider != null && this.protocolProviderEditor.getTable().getSelectedRow() >= 0) {
                String string2 = (String)this.protocolProviderEditor.getTable().getModel().getValueAt(this.protocolProviderEditor.getTable().getSelectedRow(), 0);
                Iterator iterator = this._mailProvider.getFactories().iterator();
                while (iterator.hasNext()) {
                    MailSession mailSession = (MailSession)iterator.next();
                    if (mailSession.getMailTransportProtocol() != null && mailSession.getMailTransportProtocol().getProtocol().equals(string2)) {
                        bl = false;
                    }
                    if (mailSession.getMailStoreProtocol() == null || !mailSession.getMailStoreProtocol().getProtocol().equals(string2)) continue;
                    bl = false;
                }
            }
            if (bl) {
                this.protocolProviderEditor.removeProperty();
                this.revalidate();
            } else {
                JOptionPane.showMessageDialog(null, Utility.getMessage("protproviderpanel.protProviderUsed"), Utility.getMessage("helper.errorTitle"), 0, this.criticalImage);
            }
        }
    }
}

