/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ws.client.ccrct.Utility;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TreeRenderer
extends DefaultTreeCellRenderer {
    private ImageIcon jdbcDriverIcon = new ImageIcon(this.getClass().getResource("images/JDBCdriver.gif"));
    private ImageIcon jdbcFactoryIcon = new ImageIcon(this.getClass().getResource("images/DataSource.gif"));
    private ImageIcon javaMailProviderIcon = new ImageIcon(this.getClass().getResource("images/MailProvider.gif"));
    private ImageIcon javaMailFactoryIcon = new ImageIcon(this.getClass().getResource("images/MailSession.gif"));
    private ImageIcon jmsProviderIcon = new ImageIcon(this.getClass().getResource("images/JMSProvider.gif"));
    private ImageIcon jmsDestinationIcon = new ImageIcon(this.getClass().getResource("images/JMSDestinationFactory.gif"));
    private ImageIcon jmsConnectionIcon = new ImageIcon(this.getClass().getResource("images/JMSConnectionFactory.gif"));
    private ImageIcon urlProviderIcon = new ImageIcon(this.getClass().getResource("images/URLprovider.gif"));
    private ImageIcon urlFactoryIcon = new ImageIcon(this.getClass().getResource("images/URL.gif"));
    private ImageIcon resourceEnvProviderIcon;
    private ImageIcon resourceEnvEntryIcon = new ImageIcon(this.getClass().getResource("images/ResourceEnvEntry.gif"));
    private ImageIcon applClientJarIcon;
    private ImageIcon earIcon;
    private ImageIcon standardIcon;
    private DefaultMutableTreeNode node;

    public TreeRenderer() {
        this.resourceEnvProviderIcon = new ImageIcon(this.getClass().getResource("images/ResourceEnvProvider.gif"));
        this.applClientJarIcon = new ImageIcon(this.getClass().getResource("images/ApplClientJar.gif"));
        this.earIcon = new ImageIcon(this.getClass().getResource("images/EAR.gif"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        this.node = (DefaultMutableTreeNode)object;
        if (this.node.isRoot()) {
            this.setToolTipText(null);
            this.setIcon(this.earIcon);
        } else if (!this.node.isRoot()) {
            if (this.node.toString().equals("Data Source Providers")) {
                this.setToolTipText(Utility.getMessage("tree.tttAddDSProvider"));
            } else if (this.node.toString().equals("Mail Providers")) {
                this.setToolTipText(Utility.getMessage("tree.tttAddMailProvider"));
            } else if (this.node.toString().equals("JMS Providers")) {
                this.setToolTipText(Utility.getMessage("tree.tttAddJMSProvider"));
            } else if (this.node.toString().equals("URL Providers")) {
                this.setToolTipText(Utility.getMessage("tree.tttAddURLProvider"));
            } else if (this.node.toString().equals("Resource Environment Providers")) {
                this.setToolTipText(Utility.getMessage("tree.tttAddResEnvProvider"));
            } else if (this.node.toString().equals("Data Sources")) {
                this.setToolTipText(Utility.getMessage("tree.tttAddDSFactory"));
            } else if (this.node.toString().equals("Mail Sessions")) {
                this.setToolTipText(Utility.getMessage("tree.tttAddMailFactory"));
            } else if (this.node.toString().equals("MQ Queue Connection Factories") || this.node.toString().equals("WAS Queue Connection Factories")) {
                this.setToolTipText(Utility.getMessage("tree.tttAddQCFactory"));
            } else if (this.node.toString().equals("MQ Queue Destinations") || this.node.toString().equals("WAS Queue Destinations")) {
                this.setToolTipText(Utility.getMessage("tree.tttAddQDest"));
            } else if (this.node.toString().equals("MQ Topic Connection Factories") || this.node.toString().equals("WAS Topic Connection Factories")) {
                this.setToolTipText(Utility.getMessage("tree.tttAddTCFactory"));
            } else if (this.node.toString().equals("MQ Topic Destinations") || this.node.toString().equals("WAS Topic Destinations")) {
                this.setToolTipText(Utility.getMessage("tree.tttAddTopicDest"));
            } else if (this.node.toString().equals("JMS Connection Factories")) {
                this.setToolTipText(Utility.getMessage("tree.tttAddJMSCFactory"));
            } else if (this.node.toString().equals("JMS Destinations")) {
                this.setToolTipText(Utility.getMessage("tree.tttAddJMSDest"));
            } else if (this.node.toString().equals("URLs")) {
                this.setToolTipText(Utility.getMessage("tree.tttAddURL"));
            } else if (this.node.toString().equals("Resource Environment Entries")) {
                this.setToolTipText(Utility.getMessage("tree.tttAddResEnv"));
            } else if (this.node.toString().endsWith(".jar") && this.node.getLevel() == 1) {
                this.setIcon(this.applClientJarIcon);
                this.setToolTipText(null);
            } else if (this.node.getParent().toString().equals("Data Source Providers")) {
                this.setIcon(this.jdbcDriverIcon);
                this.setToolTipText(Utility.getMessage("tree.tttPropsAndDelete"));
            } else if (this.node.getParent().toString().toString().equals("Mail Providers")) {
                this.setIcon(this.javaMailProviderIcon);
                this.setToolTipText(Utility.getMessage("tree.tttProps"));
            } else if (this.node.getParent().toString().equals("JMS Providers")) {
                this.setIcon(this.jmsProviderIcon);
                this.setToolTipText(Utility.getMessage("tree.tttPropsAndDelete"));
            } else if (this.node.getParent().toString().equals("URL Providers")) {
                this.setIcon(this.urlProviderIcon);
                this.setToolTipText(Utility.getMessage("tree.tttPropsAndDelete"));
            } else if (this.node.getParent().toString().equals("Resource Environment Providers")) {
                this.setIcon(this.resourceEnvProviderIcon);
                this.setToolTipText(Utility.getMessage("tree.tttPropsAndDelete"));
            } else if (this.node.getParent().toString().equals("Data Sources")) {
                this.setIcon(this.jdbcFactoryIcon);
                this.setToolTipText(Utility.getMessage("tree.tttPropsAndDelete"));
            } else if (this.node.getParent().toString().equals("Mail Sessions")) {
                this.setIcon(this.javaMailFactoryIcon);
                this.setToolTipText(Utility.getMessage("tree.tttPropsAndDelete"));
            } else if (this.node.getParent().toString().endsWith("Connection Factories") && this.node.getLevel() == 5) {
                this.setIcon(this.jmsConnectionIcon);
                this.setToolTipText(Utility.getMessage("tree.tttPropsAndDelete"));
            } else if (this.node.getParent().toString().endsWith("Destinations") && this.node.getLevel() == 5) {
                this.setIcon(this.jmsDestinationIcon);
                this.setToolTipText(Utility.getMessage("tree.tttPropsAndDelete"));
            } else if (this.node.getParent().toString().equals("URLs")) {
                this.setIcon(this.urlFactoryIcon);
                this.setToolTipText(Utility.getMessage("tree.tttPropsAndDelete"));
            } else if (this.node.getParent().toString().equals("Resource Environment Entries")) {
                this.setIcon(this.resourceEnvEntryIcon);
                this.setToolTipText(Utility.getMessage("tree.tttPropsAndDelete"));
            } else {
                this.setToolTipText(null);
            }
        }
        return this;
    }
}

