/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.client.ccrct;

import com.ibm.ejs.models.base.resources.ConnectionFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.models.config.jaaslogin.JAASAuthData;
import com.ibm.ws.client.applicationclient.ClientContainerResourceRepository;
import com.ibm.ws.client.ccrct.HelpCoord;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;

public class Utility {
    protected static String kPkgID = "WSCL";
    public static HelpCoord hcoord;
    private static NLS nls;

    public static void displayHelp(String string) {
        if (hcoord == null) {
            hcoord = new HelpCoord();
        }
        try {
            if (hcoord.helpTopicExists(string)) {
                hcoord.findAndShowHelp(string);
            } else {
                hcoord.findAndShowHelp("General:ConceptHelp");
            }
        }
        catch (Exception exception) {
            Utility.printWarning(exception);
        }
    }

    public static String getMessage(String string) {
        return nls.getString(string);
    }

    public static String getMessage(String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        return nls.getFormattedMessage(string, objectArray, "Internal Error: cannot find messsage key " + string);
    }

    public static String getMessage(String string, String[] stringArray) {
        return nls.getFormattedMessage(string, (Object[])stringArray, "Internal Error: cannot find messsage key " + string);
    }

    public static void printWarning(TraceComponent traceComponent, Throwable throwable) {
        if (traceComponent.isDebugEnabled()) {
            Tr.debug(traceComponent, throwable.getMessage());
        }
        Utility.printWarning(throwable.getMessage());
    }

    public static void printWarning(Throwable throwable) {
        System.err.println(throwable.getMessage());
    }

    public static void printWarning(String string) {
        System.err.println(string);
    }

    public static void printMessage(String string) {
        System.out.println(string);
    }

    public static void printMessage(TraceComponent traceComponent, String string) {
        if (traceComponent.isDebugEnabled()) {
            Tr.debug(traceComponent, string);
        }
        System.out.println(string);
    }

    public static void printUnknownException(TraceComponent traceComponent, Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = Utility.writeStackTrace(throwable);
        String string = byteArrayOutputStream.toString();
        int n = string.indexOf(kPkgID, kPkgID.length());
        if (n > 0) {
            string = string.substring(0, n - 1) + "\n" + string.substring(n);
        }
        if (traceComponent.isDebugEnabled()) {
            Tr.debug(traceComponent, "ccrct.exception", new Object[]{string});
        }
        Utility.printWarning(Utility.getMessage("ccrct.exception", string));
    }

    public static void printUnknownException(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = Utility.writeStackTrace(throwable);
        Utility.printWarning(Utility.getMessage("ccrct.exception", byteArrayOutputStream.toString()));
    }

    public static String propertiesToString(Properties properties) {
        String string = "";
        Enumeration<Object> enumeration = properties.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = string + string2 + "\n";
        }
        return string;
    }

    public static String propertiesToStringFormatted(String string, Properties properties) {
        String string2 = "";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String[] stringArray = new String[]{string3, properties.getProperty(string3)};
            string2 = string2 + Utility.getMessage(string, stringArray);
        }
        return string2;
    }

    public static void handleAuthData(ClientContainerResourceRepository clientContainerResourceRepository, ConnectionFactory connectionFactory, String string, boolean bl, String string2, boolean bl2) {
        JAASAuthData jAASAuthData = null;
        if (com.ibm.ws.client.applicationclient.Utility.isStringSet(connectionFactory.getAuthDataAlias())) {
            jAASAuthData = clientContainerResourceRepository.findJAASAuthData(connectionFactory.getAuthDataAlias());
            if (jAASAuthData != null) {
                if (bl || bl2) {
                    Utility.updateJAASAuthData(jAASAuthData, string, bl, string2, bl2, connectionFactory.getAuthDataAlias());
                } else {
                    clientContainerResourceRepository.removeJAASAuthData(jAASAuthData);
                }
            } else {
                jAASAuthData = clientContainerResourceRepository.createJAASAuthData();
                Utility.updateJAASAuthData(jAASAuthData, string, bl, string2, bl2, connectionFactory.getAuthDataAlias());
                clientContainerResourceRepository.addJAASAuthData(jAASAuthData);
            }
        } else if (bl || bl2) {
            jAASAuthData = clientContainerResourceRepository.createJAASAuthData();
            connectionFactory.setAuthDataAlias(connectionFactory.getClass().getName() + "." + connectionFactory.getName());
            Utility.updateJAASAuthData(jAASAuthData, string, bl, string2, bl2, connectionFactory.getAuthDataAlias());
            clientContainerResourceRepository.addJAASAuthData(jAASAuthData);
        }
    }

    private static void updateJAASAuthData(JAASAuthData jAASAuthData, String string, boolean bl, String string2, boolean bl2, String string3) {
        if (bl) {
            jAASAuthData.setUserId(string);
        }
        if (bl2) {
            jAASAuthData.setPassword(string2);
        }
        jAASAuthData.setAlias(string3);
    }

    private static ByteArrayOutputStream writeStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        return byteArrayOutputStream;
    }

    static {
        nls = null;
        nls = new NLS("com.ibm.ws.client.ccrct.ResourceConfigToolResourceBundle");
    }
}

