/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf2xml.impl;

import com.ibm.etools.emf2xml.EMF2DOMAdapter;
import com.ibm.etools.emf2xml.Renderer;
import com.ibm.etools.emf2xml.TranslatorResource;
import com.ibm.etools.emf2xml.impl.AbstractRendererImpl;
import com.ibm.etools.emf2xml.impl.RootEMF2DOMAdapterImpl;
import com.ibm.etools.emf2xml.util.DOMLoadOptions;
import com.ibm.etools.emf2xml.util.DOMUtilities;
import com.ibm.etools.wft.util.Revisit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.emf.common.util.WrappedException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EMF2DOMRenderer
extends AbstractRendererImpl
implements Renderer {
    protected Map domAdapterRegistry;
    protected boolean needsToCreateDOM = true;
    protected Document document;

    public EMF2DOMRenderer() {
        if (this.managesDOMAdapters()) {
            this.initDOMAdapterRegistry();
        }
    }

    public void doLoad(InputStream inputStream, Map map) {
        this.needsToCreateDOM = false;
        if (inputStream != null) {
            this.loadDocument(inputStream, map);
            EMF2DOMAdapter eMF2DOMAdapter = this.createRootDOMAdapter();
            eMF2DOMAdapter.updateMOF();
        }
    }

    protected void loadDocument(InputStream inputStream, Map map) {
        try {
            DOMLoadOptions dOMLoadOptions = new DOMLoadOptions();
            dOMLoadOptions.setAllowJavaEncodings(true);
            dOMLoadOptions.setExpandEntityRefererences(true);
            dOMLoadOptions.setValidate(true);
            this.document = DOMUtilities.loadDocument(inputStream, dOMLoadOptions, this.getResource().getEntityResolver());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new WrappedException((Exception)parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new WrappedException((Exception)iOException);
        }
        catch (SAXException sAXException) {
            throw new WrappedException((Exception)sAXException);
        }
    }

    public void doSave(OutputStream outputStream, Map map) throws IOException {
        this.createDOMTreeIfNecessary();
        this.serializeDocument(outputStream);
    }

    protected boolean managesDOMAdapters() {
        return true;
    }

    protected void initDOMAdapterRegistry() {
        if (this.domAdapterRegistry == null) {
            this.domAdapterRegistry = new HashMap();
        }
    }

    public void registerDOMAdapter(Node node, EMF2DOMAdapter eMF2DOMAdapter) {
        this.domAdapterRegistry.put(node, eMF2DOMAdapter);
    }

    public EMF2DOMAdapter getExistingDOMAdapter(Node node) {
        return (EMF2DOMAdapter)this.domAdapterRegistry.get(node);
    }

    public void removeDOMAdapter(Node node, EMF2DOMAdapter eMF2DOMAdapter) {
        this.domAdapterRegistry.remove(node);
    }

    public void prepareToAddContents() {
    }

    protected Node createDOMTree() {
        this.createDocument();
        EMF2DOMAdapter eMF2DOMAdapter = this.createRootDOMAdapter();
        eMF2DOMAdapter.updateDOM();
        this.needsToCreateDOM = false;
        return this.document;
    }

    protected EMF2DOMAdapter createRootDOMAdapter() {
        RootEMF2DOMAdapterImpl rootEMF2DOMAdapterImpl = new RootEMF2DOMAdapterImpl(this.getResource(), this.document, this, this.getResource().getRootTranslator());
        this.registerDOMAdapter(this.document, rootEMF2DOMAdapterImpl);
        return rootEMF2DOMAdapterImpl;
    }

    protected void createDOMTreeIfNecessary() {
        if (this.needsToCreateDOM) {
            this.createDOMTree();
        }
    }

    protected void createDocument() {
        TranslatorResource translatorResource = this.getResource();
        translatorResource.setDefaults();
        Object var2_2 = null;
        try {
            this.document = DOMUtilities.createNewDocument(translatorResource.getDoctype(), translatorResource.getPublicId(), translatorResource.getSystemId());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new WrappedException((Exception)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new WrappedException((Exception)sAXException);
        }
        catch (IOException iOException) {
            throw new WrappedException((Exception)iOException);
        }
    }

    public void serializeDocument(OutputStream outputStream) throws IOException {
        OutputFormat outputFormat = this.createOutputFormat();
        Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer(outputStream, outputFormat);
        serializer.asDOMSerializer().serialize(this.document);
    }

    protected OutputFormat createOutputFormat() {
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setIndenting(true);
        outputFormat.setLineSeparator(DOMUtilities.NEWLINE_STRING);
        outputFormat.setEncoding(this.getResource().getEncoding());
        outputFormat.setVersion(this.getResource().getXMLVersion());
        return outputFormat;
    }

    public void replaceDocumentType(String string, String string2, String string3) {
        Revisit.revisit();
        Document document = null;
        try {
            document = DOMUtilities.createNewDocument(string, string2, string3);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new WrappedException((Exception)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new WrappedException((Exception)sAXException);
        }
        catch (IOException iOException) {
            throw new WrappedException((Exception)iOException);
        }
        this.replaceNode(this.document.getDocumentElement(), document, document);
        this.readapt(this.document, document);
        this.document = document;
    }

    protected void replaceNode(Node node, Node node2, Document document) {
        Node node3 = document.importNode(node, false);
        node2.appendChild(node3);
        this.readapt(node, node3);
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            this.replaceNode(nodeList.item(n2), node3, document);
            ++n2;
        }
    }

    protected void readapt(Node node, Node node2) {
        EMF2DOMAdapter eMF2DOMAdapter = this.getExistingDOMAdapter(node);
        if (eMF2DOMAdapter != null) {
            this.registerDOMAdapter(node2, eMF2DOMAdapter);
            if (eMF2DOMAdapter.getNode() == node) {
                eMF2DOMAdapter.setNode(node2);
            }
        }
    }

    public int getVersionID() {
        return this.getResource().getVersionID();
    }
}

