/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf2xml.util;

import com.ibm.etools.emf2xml.util.Assert;
import com.ibm.etools.emf2xml.util.DOMLoadOptions;
import com.ibm.etools.logger.proxy.Logger;
import com.ibm.etools.wft.util.Revisit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMUtilities {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final String INDENT_STRING = "\t";
    public static final String NEWLINE_STRING = System.getProperty("line.separator");
    private static final String DUMMY_ENTITY_STRING = "dummy";
    private static final String DUMMY_ENTITY_NODE_STRING = "<dummy/>";
    private static DocumentBuilder defaultDocumentBuilder;
    private static EntityResolver defaultEntityResolver;

    public static Iterator createPathIterator(String string) {
        String string2;
        String string3 = string2 = string.startsWith("/") ? string.substring(1) : string;
        if (string2.length() == 0) {
            string2 = null;
        }
        final String string4 = string2;
        return new Iterator(){
            int prevIndex = 0;
            int curIndex = 0;
            String pathString = string4;

            public boolean hasNext() {
                return this.pathString != null && this.prevIndex != -1;
            }

            public Object next() {
                this.curIndex = this.pathString.indexOf(47, this.prevIndex);
                String string = null;
                string = this.curIndex != -1 ? this.pathString.substring(this.prevIndex, this.curIndex++) : this.pathString.substring(this.prevIndex);
                this.prevIndex = this.curIndex;
                return string;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static String getChildText(Node node) {
        Text text = DOMUtilities.getChildTextNode(node);
        if (text != null) {
            return text.getData();
        }
        return null;
    }

    public static Text getChildTextNode(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null && DOMUtilities.isTextNode(node2)) {
            if (!DOMUtilities.isWhitespace(node2)) {
                return (Text)node2;
            }
            node2 = node2.getNextSibling();
        }
        return null;
    }

    public static String getIndentString(Node node) {
        Revisit.toDo();
        return "";
    }

    public static Node getLastNodeChild(Node node) {
        if (node == null) {
            return null;
        }
        Node node2 = node.getLastChild();
        while (node2 != null && node2.getNodeType() == 3) {
            node2 = node2.getPreviousSibling();
        }
        return node2;
    }

    public static Node getNextNodeSibling(Node node) {
        Node node2 = node.getNextSibling();
        while (node2 != null && node2.getNodeType() != 1) {
            node2 = node2.getNextSibling();
        }
        return node2;
    }

    public static Node getNodeChild(Node node, String string) {
        Node node2 = null;
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node3 = nodeList.item(n);
            if (node3.getNodeType() == 1 && node3.getNodeName().equals(string)) {
                node2 = node3;
                break;
            }
            ++n;
        }
        return node2;
    }

    public static Node getNodeChildForPath(Node node, String string) {
        Node node2 = node;
        Iterator iterator = DOMUtilities.createPathIterator(string);
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if ((node2 = DOMUtilities.getNodeChild(node2, string2)) != null) continue;
            return null;
        }
        return node2;
    }

    public static List getNodeChildren(Node node, String[] stringArray) {
        NodeList nodeList = node.getChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeType() == 1) {
                boolean bl = false;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (stringArray[n2].equals(node2.getNodeName())) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (bl) {
                    arrayList.add(node2);
                }
            }
            ++n;
        }
        return arrayList;
    }

    public static List getNodeChildren(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeType() == 1 && node2.getNodeName().equals(string)) {
                arrayList.add(node2);
            }
            ++n;
        }
        return arrayList;
    }

    public static Node getPreviousNodeSibling(Node node) {
        if (node == null) {
            return null;
        }
        Node node2 = node.getPreviousSibling();
        while (node2 != null && DOMUtilities.isTextNode(node2)) {
            node2 = node2.getPreviousSibling();
        }
        return node2;
    }

    public static Text getPreviousText(Node node) {
        Text text = DOMUtilities.getPreviousTextSibling(node);
        if (text == null && node.getParentNode() != null) {
            text = DOMUtilities.getPreviousText(node.getParentNode());
        }
        return text;
    }

    public static Text getPreviousTextSibling(Node node) {
        Assert.isNotNull(node);
        Node node2 = node.getPreviousSibling();
        Node node3 = null;
        while (node2 != null && node2.getNodeType() == 3) {
            node3 = node2;
            node2 = node2.getPreviousSibling();
        }
        return (Text)node3;
    }

    public static String getTrailingWhitespace(Text text) {
        Assert.isNotNull(text);
        String string = text.getData();
        if (string.length() == 0) {
            return "";
        }
        int n = string.length() - 1;
        while (n >= 0) {
            if (!Character.isWhitespace(string.charAt(n))) break;
            --n;
        }
        return string.substring(++n);
    }

    public static void insertAfterNode(Node node, Node node2, Node node3) {
        Node node4 = null;
        if (node3 != null) {
            node4 = node3.getNextSibling();
        }
        if (node3 == null) {
            DOMUtilities.insertBeforeNode(node, node2, node.getFirstChild());
        } else {
            DOMUtilities.insertBeforeNode(node, node2, node4);
        }
    }

    public static void insertBeforeNode(Node node, Node node2, Node node3) {
        if (node2.getNodeType() == 3) {
            Node node4;
            Text text = (Text)node2;
            if (node3 != null && node3.getNodeType() == 3) {
                Text text2 = (Text)node3;
                text2.setData(text.getData() + text2.getData());
                return;
            }
            Node node5 = node4 = node3 == null ? node.getLastChild() : node3.getPreviousSibling();
            if (node4 != null && node4.getNodeType() == 3) {
                Text text3 = (Text)node4;
                text3.setData(text3.getData() + text.getData());
                return;
            }
        }
        node.insertBefore(node2, node3);
    }

    public static void insertBeforeNodeAndWhitespace(Node node, Node node2, Node node3) {
        Node node4 = node3 == null ? node.getLastChild() : node3.getPreviousSibling();
        Node node5 = node3;
        while (node4 != null && DOMUtilities.isWhitespace(node4)) {
            node5 = node4;
            node4 = node4.getPreviousSibling();
        }
        DOMUtilities.insertBeforeNode(node, node2, node5);
    }

    public static boolean isTextNode(Node node) {
        Assert.isNotNull(node);
        return node.getNodeType() == 3 || node.getNodeType() == 4;
    }

    public static boolean isWhitespace(Node node) {
        Assert.isNotNull(node);
        if (node.getNodeType() != 3) {
            return false;
        }
        Text text = (Text)node;
        String string = text.getData();
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (!Character.isWhitespace(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void removeAllChildren(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            node.removeChild(nodeList.item(n));
            ++n;
        }
    }

    public static ArrayList getAllNodes(Node node, String string) {
        ArrayList arrayList = new ArrayList();
        String[] stringArray = new String[]{string};
        DOMUtilities.findAllNodes(node, stringArray, arrayList);
        return arrayList;
    }

    public static ArrayList getAllNodes(Node node, String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        DOMUtilities.findAllNodes(node, stringArray, arrayList);
        return arrayList;
    }

    private static void findAllNodes(Node node, String string, ArrayList arrayList) {
        String[] stringArray = new String[]{string};
        DOMUtilities.findAllNodes(node, stringArray, arrayList);
    }

    private static void findAllNodes(Node node, String[] stringArray, ArrayList arrayList) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (nodeList.item(n).getNodeName().equals(stringArray[n2])) {
                        arrayList.add(nodeList.item(n));
                    }
                    ++n2;
                }
                DOMUtilities.findAllNodes(nodeList.item(n), stringArray, arrayList);
                ++n;
            }
        }
    }

    public static DocumentBuilder newDefaultDocumentBuilder(DOMLoadOptions dOMLoadOptions) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(dOMLoadOptions.isValidate());
        documentBuilderFactory.setNamespaceAware(dOMLoadOptions.isValidate());
        try {
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/allow-java-encodings", new Boolean(dOMLoadOptions.isAllowJavaEncodings()));
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/validation/schema", new Boolean(dOMLoadOptions.isValidate()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        documentBuilderFactory.setExpandEntityReferences(dOMLoadOptions.isExpandEntityRefererences());
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }

            public void warning(SAXParseException sAXParseException) throws SAXException {
                Logger.getLogger().logWarning((Throwable)sAXParseException);
            }
        });
        return documentBuilder;
    }

    public static Document createNewDocument(String string, String string2, String string3) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = DOMUtilities.getDefaultDocumentBuilder();
        InputStream inputStream = DOMUtilities.createHeaderInputStream(string, string2, string3);
        Document document = documentBuilder.parse(inputStream);
        DOMUtilities.removeDummyEntity(document);
        DOMUtilities.removeExtraneousComments(document);
        return document;
    }

    public static Document loadDocument(InputStream inputStream, DOMLoadOptions dOMLoadOptions, EntityResolver entityResolver) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = DOMUtilities.newDefaultDocumentBuilder(dOMLoadOptions);
        documentBuilder.setEntityResolver(entityResolver);
        Document document = documentBuilder.parse(inputStream);
        DOMUtilities.removeExtraneousComments(document);
        return document;
    }

    private static InputStream createHeaderInputStream(String string, String string2, String string3) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.write("<?xml version=\"");
        printWriter.write("1.0");
        printWriter.write("\" encoding=\"");
        printWriter.write("UTF-8");
        printWriter.write("\"?>");
        printWriter.println();
        if (string != null) {
            printWriter.write("<!DOCTYPE ");
            printWriter.write(string);
            printWriter.write(" PUBLIC \"");
            printWriter.write(string2);
            printWriter.write("\" \"");
            printWriter.write(string3);
            printWriter.write("\">");
            printWriter.println();
        }
        DOMUtilities.addDummyEntity(printWriter);
        printWriter.flush();
        printWriter.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private static void addDummyEntity(PrintWriter printWriter) {
        Revisit.revisit();
        printWriter.println(DUMMY_ENTITY_NODE_STRING);
    }

    private static void removeDummyEntity(Document document) {
        document.removeChild(DOMUtilities.getNodeChild(document, DUMMY_ENTITY_STRING));
    }

    private static void removeExtraneousComments(Document document) {
        Node node = document.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getNodeType() == 8) {
                document.removeChild(node);
            }
            node = node2;
        }
    }

    public static DocumentBuilder getDefaultDocumentBuilder() throws ParserConfigurationException {
        if (defaultDocumentBuilder == null) {
            DOMLoadOptions dOMLoadOptions = new DOMLoadOptions();
            dOMLoadOptions.setAllowJavaEncodings(true);
            dOMLoadOptions.setExpandEntityRefererences(true);
            dOMLoadOptions.setValidate(false);
            defaultDocumentBuilder = DOMUtilities.newDefaultDocumentBuilder(dOMLoadOptions);
            defaultDocumentBuilder.setEntityResolver(defaultEntityResolver);
            defaultDocumentBuilder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException sAXParseException) throws SAXException {
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                }

                public void warning(SAXParseException sAXParseException) throws SAXException {
                }
            });
        }
        return defaultDocumentBuilder;
    }

    public static EntityResolver getDefaultEntityResolver() {
        return defaultEntityResolver;
    }

    public static void setDefaultEntityResolver(EntityResolver entityResolver) {
        defaultEntityResolver = entityResolver;
    }
}

