/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf2xml.util;

import com.ibm.etools.emf2xml.util.FeatureValueConversionException;
import com.ibm.etools.emf2xml.util.FeatureValueConverter;
import com.ibm.etools.wft.nls.ResourceHandler;
import java.text.MessageFormat;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class DefaultFeatureValueConverter
implements FeatureValueConverter {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private static final String FAILED_CONVERSION_PATTERN = ResourceHandler.getString((String)"Failed_to_convert_{0}_to_{_ERROR_");

    protected Object convertToBoolean(Object object) {
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        if (object instanceof Boolean) {
            return object;
        }
        return this.failedToConvert(object, ResourceHandler.getString((String)"Boolean_UI_"));
    }

    protected Object convertToByte(Object object) {
        if (object instanceof String) {
            return Byte.valueOf((String)object);
        }
        if (object instanceof Byte) {
            return object;
        }
        return this.failedToConvert(object, ResourceHandler.getString((String)"Byte_UI_"));
    }

    protected Object convertToCharacter(Object object) {
        if (object instanceof String && ((String)object).length() == 1) {
            return new Character(((String)object).charAt(0));
        }
        if (object instanceof Character) {
            return object;
        }
        return this.failedToConvert(object, ResourceHandler.getString((String)"Character_UI_"));
    }

    protected Object convertToDouble(Object object) {
        if (object instanceof String) {
            try {
                return Double.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return this.defaultDouble();
            }
        }
        if (object instanceof Double) {
            return object;
        }
        return this.failedToConvert(object, ResourceHandler.getString((String)"Double_UI_"));
    }

    protected Object convertToEnum(Object object, EStructuralFeature eStructuralFeature) {
        EEnumLiteral eEnumLiteral = null;
        EEnum eEnum = (EEnum)eStructuralFeature.getEType();
        if (object instanceof String) {
            eEnumLiteral = eEnum.getEEnumLiteral((String)object);
        } else if (object instanceof Integer) {
            eEnumLiteral = eEnum.getEEnumLiteral(((Integer)object).intValue());
        } else if (object instanceof EEnumLiteral) {
            eEnumLiteral = (EEnumLiteral)object;
        }
        if (eEnumLiteral == null) {
            return this.failedToConvert(object, ResourceHandler.getString((String)"Enumeration_UI_"));
        }
        return eEnumLiteral.getInstance();
    }

    protected Object convertToFloat(Object object) {
        if (object instanceof String) {
            try {
                return Float.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return this.defaultFloat();
            }
        }
        if (object instanceof Float) {
            return object;
        }
        return this.failedToConvert(object, ResourceHandler.getString((String)"Float_UI_"));
    }

    protected Object convertToInteger(Object object) {
        if (object instanceof String) {
            try {
                return Integer.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return this.defaultInteger();
            }
        }
        if (object instanceof Integer) {
            return object;
        }
        return this.failedToConvert(object, ResourceHandler.getString((String)"Integer_UI_"));
    }

    protected Object convertToJavaObject(Object object) {
        return object;
    }

    protected Object convertToLong(Object object) {
        if (object instanceof String) {
            try {
                return Long.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return this.defaultLong();
            }
        }
        if (object instanceof Long) {
            return object;
        }
        return this.failedToConvert(object, ResourceHandler.getString((String)"Long_UI_"));
    }

    protected Object convertToMofObject(Object object) {
        if (object instanceof EObject) {
            return object;
        }
        return this.failedToConvert(object, ResourceHandler.getString((String)"MofObject_UI_"));
    }

    protected Object convertToShort(Object object) {
        if (object instanceof String) {
            try {
                return Short.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return this.defaultShort();
            }
        }
        if (object instanceof Short) {
            return object;
        }
        return this.failedToConvert(object, ResourceHandler.getString((String)"Short_UI_"));
    }

    protected Object convertToString(Object object) {
        return object.toString();
    }

    protected Object convertValue(Object object, EAttribute eAttribute) {
        EClassifier eClassifier = eAttribute.getEType();
        if (eClassifier.eClass() == EcorePackage.eINSTANCE.getEEnum()) {
            return this.convertToEnum(object, (EStructuralFeature)eAttribute);
        }
        switch (eClassifier.getClassifierID()) {
            case 39: {
                return this.convertToString(object);
            }
            case 18: 
            case 19: {
                return this.convertToBoolean(object);
            }
            case 30: 
            case 31: {
                return this.convertToInteger(object);
            }
            case 28: 
            case 29: {
                return this.convertToFloat(object);
            }
            case 20: 
            case 21: {
                return this.convertToCharacter(object);
            }
            case 34: 
            case 35: {
                return this.convertToLong(object);
            }
            case 22: 
            case 23: {
                return this.convertToByte(object);
            }
            case 24: 
            case 25: {
                return this.convertToDouble(object);
            }
            case 37: 
            case 38: {
                return this.convertToShort(object);
            }
            case 10: {
                return this.convertToMofObject(object);
            }
            case 33: {
                return this.convertToJavaObject(object);
            }
        }
        return object;
    }

    public Object convertValue(Object object, EStructuralFeature eStructuralFeature) {
        if (object == null || eStructuralFeature == null || !(eStructuralFeature instanceof EAttribute)) {
            return object;
        }
        return this.convertValue(object, (EAttribute)eStructuralFeature);
    }

    protected Double defaultDouble() {
        return null;
    }

    protected Float defaultFloat() {
        return null;
    }

    protected Integer defaultInteger() {
        return null;
    }

    protected Long defaultLong() {
        return null;
    }

    protected Short defaultShort() {
        return null;
    }

    protected Object failedToConvert(Object object, String string) {
        String string2 = MessageFormat.format(FAILED_CONVERSION_PATTERN, object.toString(), string);
        throw new FeatureValueConversionException(string2);
    }
}

