/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.java;

import com.ibm.etools.java.impl.URL;

public class JavaURL
extends URL {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final String JAVA_PROTOCOL_URI_PREFIX = "java:/";

    public JavaURL(String string) {
        super(string);
    }

    public JavaURL(String string, String string2) {
        super(null, null);
        this.initializeNamespaceString(string);
        this.ID = string2;
    }

    public String getClassName() {
        return this.ID;
    }

    public String getFullString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.namespaceName != null) {
            stringBuffer.append(this.namespaceName);
            if (this.ID != null) {
                stringBuffer.append("#");
            }
        }
        if (this.ID != null) {
            stringBuffer.append(this.ID);
        }
        return stringBuffer.toString();
    }

    public String getPackageName() {
        String string = this.namespaceName.substring(JAVA_PROTOCOL_URI_PREFIX.length(), this.namespaceName.length());
        return ".javaprim".equals(string) ? "" : string;
    }

    public void initializeFromString(String string) {
        if (string.indexOf("#") != -1) {
            super.initializeFromString(string);
        } else {
            int n = string.lastIndexOf(46);
            if (n == -1) {
                this.initializeNamespaceString(null);
            } else {
                this.initializeNamespaceString(string.substring(0, n));
            }
            this.ID = string.substring(n + 1);
        }
    }

    public void initializeNamespaceString(String string) {
        this.namespaceName = string == null ? JAVA_PROTOCOL_URI_PREFIX : JAVA_PROTOCOL_URI_PREFIX + string;
    }

    public static boolean isJavaURL(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith(JAVA_PROTOCOL_URI_PREFIX);
    }

    public String toString() {
        return "URL(" + this.getFullString() + ")";
    }
}

