/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.java.adapters;

import com.ibm.etools.java.JavaRefPackage;
import com.ibm.etools.java.adapters.JavaReflectionAdaptor;
import com.ibm.etools.java.adapters.ReflectionAdaptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public abstract class JavaReflectionAdapterFactory
extends AdapterFactoryImpl {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected HashMap reflected = new HashMap();
    protected static final String TYPE_NAME = "JavaReflection";
    protected boolean isBusyIteratingReflected = false;
    protected Map registerQueue;
    protected List unregisterQueue;

    public Adapter createAdapter(Notifier notifier) {
        ReflectionAdaptor reflectionAdaptor = null;
        EObject eObject = (EObject)notifier;
        JavaRefPackage javaRefPackage = this.getJavaRefPackage();
        if (eObject.eClass() == javaRefPackage.getJavaClass()) {
            reflectionAdaptor = this.createJavaClassAdaptor(notifier);
        } else if (eObject.eClass() == javaRefPackage.getArrayType()) {
            reflectionAdaptor = this.createArrayTypeAdaptor(notifier);
        } else if (eObject.eClass() == javaRefPackage.getMethod()) {
            reflectionAdaptor = this.createJavaMethodAdaptor(notifier);
        } else if (eObject.eClass() == javaRefPackage.getField()) {
            reflectionAdaptor = this.createJavaFieldAdaptor(notifier);
        }
        return reflectionAdaptor;
    }

    protected ReflectionAdaptor createArrayTypeAdaptor(Notifier notifier) {
        return this.createJavaClassAdaptor(notifier);
    }

    protected abstract ReflectionAdaptor createJavaClassAdaptor(Notifier var1);

    protected abstract ReflectionAdaptor createJavaFieldAdaptor(Notifier var1);

    protected abstract ReflectionAdaptor createJavaMethodAdaptor(Notifier var1);

    public Notification disAssociateSource(String string) {
        return this.disAssociateSource(string, true);
    }

    public Notification disAssociateSource(String string, boolean bl) {
        JavaReflectionAdaptor javaReflectionAdaptor = (JavaReflectionAdaptor)this.reflected.get(string);
        Notification notification = null;
        if (javaReflectionAdaptor != null) {
            if (bl) {
                javaReflectionAdaptor.releaseSourceType();
            } else {
                notification = javaReflectionAdaptor.releaseSourceTypeNoNotification();
            }
        }
        return notification;
    }

    public void flushAll() {
    }

    public void flushReflection(String string) {
    }

    protected JavaRefPackage getJavaRefPackage() {
        return (JavaRefPackage)EPackage.Registry.INSTANCE.getEPackage("java.xmi");
    }

    public void registerReflection(String string, ReflectionAdaptor reflectionAdaptor) {
        if (this.isBusyIteratingReflected) {
            if (this.registerQueue == null) {
                this.registerQueue = new HashMap();
            }
            this.registerQueue.put(string, reflectionAdaptor);
        } else {
            this.reflected.put(string, reflectionAdaptor);
        }
    }

    public void unregisterReflection(String string) {
        if (this.isBusyIteratingReflected) {
            if (this.unregisterQueue == null) {
                this.unregisterQueue = new ArrayList();
            }
            this.unregisterQueue.add(string);
        } else {
            this.reflected.remove(string);
        }
    }

    public void disAssociateSourcePlusInner(String string) {
        this.disAssociateSourcePlusInner(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Notification disAssociateSourcePlusInner(String string, boolean bl) {
        this.isBusyIteratingReflected = true;
        Notification notification = null;
        try {
            String string2 = string + '$';
            Iterator iterator = this.reflected.entrySet().iterator();
            while (iterator.hasNext()) {
                JavaReflectionAdaptor javaReflectionAdaptor;
                Map.Entry entry = iterator.next();
                String string3 = (String)entry.getKey();
                if (!string3.equals(string) && !string3.startsWith(string2) || (javaReflectionAdaptor = (JavaReflectionAdaptor)this.reflected.get(string3)) == null) continue;
                if (bl) {
                    javaReflectionAdaptor.releaseSourceType();
                    continue;
                }
                notification = javaReflectionAdaptor.releaseSourceTypeNoNotification();
            }
            Object var10_9 = null;
            this.finishedIteratingReflected();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.finishedIteratingReflected();
            throw throwable;
        }
        return notification;
    }

    protected void finishedIteratingReflected() {
        this.isBusyIteratingReflected = false;
        if (this.unregisterQueue != null && !this.unregisterQueue.isEmpty()) {
            int n = 0;
            while (n < this.unregisterQueue.size()) {
                this.reflected.remove(this.unregisterQueue.get(n));
                ++n;
            }
            this.unregisterQueue.clear();
        }
        if (this.registerQueue != null && !this.registerQueue.isEmpty()) {
            Iterator iterator = this.registerQueue.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.reflected.put(entry.getKey(), entry.getValue());
            }
            this.registerQueue.clear();
        }
    }
}

