/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.java.adapters;

import com.ibm.etools.java.ArrayType;
import com.ibm.etools.java.Field;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaDataType;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.JavaParameter;
import com.ibm.etools.java.JavaRefFactory;
import com.ibm.etools.java.Method;
import com.ibm.etools.java.adapters.IJavaReflectionKeyExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class JavaReflectionKey {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final String N_VOID = "void";
    public static final String N_INT = "int";
    public static final String N_BOOLEAN = "boolean";
    public static final String N_CHAR = "char";
    public static final String N_BYTE = "byte";
    public static final String N_LONG = "long";
    public static final String N_FLOAT = "float";
    public static final String N_DOUBLE = "double";
    public static final String N_SHORT = "short";
    private static final Collection PRIMITIVES = new ArrayList(8);
    protected XMIResource resource;
    protected List extensions;

    public JavaReflectionKey(List list, XMIResource xMIResource) {
        this.extensions = list;
        this.resource = xMIResource;
    }

    public ArrayType createArrayType() {
        return JavaReflectionKey.getJavaFactory().createArrayType();
    }

    public JavaClass createJavaClass() {
        return JavaReflectionKey.getJavaFactory().createJavaClass();
    }

    protected EClassifier getJavaDataType(String string) {
        JavaDataType javaDataType = JavaReflectionKey.getJavaFactory().createJavaDataType();
        javaDataType.setName(string);
        this.getPackage().getEClassifiers().add((Object)javaDataType);
        this.resource.setID((EObject)javaDataType, string);
        return javaDataType;
    }

    public Field createJavaField() {
        return JavaReflectionKey.getJavaFactory().createField();
    }

    public Method createJavaMethod() {
        return JavaReflectionKey.getJavaFactory().createMethod();
    }

    public JavaParameter createJavaParameter() {
        return JavaReflectionKey.getJavaFactory().createJavaParameter();
    }

    public Object get(String string) {
        Object object = this.getObjectFromExtensions(string);
        if (object == null) {
            object = this.getJavaObject(string);
        }
        return object;
    }

    public EClassifier getArrayType(String string) {
        ArrayType arrayType = this.createArrayType();
        arrayType.setName(string);
        int n = -1;
        int n2 = 0;
        do {
            if ((n = string.indexOf("[", n + 1)) == -1) continue;
            ++n2;
        } while (n != -1);
        arrayType.setArrayDimensions(n2);
        this.getPackage().getEClassifiers().add((Object)arrayType);
        this.resource.setID((EObject)arrayType, string);
        return arrayType;
    }

    public EClassifier getJavaClass(String string) {
        JavaClass javaClass = this.createJavaClass();
        javaClass.setName(string);
        this.getPackage().getEClassifiers().add((Object)javaClass);
        this.resource.setID((EObject)javaClass, string);
        return javaClass;
    }

    protected static JavaRefFactory getJavaFactory() {
        return JavaRefFactory.eINSTANCE;
    }

    protected Field getJavaField(String string) {
        Field field = null;
        int n = string.indexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        EClassifier eClassifier = (EClassifier)this.primGet(string2);
        if (eClassifier == null) {
            eClassifier = this.getJavaType(string2);
        }
        if (eClassifier != null && !((JavaHelpers)eClassifier).isPrimitive()) {
            ((JavaClass)eClassifier).getFields();
            field = (Field)this.primGet(string);
            if (field == null) {
                Field field2 = this.createJavaField();
                field2.setName(string3);
                ((JavaClass)eClassifier).getFields().add((Object)field2);
                field = field2;
            }
        }
        return field;
    }

    protected Method getJavaMethod(String string) {
        Method method = null;
        int n = string.indexOf(46);
        String string2 = string.substring(0, n);
        int n2 = string.indexOf(40, n);
        String string3 = string.substring(n + 1, n2);
        EClassifier eClassifier = (EClassifier)this.primGet(string2);
        if (eClassifier == null) {
            eClassifier = this.getJavaType(string2);
        }
        if (eClassifier != null && !((JavaHelpers)eClassifier).isPrimitive()) {
            ((JavaClass)eClassifier).getMethods();
            method = (Method)this.primGet(string);
            if (method == null) {
                Method method2 = this.createJavaMethod();
                method2.setName(string3);
                this.resource.setID((EObject)method2, string);
                ((JavaClass)eClassifier).getMethods().add((Object)method2);
                method = method2;
            }
        }
        return method;
    }

    public EObject getJavaObject(String string) {
        Object object = null;
        int n = string.indexOf(46);
        if (n > 0) {
            boolean bl;
            boolean bl2 = bl = string.indexOf(45, n) != -1;
            if (bl) {
                object = this.getJavaParameter(string);
            } else {
                boolean bl3;
                int n2 = string.indexOf(40, n);
                boolean bl4 = bl3 = n2 == -1;
                object = bl3 ? this.getJavaField(string) : this.getJavaMethod(string);
            }
        } else {
            object = this.getJavaType(string);
        }
        return object;
    }

    protected Object getObjectFromExtensions(String string) {
        if (this.extensions != null) {
            Iterator iterator = this.extensions.iterator();
            while (iterator.hasNext()) {
                IJavaReflectionKeyExtension iJavaReflectionKeyExtension = (IJavaReflectionKeyExtension)iterator.next();
                Object object = iJavaReflectionKeyExtension.getObject(string, this);
                if (object == null) continue;
                return object;
            }
        }
        return null;
    }

    protected JavaParameter getJavaParameter(String string) {
        JavaParameter javaParameter = null;
        int n = string.indexOf(46);
        int n2 = string.indexOf(45, n);
        String string2 = string.substring(n2 + 1);
        Method method = this.getJavaMethod(string.substring(n2));
        if (method != null && (javaParameter = method.getParameter(string2)) == null) {
            JavaParameter javaParameter2 = this.createJavaParameter();
            javaParameter2.setName(string2);
            method.getParameters().add((Object)javaParameter2);
            javaParameter = javaParameter2;
        }
        return javaParameter;
    }

    public EClassifier getJavaType(String string) {
        if (this.isPrimitive(string)) {
            return this.getJavaDataType(string);
        }
        if (this.isArray(string)) {
            return this.getArrayType(string);
        }
        if (this.isValidJavaIdentifier(string)) {
            return this.getJavaClass(string);
        }
        return null;
    }

    protected boolean isValidJavaIdentifier(String string) {
        if (string.length() > 0 && Character.isJavaIdentifierStart(string.charAt(0))) {
            int n = 1;
            while (n < string.length()) {
                if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public Object primGet(String string) {
        return this.resource.getIDToEObjectMap().get(string);
    }

    protected EPackage getPackage() {
        return (EPackage)EcoreUtil.getObjectByType((Collection)this.resource.getContents(), (EClassifier)EcorePackage.eINSTANCE.getEPackage());
    }

    private static void initializePrimitivesCollection() {
        PRIMITIVES.add(N_VOID);
        PRIMITIVES.add(N_BOOLEAN);
        PRIMITIVES.add(N_BYTE);
        PRIMITIVES.add(N_CHAR);
        PRIMITIVES.add(N_DOUBLE);
        PRIMITIVES.add(N_FLOAT);
        PRIMITIVES.add(N_INT);
        PRIMITIVES.add(N_LONG);
        PRIMITIVES.add(N_SHORT);
    }

    public boolean isArray(String string) {
        return string.endsWith("[]");
    }

    private boolean isPrimitive(String string) {
        return PRIMITIVES.contains(string);
    }

    static {
        JavaReflectionKey.initializePrimitivesCollection();
    }
}

