/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.java.adapters.jdk;

import com.ibm.etools.java.ArrayType;
import com.ibm.etools.java.Field;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.Method;
import com.ibm.etools.java.adapters.JavaReflectionAdaptor;
import com.ibm.etools.java.adapters.jdk.JavaJDKAdapterFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;

public abstract class JDKAdaptor
extends JavaReflectionAdaptor {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public JavaJDKAdapterFactory adapterFactory;

    public JDKAdaptor(Notifier notifier, JavaJDKAdapterFactory javaJDKAdapterFactory) {
        super(notifier);
        this.setAdapterFactory(javaJDKAdapterFactory);
    }

    public static String computeMethodID(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = JDKAdaptor.getSimpleName(constructor.getDeclaringClass().getName());
        stringBuffer.append(string);
        stringBuffer.append('.');
        stringBuffer.append(JDKAdaptor.computeMethodName(constructor));
        stringBuffer.append('(');
        Class<?>[] classArray = constructor.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(classArray[n].getName());
            if (n < classArray.length - 1) {
                stringBuffer.append(',');
            }
            ++n;
        }
        stringBuffer.append("_V");
        return stringBuffer.toString();
    }

    public static String computeMethodID(java.lang.reflect.Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = JDKAdaptor.getSimpleName(method.getDeclaringClass().getName());
        stringBuffer.append(string);
        stringBuffer.append('.');
        stringBuffer.append(JDKAdaptor.computeMethodName(method));
        stringBuffer.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(classArray[n].getName());
            if (n < classArray.length - 1) {
                stringBuffer.append(',');
            }
            ++n;
        }
        if (method.getDeclaringClass().getName().equals(method.getName())) {
            stringBuffer.append("_V");
        }
        return stringBuffer.toString();
    }

    public static String computeMethodName(Constructor constructor) {
        return JDKAdaptor.getSimpleName(constructor.getName());
    }

    public static String computeMethodName(java.lang.reflect.Method method) {
        return method.getName();
    }

    public Field createJavaField(java.lang.reflect.Field field, XMIResource xMIResource) {
        Field field2 = JavaReflectionAdaptor.getJavaFactory().createField();
        field2.setName(field.getName());
        String string = JDKAdaptor.getSimpleName(field.getDeclaringClass().getName());
        xMIResource.setID((EObject)field2, string + '.' + field.getName());
        return field2;
    }

    public Method createJavaMethod(Constructor constructor, XMIResource xMIResource) {
        Method method = JavaReflectionAdaptor.getJavaFactory().createMethod();
        method.setName(JDKAdaptor.computeMethodName(constructor));
        xMIResource.setID((EObject)method, JDKAdaptor.computeMethodID(constructor));
        return method;
    }

    public Method createJavaMethod(java.lang.reflect.Method method, XMIResource xMIResource) {
        Method method2 = JavaReflectionAdaptor.getJavaFactory().createMethod();
        method2.setName(JDKAdaptor.computeMethodName(method));
        xMIResource.setID((EObject)method2, JDKAdaptor.computeMethodID(method));
        return method2;
    }

    public JavaJDKAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public ClassLoader getAlternateClassLoader() {
        return this.getAdapterFactory().getContextClassLoader();
    }

    public static Class getPrimitiveType(String string) {
        Class<Object> clazz = null;
        if (string.equals(Byte.TYPE.getName())) {
            clazz = Byte.TYPE;
        } else if (string.equals(Short.TYPE.getName())) {
            clazz = Short.TYPE;
        } else if (string.equals(Integer.TYPE.getName())) {
            clazz = Integer.TYPE;
        } else if (string.equals(Long.TYPE.getName())) {
            clazz = Long.TYPE;
        } else if (string.equals(Float.TYPE.getName())) {
            clazz = Float.TYPE;
        } else if (string.equals(Double.TYPE.getName())) {
            clazz = Double.TYPE;
        } else if (string.equals(Boolean.TYPE.getName())) {
            clazz = Boolean.TYPE;
        } else if (string.equals(Character.TYPE.getName())) {
            clazz = Character.TYPE;
        } else if (string.equals(Void.TYPE.getName())) {
            clazz = Void.TYPE;
        }
        return clazz;
    }

    public static String getSimpleName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public Class getType(JavaHelpers javaHelpers) {
        Class<Object> clazz = null;
        if (javaHelpers.isArray()) {
            ArrayType arrayType = (ArrayType)javaHelpers;
            Class clazz2 = this.getType(arrayType.getFinalComponentType());
            clazz = Array.newInstance(clazz2, new int[arrayType.getArrayDimensions()]).getClass();
        } else {
            clazz = javaHelpers.isPrimitive() ? this.getType(javaHelpers.getQualifiedName()) : this.getType(((JavaClass)javaHelpers).getQualifiedNameForReflection());
        }
        return clazz;
    }

    public Class getType(String string) {
        Class clazz;
        block6: {
            clazz = JDKAdaptor.getPrimitiveType(string);
            if (clazz != null) break block6;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                try {
                    clazz = this.loadFromAlternateClassLoader(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = null;
                }
            }
        }
        return clazz;
    }

    static String getTypeName(Class clazz) {
        if (clazz.isArray()) {
            try {
                Class<?> clazz2 = clazz;
                int n = 0;
                while (clazz2.isArray()) {
                    ++n;
                    clazz2 = clazz2.getComponentType();
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(clazz2.getName());
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.append("[]");
                    ++n2;
                }
                return stringBuffer.toString();
            }
            catch (Throwable throwable) {
            }
        }
        return clazz.getName();
    }

    protected Class loadFromAlternateClassLoader(String string) throws ClassNotFoundException {
        if (this.getAlternateClassLoader() != null) {
            if (this.getAlternateClassLoader().getParent() == ClassLoader.getSystemClassLoader()) {
                return this.getAlternateClassLoader().loadClass(string);
            }
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return this.getAlternateClassLoader().loadClass(string);
            }
        }
        return Class.forName(string);
    }

    public static Class primitiveForName(String string) {
        Class<Object> clazz = null;
        if (string.equals(Byte.TYPE.getName())) {
            clazz = Byte.TYPE;
        } else if (string.equals(Short.TYPE.getName())) {
            clazz = Short.TYPE;
        } else if (string.equals(Integer.TYPE.getName())) {
            clazz = Integer.TYPE;
        } else if (string.equals(Long.TYPE.getName())) {
            clazz = Long.TYPE;
        } else if (string.equals(Float.TYPE.getName())) {
            clazz = Float.TYPE;
        } else if (string.equals(Double.TYPE.getName())) {
            clazz = Double.TYPE;
        } else if (string.equals(Boolean.TYPE.getName())) {
            clazz = Boolean.TYPE;
        } else if (string.equals(Character.TYPE.getName())) {
            clazz = Character.TYPE;
        } else if (string.equals(Void.TYPE.getName())) {
            clazz = Void.TYPE;
        }
        return clazz;
    }

    public void setAdapterFactory(JavaJDKAdapterFactory javaJDKAdapterFactory) {
        this.adapterFactory = javaJDKAdapterFactory;
    }
}

