/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.java.adapters.jdk;

import com.ibm.etools.java.InheritanceCycleException;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.TypeKind;
import com.ibm.etools.java.adapters.IJavaClassAdaptor;
import com.ibm.etools.java.adapters.jdk.JDKAdaptor;
import com.ibm.etools.java.adapters.jdk.JavaJDKAdapterFactory;
import com.ibm.etools.java.adapters.nls.ResourceHandler;
import com.ibm.etools.java.impl.JavaClassImpl;
import com.ibm.etools.logger.proxy.Logger;
import com.ibm.etools.wft.util.Revisit;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class JavaClassJDKAdaptor
extends JDKAdaptor
implements IJavaClassAdaptor {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected Class sourceType = null;

    public JavaClassJDKAdaptor(Notifier notifier, JavaJDKAdapterFactory javaJDKAdapterFactory) {
        super(notifier, javaJDKAdapterFactory);
    }

    protected void addFields() {
        XMIResource xMIResource = (XMIResource)this.getJavaClassTarget().eResource();
        EList eList = this.getJavaClassTarget().getFieldsGen();
        eList.clear();
        Field[] fieldArray = new Field[]{};
        try {
            fieldArray = this.getSourceType().getDeclaredFields();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Revisit.revisit();
            System.out.println(ResourceHandler.getString("Could_Not_Reflect_Fields_ERROR_", new Object[]{this.getJavaClassTarget().getQualifiedName(), noClassDefFoundError.getMessage()}));
        }
        int n = 0;
        while (n < fieldArray.length) {
            eList.add(this.createJavaField(fieldArray[n], xMIResource));
            ++n;
        }
    }

    protected void addMethods() {
        XMIResource xMIResource = (XMIResource)this.getJavaClassTarget().eResource();
        EList eList = this.getJavaClassTarget().getMethodsGen();
        eList.clear();
        Method[] methodArray = new Method[]{};
        try {
            methodArray = this.getSourceType().getDeclaredMethods();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Revisit.revisit();
            System.out.println(ResourceHandler.getString("Could_Not_Reflect_Methods_ERROR_", new Object[]{this.getJavaClassTarget().getQualifiedName(), noClassDefFoundError.toString()}));
        }
        int n = 0;
        while (n < methodArray.length) {
            eList.add(this.createJavaMethod(methodArray[n], xMIResource));
            ++n;
        }
        Constructor[] constructorArray = new Constructor[]{};
        try {
            constructorArray = this.getSourceType().getDeclaredConstructors();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Revisit.revisit();
            System.out.println(ResourceHandler.getString("Could_Not_Reflect_Constructors_ERROR_", new Object[]{this.getJavaClassTarget().getQualifiedName(), noClassDefFoundError.getMessage()}));
        }
        int n2 = 0;
        while (n2 < constructorArray.length) {
            eList.add(this.createJavaMethod(constructorArray[n2], xMIResource));
            ++n2;
        }
    }

    protected boolean flushFields() {
        this.getJavaClassTarget().getFieldsGen().clear();
        return true;
    }

    protected boolean flushImplements() {
        this.getJavaClassTarget().getImplementsInterfacesGen().clear();
        return true;
    }

    protected boolean flushMethods() {
        this.getJavaClassTarget().getMethodsGen().clear();
        return true;
    }

    protected boolean flushInnerClasses() {
        this.getJavaClassTarget().getDeclaredClassesGen().clear();
        return true;
    }

    protected boolean flushModifiers() {
        JavaClass javaClass = (JavaClass)this.getTarget();
        javaClass.setAbstract(false);
        javaClass.setFinal(false);
        javaClass.setPublic(false);
        javaClass.setKind(TypeKind.UNDEFINED_LITERAL);
        return true;
    }

    protected boolean flushReflectedValues(boolean bl) {
        boolean bl2 = this.flushModifiers();
        bl2 &= this.flushSuper();
        bl2 &= this.flushImplements();
        bl2 &= this.flushMethods();
        bl2 &= this.flushFields();
        return bl2 &= this.flushInnerClasses();
    }

    protected void postFlushReflectedValuesIfNecessary(boolean bl) {
        this.getJavaClassTarget().setReflected(false);
        super.postFlushReflectedValuesIfNecessary(bl);
    }

    protected boolean flushSuper() {
        EList eList = this.getJavaClassTarget().getESuperTypesGen();
        eList.clear();
        return true;
    }

    protected JavaClassImpl getJavaClassTarget() {
        return (JavaClassImpl)this.getTarget();
    }

    public Object getReflectionSource() {
        return this.getSourceType();
    }

    protected Class getSourceType() {
        if (this.sourceType == null) {
            this.sourceType = this.getType((JavaClass)this.getTarget());
        }
        return this.sourceType;
    }

    public Object getValueIn(EObject eObject, EObject eObject2) {
        return super.getValueIn(eObject, eObject2);
    }

    public boolean isSourceTypeFromBinary() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reflectValues() {
        block5: {
            super.reflectValues();
            try {
                if (this.getSourceType() == null) break block5;
                this.setModifiers();
                this.setNaming();
                try {
                    this.setSuper();
                }
                catch (InheritanceCycleException inheritanceCycleException) {
                    Logger.getLogger().logError((Throwable)inheritanceCycleException);
                }
                this.setImplements();
                this.addMethods();
                this.addFields();
                this.reflectInnerClasses();
                this.getAdapterFactory().registerReflection(this.getSourceType().getName(), this);
                boolean bl = true;
                Object var3_4 = null;
                this.sourceType = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                this.sourceType = null;
                throw throwable;
            }
        }
        boolean bl = false;
        Object var3_5 = null;
        this.sourceType = null;
        return bl;
    }

    protected void reflectInnerClasses() {
        Class<?>[] classArray = this.getSourceType().getClasses();
        if (classArray.length != 0) {
            EList eList = this.getJavaClassTarget().getDeclaredClassesGen();
            ResourceSet resourceSet = this.getTargetResource().getResourceSet();
            int n = 0;
            while (n < classArray.length) {
                JavaClass javaClass = (JavaClass)JavaClassImpl.reflect(classArray[n].getName(), resourceSet);
                eList.add(javaClass);
                ++n;
            }
        }
    }

    protected void setImplements() {
        Class<?>[] classArray = this.getSourceType().getInterfaces();
        JavaClassImpl javaClassImpl = (JavaClassImpl)this.getTarget();
        EList eList = javaClassImpl.getImplementsInterfacesGen();
        eList.clear();
        int n = 0;
        while (n < classArray.length) {
            JavaClass javaClass = this.createJavaClassRef(classArray[n].getName());
            eList.add(javaClass);
            ++n;
        }
    }

    protected void setModifiers() {
        JavaClass javaClass = (JavaClass)this.getTarget();
        javaClass.setAbstract(Modifier.isAbstract(this.getSourceType().getModifiers()));
        javaClass.setFinal(Modifier.isFinal(this.getSourceType().getModifiers()));
        javaClass.setPublic(Modifier.isPublic(this.getSourceType().getModifiers()));
        if (this.getSourceType().isInterface()) {
            javaClass.setKind(TypeKind.INTERFACE_LITERAL);
        } else {
            javaClass.setKind(TypeKind.CLASS_LITERAL);
        }
    }

    protected void setNaming() {
    }

    protected void setSuper() throws InheritanceCycleException {
        Class clazz = null;
        clazz = this.getSourceType().getSuperclass();
        if (clazz != null) {
            JavaClass javaClass = (JavaClass)this.getTarget();
            javaClass.setSupertype(this.createJavaClassRef(clazz.getName()));
        }
    }

    public boolean sourceTypeExists() {
        return this.getSourceType() != null;
    }
}

