/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.encoders;

import com.ibm.etools.wft.nls.ResourceHandler;
import com.ibm.etools.wft.util.Revisit;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class WriteBackHelper {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private Set dirtyObjects = new HashSet();
    private boolean trackingChanges = false;
    private static WriteBackHelper _instance;

    private WriteBackHelper() {
    }

    public void addDirtyObject(EObject eObject) {
        this.dirtyObjects.add(eObject);
    }

    public void begin() {
        this.trackingChanges = true;
    }

    public void end() {
        this.saveDirtyResources();
        this.reset();
        this.trackingChanges = false;
    }

    public boolean isActive() {
        return this.trackingChanges;
    }

    protected void reset() {
        this.dirtyObjects.clear();
    }

    protected void saveDirtyResources() {
        EObject eObject;
        HashSet<Resource> hashSet = new HashSet<Resource>();
        Iterator iterator = this.dirtyObjects.iterator();
        while (iterator.hasNext()) {
            eObject = (EObject)iterator.next();
            if (eObject.eResource() == null || hashSet.contains(eObject)) continue;
            hashSet.add(eObject.eResource());
        }
        eObject = hashSet.iterator();
        while (eObject.hasNext()) {
            Resource resource = (Resource)eObject.next();
            try {
                resource.save(Collections.EMPTY_MAP);
            }
            catch (Exception exception) {
                this.warn(resource, exception);
            }
        }
    }

    public static WriteBackHelper singleton() {
        if (_instance == null) {
            _instance = new WriteBackHelper();
        }
        return _instance;
    }

    protected void warn(Resource resource, Exception exception) {
        System.err.println(ResourceHandler.getString("Warning__Could_not_write_b_WARN_", new Object[]{resource.getURI()}));
    }

    static {
        Revisit.deleteMe();
    }
}

