/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.encoders;

import com.ibm.etools.encoders.EncoderDecoder;
import com.ibm.etools.encoders.EncoderDecoderAdapter;

public class XMLValueEncoderDecoder
extends EncoderDecoderAdapter
implements EncoderDecoder {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private int _lastPrintable = 126;
    protected static XMLValueEncoderDecoder _singleton;

    public String decode(String string) {
        return string;
    }

    public String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        String string2 = null;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            string2 = this.getEntityRef(c);
            if (string2 != null) {
                stringBuffer.append('&');
                stringBuffer.append(string2);
                stringBuffer.append(';');
            } else if (c >= ' ' && c <= this._lastPrintable && c != '\u00f7' || c == '\n' || c == '\r' || c == '\t') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append("&#");
                stringBuffer.append(Integer.toString(c));
                stringBuffer.append(';');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String escape(String string) {
        if (_singleton == null) {
            _singleton = new XMLValueEncoderDecoder();
        }
        return _singleton.encode(string);
    }

    protected String getEntityRef(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }
}

