/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logger.proxy;

import com.ibm.etools.logger.proxy.ILogRenderer;
import com.ibm.etools.logger.proxy.JDKConsoleRenderer;
import com.ibm.etools.wft.util.WorkbenchUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Logger {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private boolean fTraceMode = false;
    private String fPluginID;
    private ILogRenderer fRenderer = null;
    private String fClassName = this.getClass().getName();
    private String fLineSeperator;
    private static final String DefaultUIRenderer = "com.ibm.etools.logger.proxyrenderer.DefaultUILogRenderer";
    private static final String DefaultLoggerPlugin = "com.ibm.etools.j2ee";
    private static Hashtable Loggers = new Hashtable();
    protected static final String[] LogMark = new String[]{"*** ERROR *** ", "[Trace] ", "+++ Warning +++ ", "Info: "};
    protected static final String Filler = "    ";
    static /* synthetic */ Class class$com$ibm$etools$logger$proxy$Logger;

    protected Logger() {
        this.fPluginID = DefaultLoggerPlugin;
    }

    protected Logger(String string) {
        this.fPluginID = string;
    }

    public String exceptionToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private String getCallerString() {
        Throwable throwable = new Throwable();
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        String string = stringWriter.toString();
        String string2 = "";
        int n = 4;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.indexOf(this.fClassName) > 0 && --n == 0) break;
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    public static Logger getLogger() {
        Logger logger = (Logger)Loggers.get(DefaultLoggerPlugin);
        if (logger == null) {
            logger = new Logger();
            logger.init();
            Loggers.put(DefaultLoggerPlugin, logger);
        }
        return logger;
    }

    public static Logger getLogger(String string) {
        if (string == null) {
            return Logger.getLogger();
        }
        Logger logger = (Logger)Loggers.get(string);
        if (logger == null) {
            logger = new Logger(string);
            logger.init();
            Loggers.put(string, logger);
        }
        return logger;
    }

    public String getPluginID() {
        return this.fPluginID;
    }

    public boolean getTraceMode() {
        return this.fTraceMode;
    }

    private void indentMsg(String string, StringBuffer stringBuffer) {
        String string2 = this.fLineSeperator;
        if (string.indexOf("\r\n") != -1) {
            string2 = "\r\n";
        } else if (string.indexOf("\n") != -1) {
            string2 = "\n";
        } else if (string.indexOf("\r") != -1) {
            string2 = "\r";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(Filler + stringTokenizer.nextToken() + this.fLineSeperator);
        }
    }

    private void init() {
        if (System.getProperty("debug") != null) {
            this.fTraceMode = true;
        }
        try {
            this.fLineSeperator = System.getProperty("line.separator");
        }
        catch (Throwable throwable) {
            this.fLineSeperator = "\n";
        }
    }

    private String logAny(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.fLineSeperator);
        stringBuffer.append(LogMark[n]);
        return this.punchLog(this.logRest(string, stringBuffer), n);
    }

    public String logError(String string) {
        return this.logAny(string, 0);
    }

    public String logError(Throwable throwable) {
        String string = this.exceptionToString(throwable);
        return this.logAny(string, 0);
    }

    public String logInfo(String string) {
        return this.logAny(string, 3);
    }

    public String logInfo(Throwable throwable) {
        String string = this.exceptionToString(throwable);
        return this.logAny(string, 3);
    }

    protected String logRest(String string, StringBuffer stringBuffer) {
        stringBuffer.append(new Date());
        stringBuffer.append("    caller: ");
        stringBuffer.append(this.getCallerString() + this.fLineSeperator);
        this.indentMsg(string, stringBuffer);
        return stringBuffer.toString();
    }

    public String logTrace(String string) {
        if (this.fTraceMode) {
            return this.logAny(string, 1);
        }
        return "";
    }

    public String logTrace(Throwable throwable) {
        String string = this.exceptionToString(throwable);
        return this.logAny(string, 1);
    }

    public String logWarning(String string) {
        return this.logAny(string, 2);
    }

    public String logWarning(Throwable throwable) {
        String string = this.exceptionToString(throwable);
        return this.logAny(string, 2);
    }

    protected synchronized String punchLog(String string, int n) {
        if (this.fRenderer == null) {
            if (WorkbenchUtil.workbenchIsRunning()) {
                try {
                    Class<?> clazz = Class.forName(DefaultUIRenderer);
                    Class[] classArray = new Class[]{class$com$ibm$etools$logger$proxy$Logger == null ? (class$com$ibm$etools$logger$proxy$Logger = Logger.class$("com.ibm.etools.logger.proxy.Logger")) : class$com$ibm$etools$logger$proxy$Logger};
                    Constructor<?> constructor = clazz.getConstructor(classArray);
                    this.fRenderer = (ILogRenderer)constructor.newInstance(this);
                }
                catch (Exception exception) {
                    this.fRenderer = new JDKConsoleRenderer(this);
                }
            } else {
                this.fRenderer = new JDKConsoleRenderer(this);
            }
        }
        return this.fRenderer.log(string, n);
    }

    public void setRenderer(ILogRenderer iLogRenderer) {
        this.fRenderer = iLogRenderer;
    }

    public void setTraceMode(boolean bl) {
        this.fTraceMode = bl;
        if (this.fRenderer != null) {
            this.fRenderer.setTraceMode(bl);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

