/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.wft.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class WFTResourceDependencyRegister {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected HashMap dependencies = new HashMap();
    protected static WFTResourceDependencyRegister singleton;

    public void addDependency(String string, String string2) {
        if (string != null && string2 != null) {
            ArrayList<String> arrayList = (ArrayList<String>)this.dependencies.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                this.dependencies.put(string, arrayList);
            }
            arrayList.add(string2);
        }
    }

    public List getDependencies(String string) {
        List list;
        if (string != null && (list = this.primGetDependencies(string)) != null) {
            return list;
        }
        return Collections.unmodifiableList(new ArrayList());
    }

    protected String getKeyEndingWith(String string) {
        Iterator iterator = this.dependencies.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.endsWith(string2)) continue;
            return string2;
        }
        return null;
    }

    public List getRelativeDependencies(String string) {
        List list = this.primGetDependencies(string);
        if (list != null) {
            return list;
        }
        String string2 = this.getKeyEndingWith(string);
        if (string2 == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        list = this.getDependencies(string2);
        return this.makeRelative(list, string, string2);
    }

    protected List makeRelative(List list, String string, String string2) {
        if (list.isEmpty() || string.equals(string2)) {
            return list;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        int n = string.length() - string2.length();
        String string3 = string.substring(0, n);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            arrayList.add(string3 + string4);
        }
        return arrayList;
    }

    protected List primGetDependencies(String string) {
        if (string != null) {
            return (List)this.dependencies.get(string);
        }
        return null;
    }

    public void removeAllDependencies(String string) {
        if (string != null) {
            this.dependencies.remove(string);
        }
    }

    public void removeDependency(String string, String string2) {
        List list;
        if (string != null && string2 != null && (list = (List)this.dependencies.get(string)) != null) {
            list.remove(string2);
        }
    }

    public static WFTResourceDependencyRegister singleton() {
        if (singleton == null) {
            singleton = new WFTResourceDependencyRegister();
        }
        return singleton;
    }
}

