/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.wft.util;

import com.ibm.etools.wft.nls.ResourceHandler;
import com.ibm.etools.wft.util.ExceptionHelper;
import com.ibm.etools.wft.util.IWFTWrappedException;
import java.io.PrintStream;
import java.io.PrintWriter;

public class WFTWrappedRuntimeException
extends RuntimeException
implements IWFTWrappedException {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected Exception nestedException;

    public WFTWrappedRuntimeException() {
    }

    public WFTWrappedRuntimeException(Exception exception) {
        this.setNestedException(exception);
    }

    public WFTWrappedRuntimeException(String string) {
        super(string);
    }

    public WFTWrappedRuntimeException(String string, Exception exception) {
        super(string);
        this.setNestedException(exception);
    }

    public String[] getAllMessages() {
        return ExceptionHelper.getAllMessages(this);
    }

    public String getConcatenatedMessages() {
        return ExceptionHelper.getConcatenatedMessages(this);
    }

    public Exception getInnerMostNestedException() {
        Exception exception = this.getNestedException();
        if (exception == null) {
            return this;
        }
        if (exception instanceof IWFTWrappedException) {
            return ((IWFTWrappedException)((Object)exception)).getInnerMostNestedException();
        }
        return exception;
    }

    public Exception getNestedException() {
        return this.nestedException;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        if (this.nestedException != null) {
            printStream.println(this);
            printStream.println(ResourceHandler.getString("Stack_trace_of_nested_exce_ERROR_"));
            this.nestedException.printStackTrace(printStream);
        } else {
            super.printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        if (this.nestedException != null) {
            printWriter.println(this);
            printWriter.println(ResourceHandler.getString("Stack_trace_of_nested_exce_ERROR_"));
            this.nestedException.printStackTrace(printWriter);
        } else {
            super.printStackTrace(printWriter);
        }
    }

    public void setNestedException(Exception exception) {
        this.nestedException = exception;
    }
}

