/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.search.internal.core.ISearchScope;
import org.eclipse.search.internal.core.text.TypedResourceVisitor;

public class AmountOfWorkCalculator
extends TypedResourceVisitor {
    private ISearchScope fScope;
    private int fResult;

    AmountOfWorkCalculator(MultiStatus status) {
        super(status);
    }

    protected boolean visitFile(IResourceProxy proxy) throws CoreException {
        if (this.fScope.encloses(proxy) && !proxy.isDerived()) {
            ++this.fResult;
        }
        return true;
    }

    public int process(Collection projects, ISearchScope scope) {
        this.fResult = 0;
        this.fScope = scope;
        Iterator i = projects.iterator();
        while (i.hasNext()) {
            IProject project = (IProject)i.next();
            int save = this.fResult;
            try {
                project.accept((IResourceProxyVisitor)this, 0);
            }
            catch (CoreException ex) {
                this.addToStatus(ex);
            }
            if (save != this.fResult) continue;
            i.remove();
        }
        return this.fResult;
    }
}

