/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.util.Assert;
import org.eclipse.search.internal.core.ISearchScope;
import org.eclipse.search.internal.core.text.AmountOfWorkCalculator;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.TextSearchVisitor;
import org.eclipse.search.internal.ui.SearchMessages;

public class TextSearchEngine {
    public IStatus search(IWorkspace workspace, String pattern, String options, ISearchScope scope, ITextSearchResultCollector collector) {
        MultiStatus status;
        block11: {
            Assert.isNotNull((Object)workspace);
            Assert.isNotNull((Object)pattern);
            Assert.isNotNull((Object)scope);
            Assert.isNotNull((Object)collector);
            IProgressMonitor monitor = collector.getProgressMonitor();
            IProject[] projects = workspace.getRoot().getProjects();
            ArrayList<IProject> openProjects = new ArrayList<IProject>(10);
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                if (project.isOpen()) {
                    openProjects.add(project);
                }
                ++i;
            }
            String message = SearchMessages.getString("TextSearchEngine.statusMessage");
            status = new MultiStatus("org.eclipse.search", 0, message, null);
            if (openProjects.isEmpty()) break block11;
            int amountOfWork = new AmountOfWorkCalculator(status).process(openProjects, scope);
            try {
                try {
                    monitor.beginTask("", amountOfWork);
                    if (amountOfWork > 0) {
                        Object[] args = new Integer[]{new Integer(1), new Integer(amountOfWork)};
                        monitor.setTaskName(SearchMessages.getFormattedString("TextSearchEngine.scanning", args));
                    }
                    collector.aboutToStart();
                    TextSearchVisitor visitor = new TextSearchVisitor(pattern, options, scope, collector, status, amountOfWork);
                    visitor.process(openProjects);
                }
                catch (CoreException ex) {
                    status.add(ex.getStatus());
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                monitor.done();
                try {
                    collector.done();
                }
                catch (CoreException ex) {
                    status.add(ex.getStatus());
                }
                throw throwable;
            }
            Object var13_17 = null;
            monitor.done();
            try {
                collector.done();
            }
            catch (CoreException ex) {
                status.add(ex.getStatus());
            }
        }
        return status;
    }
}

