/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

class RemovePotentialMatchesAction
extends Action {
    IWorkbenchSite fSite;

    public RemovePotentialMatchesAction(IWorkbenchSite site) {
        super(SearchMessages.getString("RemovePotentialMatchesAction.removePotentialMatches.text"));
        this.setToolTipText(SearchMessages.getString("RemovePotentialMatchesAction.removePotentialMatches.tooltip"));
        this.fSite = site;
    }

    public void run() {
        IMarker[] markers = this.getMarkers();
        if (markers != null) {
            try {
                SearchPlugin.getWorkspace().deleteMarkers(markers);
            }
            catch (CoreException ex) {
                ExceptionHandler.handle(ex, SearchMessages.getString("Search.Error.deleteMarkers.title"), SearchMessages.getString("Search.Error.deleteMarkers.message"));
            }
        } else {
            String title = SearchMessages.getString("RemovePotentialMatchesAction.dialog.title");
            String message = SearchMessages.getString("RemovePotentialMatchesAction.dialog.message");
            MessageDialog.openInformation((Shell)this.fSite.getShell(), (String)title, (String)message);
        }
        this.setEnabled(false);
    }

    private IMarker[] getMarkers() {
        IMarker[] markers;
        try {
            markers = SearchPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.search.searchmarker", true, 2);
        }
        catch (CoreException ex) {
            ExceptionHandler.handle(ex, SearchMessages.getString("Search.Error.findMarkers.title"), SearchMessages.getString("Search.Error.findMarkers.message"));
            return null;
        }
        ArrayList<IMarker> potentialMatches = new ArrayList<IMarker>(markers.length);
        int i = 0;
        while (i < markers.length) {
            if (markers[i].getAttribute("potentialMatch", false)) {
                potentialMatches.add(markers[i]);
            }
            ++i;
        }
        if (potentialMatches.size() == 0) {
            return null;
        }
        return potentialMatches.toArray(new IMarker[potentialMatches.size()]);
    }
}

