/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.internal.ui.OpenSearchDialogAction;
import org.eclipse.search.internal.ui.ScopePart;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPageDescriptor;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.internal.ui.util.ExtendedDialogWindow;
import org.eclipse.search.internal.ui.util.ListContentProvider;
import org.eclipse.search.internal.ui.util.SWTUtil;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

class SearchDialog
extends ExtendedDialogWindow
implements ISearchPageContainer {
    private IWorkspace fWorkspace;
    private ISearchPage fCurrentPage;
    private String fInitialPageId;
    private int fCurrentIndex;
    private ISelection fSelection;
    private IEditorPart fEditorPart;
    private List fDescriptors;
    private Point fMinSize;
    private ScopePart[] fScopeParts;
    private boolean fPageStateIgnoringScopePart;
    Button fCustomizeButton;

    public SearchDialog(Shell shell, IWorkspace workspace, ISelection selection, IEditorPart editor, String pageId) {
        super(shell);
        Assert.isNotNull((Object)workspace);
        this.fWorkspace = workspace;
        this.setPerformActionLabel(SearchMessages.getString("SearchDialog.performAction"));
        this.fSelection = selection;
        this.fEditorPart = editor;
        this.fDescriptors = SearchPlugin.getDefault().getEnabledSearchPageDescriptors(pageId);
        this.fInitialPageId = pageId;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(SearchMessages.getString("SearchDialog.title"));
        shell.setImage(SearchPluginImages.get("org.eclipse.search.ui.search.gif"));
        WorkbenchHelp.setHelp((Control)shell, (String)"org.eclipse.search.search_dialog_context");
    }

    public IWorkspace getWorkspace() {
        return this.fWorkspace;
    }

    public ISelection getSelection() {
        return this.fSelection;
    }

    public IEditorPart getEditorPart() {
        return this.fEditorPart;
    }

    public void create() {
        super.create();
        if (this.fCurrentPage != null) {
            this.fCurrentPage.setVisible(true);
        }
    }

    private void handleCustomizePressed() {
        List input = SearchPlugin.getDefault().getSearchPageDescriptors();
        final ArrayList createdImages = new ArrayList(input.size());
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof SearchPageDescriptor) {
                    String label = ((SearchPageDescriptor)element).getLabel();
                    int i = label.indexOf(38);
                    while (i >= 0) {
                        if (i < label.length()) {
                            label = String.valueOf(label.substring(0, i)) + label.substring(i + 1);
                        } else {
                            label.substring(0, i);
                        }
                        i = label.indexOf(38);
                    }
                    return label;
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof SearchPageDescriptor) {
                    ImageDescriptor imageDesc = ((SearchPageDescriptor)element).getImage();
                    if (imageDesc == null) {
                        return null;
                    }
                    Image image = imageDesc.createImage();
                    if (image != null) {
                        createdImages.add(image);
                    }
                    return image;
                }
                return null;
            }
        };
        String message = SearchMessages.getString("SearchPageSelectionDialog.message");
        ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), input, new ListContentProvider(), (ILabelProvider)labelProvider, message){

            public void create() {
                super.create();
                CheckboxTableViewer viewer = this.getViewer();
                Button okButton = this.getOkButton();
                viewer.addCheckStateListener(new ICheckStateListener(this, okButton, viewer){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ Button val$okButton;
                    private final /* synthetic */ CheckboxTableViewer val$viewer;
                    {
                        this.this$1 = var1_1;
                        this.val$okButton = button;
                        this.val$viewer = checkboxTableViewer;
                    }

                    public void checkStateChanged(CheckStateChangedEvent event) {
                        this.val$okButton.setEnabled(this.val$viewer.getCheckedElements().length > 0);
                    }
                });
                SelectionAdapter listener = new SelectionAdapter(this, okButton, viewer){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ Button val$okButton;
                    private final /* synthetic */ CheckboxTableViewer val$viewer;
                    {
                        this.this$1 = var1_1;
                        this.val$okButton = button;
                        this.val$viewer = checkboxTableViewer;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.val$okButton.setEnabled(this.val$viewer.getCheckedElements().length > 0);
                    }
                };
                this.getButton(18).addSelectionListener((SelectionListener)listener);
                this.getButton(19).addSelectionListener((SelectionListener)listener);
            }
        };
        dialog.setTitle(SearchMessages.getString("SearchPageSelectionDialog.title"));
        dialog.setInitialSelections(SearchPlugin.getDefault().getEnabledSearchPageDescriptors(this.fInitialPageId).toArray());
        if (dialog.open() == 0) {
            SearchPageDescriptor.setEnabled(dialog.getResult());
            Display display = this.getShell().getDisplay();
            this.close();
            if (display != null && !display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        new OpenSearchDialogAction().run();
                    }
                });
            }
        }
        this.destroyImages(createdImages);
    }

    private void destroyImages(List images) {
        Iterator iter = images.iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            if (image == null || image.isDisposed()) continue;
            image.dispose();
        }
    }

    protected Control createPageArea(Composite parent) {
        int numPages = this.fDescriptors.size();
        this.fScopeParts = new ScopePart[numPages];
        if (numPages == 0) {
            Label label = new Label(parent, 0x1000040);
            label.setText(SearchMessages.getString("SearchDialog.noSearchExtension"));
            return label;
        }
        this.fCurrentIndex = this.getPreferredPageIndex();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                SearchDialog.this.fCurrentPage = SearchDialog.this.getDescriptorAt(SearchDialog.this.fCurrentIndex).createObject();
            }
        });
        this.fCurrentPage.setContainer(this);
        if (numPages == 1) {
            return this.getControl(this.fCurrentPage, parent, 0);
        }
        Composite border = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 7;
        border.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(border, 0);
        folder.setLayoutData((Object)new GridData(1808));
        folder.setLayout((Layout)new TabFolderLayout());
        int i = 0;
        while (i < numPages) {
            SearchPageDescriptor descriptor = (SearchPageDescriptor)this.fDescriptors.get(i);
            final TabItem item = new TabItem(folder, 0);
            item.setText(descriptor.getLabel());
            item.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    item.setData(null);
                    if (item.getImage() != null) {
                        item.getImage().dispose();
                    }
                }
            });
            ImageDescriptor imageDesc = descriptor.getImage();
            if (imageDesc != null) {
                item.setImage(imageDesc.createImage());
            }
            item.setData((Object)descriptor);
            if (i == this.fCurrentIndex) {
                item.setControl(this.getControl(this.fCurrentPage, (Composite)folder, i));
                item.setData((Object)this.fCurrentPage);
            }
            ++i;
        }
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SearchDialog.this.turnToPage(event);
            }
        });
        folder.setSelection(this.fCurrentIndex);
        return border;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.fCustomizeButton = new Button(composite, 0);
        this.fCustomizeButton.setText(SearchMessages.getString("SearchDialog.customize"));
        GridData gd = new GridData();
        gd.horizontalIndent = 2 * new GridLayout().marginWidth;
        this.fCustomizeButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.fCustomizeButton);
        this.fCustomizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDialog.this.handleCustomizePressed();
            }
        });
        Label filler = new Label(composite, 0);
        filler.setLayoutData((Object)new GridData(768));
        Control result = super.createButtonBar(composite);
        this.getButton(16).setEnabled(this.fDescriptors.size() > 0);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean performAction() {
        boolean bl;
        if (this.fCurrentPage == null) {
            return true;
        }
        boolean isAutoBuilding = SearchPlugin.getWorkspace().isAutoBuilding();
        if (isAutoBuilding) {
            SearchPlugin.setAutoBuilding(false);
        }
        try {
            this.fCustomizeButton.setEnabled(false);
            bl = this.fCurrentPage.performAction();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.fCustomizeButton.setEnabled(true);
            if (!isAutoBuilding) throw throwable;
            SearchPlugin.setAutoBuilding(true);
            throw throwable;
        }
        this.fCustomizeButton.setEnabled(true);
        if (!isAutoBuilding) return bl;
        SearchPlugin.setAutoBuilding(true);
        return bl;
    }

    private SearchPageDescriptor getDescriptorAt(int index) {
        return (SearchPageDescriptor)this.fDescriptors.get(index);
    }

    private Point getMinSize() {
        if (this.fMinSize != null) {
            return this.fMinSize;
        }
        int x = 0;
        int y = 0;
        int length = this.fDescriptors.size();
        int i = 0;
        while (i < length) {
            Point size = this.getDescriptorAt(i).getPreferredSize();
            if (size.x != -1) {
                x = Math.max(x, size.x);
            }
            if (size.y != -1) {
                y = Math.max(y, size.y);
            }
            ++i;
        }
        this.fMinSize = new Point(x, y);
        return this.fMinSize;
    }

    private void turnToPage(SelectionEvent event) {
        final TabItem item = (TabItem)event.item;
        if (item.getControl() == null) {
            final SearchPageDescriptor descriptor = (SearchPageDescriptor)item.getData();
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    item.setData((Object)descriptor.createObject());
                }
            });
            ISearchPage page = (ISearchPage)item.getData();
            page.setContainer(this);
            Control newControl = this.getControl(page, (Composite)event.widget, item.getParent().getSelectionIndex());
            item.setControl(newControl);
        }
        if (item.getData() instanceof ISearchPage) {
            this.fCurrentPage = (ISearchPage)item.getData();
            this.fCurrentIndex = item.getParent().getSelectionIndex();
            this.resizeDialogIfNeeded(item.getControl());
            this.fCurrentPage.setVisible(true);
        }
    }

    private int getPreferredPageIndex() {
        Object element = null;
        if (this.fSelection instanceof IStructuredSelection) {
            element = ((IStructuredSelection)this.fSelection).getFirstElement();
        }
        if (element == null && this.fEditorPart != null && (element = this.fEditorPart.getEditorInput()) instanceof IFileEditorInput) {
            element = ((IFileEditorInput)element).getFile();
        }
        int result = 0;
        int level = 0;
        int size = this.fDescriptors.size();
        int i = 0;
        while (i < size) {
            SearchPageDescriptor descriptor = (SearchPageDescriptor)this.fDescriptors.get(i);
            if (this.fInitialPageId != null && this.fInitialPageId.equals(descriptor.getId())) {
                return i;
            }
            int newLevel = descriptor.computeScore(element);
            if (newLevel > level) {
                level = newLevel;
                result = i;
            }
            ++i;
        }
        return result;
    }

    public IRunnableContext getRunnableContext() {
        return this;
    }

    public int getSelectedScope() {
        if (this.fScopeParts[this.fCurrentIndex] == null) {
            return 0;
        }
        return this.fScopeParts[this.fCurrentIndex].getSelectedScope();
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        if (this.fScopeParts[this.fCurrentIndex] == null) {
            return null;
        }
        return this.fScopeParts[this.fCurrentIndex].getSelectedWorkingSets();
    }

    public void setSelectedScope(int scope) {
        if (this.fScopeParts[this.fCurrentIndex] != null) {
            this.fScopeParts[this.fCurrentIndex].setSelectedScope(scope);
        }
    }

    public boolean hasValidScope() {
        return this.getSelectedScope() != 2 || this.getSelectedWorkingSets() != null;
    }

    public void setSelectedWorkingSets(IWorkingSet[] workingSets) {
        if (this.fScopeParts[this.fCurrentIndex] != null) {
            this.fScopeParts[this.fCurrentIndex].setSelectedWorkingSets(workingSets);
        }
    }

    public void setPerformActionEnabled(boolean state) {
        super.setPerformActionEnabled(state);
        this.fPageStateIgnoringScopePart = state;
        this.setPerformActionEnabledFromScopePart(this.hasValidScope());
    }

    public void setPerformActionEnabledFromScopePart(boolean state) {
        if (this.fPageStateIgnoringScopePart) {
            super.setPerformActionEnabled(state);
        }
    }

    private Control getControl(ISearchPage page, Composite parent, int index) {
        if (page.getControl() == null) {
            Composite pageWrapper = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            pageWrapper.setLayoutData((Object)new GridData(768));
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            pageWrapper.setLayout((Layout)layout);
            page.createControl(pageWrapper);
            boolean showScope = this.getDescriptorAt(index).showScopeSection();
            if (showScope) {
                Composite c = new Composite(pageWrapper, 0);
                layout = new GridLayout();
                c.setLayoutData((Object)new GridData(768));
                c.setLayout((Layout)layout);
                this.fScopeParts[index] = new ScopePart(this);
                Composite part = this.fScopeParts[index].createPart(c);
                Dialog.applyDialogFont((Control)part);
                this.fScopeParts[index].setVisible(true);
            }
        }
        return page.getControl().getParent();
    }

    private void resizeDialogIfNeeded(Control newControl) {
        Point newSize;
        Point currentSize = this.fCurrentPage.getControl().getSize();
        if (this.mustResize(currentSize, newSize = newControl.computeSize(-1, -1, true))) {
            Shell shell = this.getShell();
            shell.setSize(shell.computeSize(-1, -1, true));
        }
    }

    private boolean mustResize(Point currentSize, Point newSize) {
        return currentSize.x < newSize.x || currentSize.y < newSize.y;
    }

    private class TabFolderLayout
    extends Layout {
        TabFolderLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int x = 0;
            int y = 0;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Point size = children[i].computeSize(-1, -1, flushCache);
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
                ++i;
            }
            Point minSize = SearchDialog.this.getMinSize();
            x = Math.max(x, minSize.x);
            y = Math.max(y, minSize.y);
            if (wHint != -1) {
                x = wHint;
            }
            if (hHint != -1) {
                y = hHint;
            }
            return new Point(x, y);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle rect = composite.getClientArea();
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setBounds(rect);
                ++i;
            }
        }
    }
}

