/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.search.internal.ui.RemoveAllSearchesAction;
import org.eclipse.search.internal.ui.Search;
import org.eclipse.search.internal.ui.SearchManager;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.internal.ui.SearchResultViewer;
import org.eclipse.search.internal.ui.ShowSearchAction;
import org.eclipse.search.internal.ui.ShowSearchesAction;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

class SearchDropDownAction
extends Action
implements IMenuCreator {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private SearchResultViewer fViewer;
    private Menu fMenu;

    public SearchDropDownAction(SearchResultViewer viewer) {
        this.fViewer = viewer;
        this.setText(SearchMessages.getString("SearchResultView.previousSearches.text"));
        this.setToolTipText(SearchMessages.getString("SearchResultView.previousSearches.tooltip"));
        SearchPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.search.ui.search_history.gif");
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fViewer = null;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        boolean checkedOne = false;
        Iterator iter = SearchManager.getDefault().getPreviousSearches().iterator();
        Search selected = SearchManager.getDefault().getCurrentSearch();
        int i = 0;
        while (iter.hasNext() && i++ < 10) {
            Search search = (Search)iter.next();
            ShowSearchAction action = new ShowSearchAction(search);
            action.setChecked(search.equals(selected));
            if (search.equals(selected)) {
                checkedOne = true;
            }
            this.addActionToMenu(this.fMenu, action);
        }
        new MenuItem(this.fMenu, 2);
        if (iter.hasNext()) {
            ShowSearchesAction others = new ShowSearchesAction();
            others.setChecked(!checkedOne);
            this.addActionToMenu(this.fMenu, others);
        }
        this.addActionToMenu(this.fMenu, new RemoveAllSearchesAction());
        return this.fMenu;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void run() {
        new ShowSearchesAction().run(true);
    }
}

