/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.internal.ui.Search;
import org.eclipse.search.internal.ui.SearchManager;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchResultViewEntry;
import org.eclipse.search.internal.ui.text.ReplaceDialog;
import org.eclipse.search.internal.ui.text.TextSearchOperation;
import org.eclipse.search.internal.ui.util.ListDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

class ReplaceAction
extends Action {
    private IWorkbenchSite fSite;
    private List fElements;

    public ReplaceAction(IWorkbenchSite site, List elements) {
        Assert.isNotNull((Object)site);
        this.fSite = site;
        this.fElements = elements != null ? elements : new ArrayList(0);
        this.setText(SearchMessages.getString("ReplaceAction.label_all"));
        this.setEnabled(!this.fElements.isEmpty());
    }

    public ReplaceAction(IWorkbenchSite site, IStructuredSelection selection) {
        Assert.isNotNull((Object)site);
        this.fSite = site;
        this.setText(SearchMessages.getString("ReplaceAction.label_selected"));
        this.fElements = selection.toList();
        this.setEnabled(!this.fElements.isEmpty());
    }

    public void run() {
        if (this.validateResources()) {
            Search search = SearchManager.getDefault().getCurrentSearch();
            IRunnableWithProgress operation = search.getOperation();
            if (operation instanceof TextSearchOperation) {
                ReplaceDialog dialog = new ReplaceDialog(this.fSite.getShell(), this.fElements, this.fSite.getWorkbenchWindow(), ((TextSearchOperation)operation).getPattern());
                dialog.open();
            } else {
                MessageDialog.openError((Shell)this.fSite.getShell(), (String)this.getDialogTitle(), (String)SearchMessages.getString("ReplaceAction.error.only_on_text_search"));
            }
        }
    }

    private boolean validateResources() {
        ArrayList<Object> modifiedFiles = new ArrayList<Object>();
        ArrayList<IFile> openedFilesInNonTextEditor = new ArrayList<IFile>();
        ArrayList<IResource> notFiles = new ArrayList<IResource>();
        IWorkbenchPage activePage = this.fSite.getWorkbenchWindow().getActivePage();
        Iterator iter = this.fElements.iterator();
        while (iter.hasNext()) {
            SearchResultViewEntry entry = (SearchResultViewEntry)iter.next();
            IResource resource = entry.getResource();
            if (resource instanceof IFile) {
                IEditorPart part;
                IFile file = (IFile)resource;
                if (file.getModificationStamp() != entry.getModificationStamp() || !file.isSynchronized(0)) {
                    modifiedFiles.add(resource);
                    continue;
                }
                if (activePage == null || (part = activePage.findEditor((IEditorInput)new FileEditorInput(file))) == null || part instanceof ITextEditor) continue;
                openedFilesInNonTextEditor.add(file);
                continue;
            }
            if (resource == null) continue;
            notFiles.add(resource);
        }
        if (!modifiedFiles.isEmpty()) {
            this.showModifiedFileDialog(modifiedFiles);
            return false;
        }
        if (!openedFilesInNonTextEditor.isEmpty()) {
            this.showOpenedFileDialog(openedFilesInNonTextEditor);
            return false;
        }
        if (!notFiles.isEmpty()) {
            this.showNotFilesDialog(openedFilesInNonTextEditor);
            return false;
        }
        IFile[] readOnlyFiles = this.getReadOnlyFiles();
        if (readOnlyFiles.length == 0) {
            return true;
        }
        Map currentStamps = ReplaceAction.createModificationStampMap(readOnlyFiles);
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(readOnlyFiles, (Object)this.fSite.getShell());
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.fSite.getShell(), (String)this.getDialogTitle(), (String)SearchMessages.getString("ReplaceAction.error.unable_to_perform"), (IStatus)status);
            return false;
        }
        modifiedFiles = new ArrayList();
        Map newStamps = ReplaceAction.createModificationStampMap(readOnlyFiles);
        Iterator iter2 = currentStamps.keySet().iterator();
        while (iter2.hasNext()) {
            IFile file = (IFile)iter2.next();
            if (currentStamps.get(file).equals(newStamps.get(file))) continue;
            modifiedFiles.add(file);
        }
        if (!modifiedFiles.isEmpty()) {
            this.showModifiedFileDialog(modifiedFiles);
            return false;
        }
        return true;
    }

    private void showModifiedFileDialog(List modifiedFiles) {
        String message = modifiedFiles.size() == 1 ? SearchMessages.getString("ReplaceAction.error.changed_file") : SearchMessages.getString("ReplaceAction.error.changed_files");
        ListDialog dialog = new ListDialog(this.fSite.getShell(), modifiedFiles, this.getDialogTitle(), message, new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }, (ILabelProvider)new WorkbenchLabelProvider());
        dialog.setCreateCancelButton(false);
        dialog.open();
    }

    private IFile[] getReadOnlyFiles() {
        ArrayList<IResource> result = new ArrayList<IResource>();
        Iterator iter = this.fElements.iterator();
        while (iter.hasNext()) {
            IResource resource = ((SearchResultViewEntry)iter.next()).getResource();
            if (!(resource instanceof IFile) || !resource.isReadOnly()) continue;
            result.add(resource);
        }
        return result.toArray(new IFile[result.size()]);
    }

    private static Map createModificationStampMap(IFile[] files) {
        HashMap<IFile, Long> map = new HashMap<IFile, Long>();
        int i = 0;
        while (i < files.length) {
            IFile file = files[i];
            map.put(file, new Long(file.getModificationStamp()));
            ++i;
        }
        return map;
    }

    private String getDialogTitle() {
        return SearchMessages.getString("ReplaceAction.dialog.title");
    }

    private void showOpenedFileDialog(List openedFilesInNonTextEditor) {
        String message = openedFilesInNonTextEditor.size() == 1 ? SearchMessages.getString("ReplaceAction.error.opened_file") : SearchMessages.getString("ReplaceAction.error.opened_files");
        ListDialog dialog = new ListDialog(this.fSite.getShell(), openedFilesInNonTextEditor, this.getDialogTitle(), message, new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }, (ILabelProvider)new WorkbenchLabelProvider());
        dialog.setCreateCancelButton(false);
        dialog.open();
    }

    private void showNotFilesDialog(List notFiles) {
        String message = notFiles.size() == 1 ? SearchMessages.getString("ReplaceAction.error.not_file") : SearchMessages.getString("ReplaceAction.error.not_files");
        ListDialog dialog = new ListDialog(this.fSite.getShell(), notFiles, this.getDialogTitle(), message, new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }, (ILabelProvider)new WorkbenchLabelProvider());
        dialog.setCreateCancelButton(false);
        dialog.open();
    }
}

