/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.search.internal.core.ISearchScope;
import org.eclipse.search.internal.core.text.TextSearchEngine;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.internal.ui.text.TextSearchResultCollector;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class TextSearchOperation
extends WorkspaceModifyOperation {
    public static final int NO_PRIORITY_CHANGE = -1;
    private IWorkspace fWorkspace;
    private String fPattern;
    private String fOptions;
    private ISearchScope fScope;
    private TextSearchResultCollector fCollector;
    private IStatus fStatus;

    public TextSearchOperation(IWorkspace workspace, String pattern, String options, ISearchScope scope, TextSearchResultCollector collector) {
        Assert.isNotNull((Object)collector);
        this.fWorkspace = workspace;
        this.fPattern = pattern;
        this.fOptions = options;
        this.fScope = scope;
        this.fCollector = collector;
        this.fCollector.setOperation(this);
    }

    protected void execute(IProgressMonitor monitor) {
        this.fCollector.setProgressMonitor(monitor);
        TextSearchEngine engine = new TextSearchEngine();
        this.fStatus = engine.search(this.fWorkspace, this.fPattern, this.fOptions, this.fScope, this.fCollector);
    }

    String getSingularLabel() {
        if (this.fPattern == null || this.fPattern.length() < 1) {
            return SearchMessages.getFormattedString("FileSearchOperation.singularLabelPostfix", new String[]{this.fScope.getDescription()});
        }
        return SearchMessages.getFormattedString("TextSearchOperation.singularLabelPostfix", new String[]{this.fPattern, this.fScope.getDescription()});
    }

    String getPluralLabelPattern() {
        if (this.fPattern == null || this.fPattern.length() < 1) {
            return SearchMessages.getFormattedString("FileSearchOperation.pluralLabelPatternPostfix", new String[]{"{0}", this.fScope.getDescription()});
        }
        return SearchMessages.getFormattedString("TextSearchOperation.pluralLabelPatternPostfix", new String[]{this.fPattern, "{0}", this.fScope.getDescription()});
    }

    ImageDescriptor getImageDescriptor() {
        return SearchPluginImages.DESC_OBJ_TSEARCH_DPDN;
    }

    IStatus getStatus() {
        return this.fStatus;
    }

    String getPattern() {
        return this.fPattern;
    }
}

