/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.util;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SWTUtil {
    private static double fgHorizontalDialogUnitSize = 0.0;
    private static double fgVerticalDialogUnitSize = 0.0;

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static Shell getShell(Widget widget) {
        if (widget instanceof Control) {
            return ((Control)widget).getShell();
        }
        if (widget instanceof Caret) {
            return ((Caret)widget).getParent().getShell();
        }
        if (widget instanceof DragSource) {
            return ((DragSource)widget).getControl().getShell();
        }
        if (widget instanceof DropTarget) {
            return ((DropTarget)widget).getControl().getShell();
        }
        if (widget instanceof Menu) {
            return ((Menu)widget).getParent().getShell();
        }
        if (widget instanceof ScrollBar) {
            return ((ScrollBar)widget).getParent().getShell();
        }
        return null;
    }

    private static void initializeDialogUnits(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int averageWidth = gc.getFontMetrics().getAverageCharWidth();
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        fgHorizontalDialogUnitSize = (double)averageWidth * 0.25;
        fgVerticalDialogUnitSize = (double)height * 0.125;
    }

    private static int convertHorizontalDLUsToPixels(int dlus) {
        return (int)Math.round((double)dlus * fgHorizontalDialogUnitSize);
    }

    private static int convertVerticalDLUsToPixels(int dlus) {
        return (int)Math.round((double)dlus * fgVerticalDialogUnitSize);
    }

    public static int convertWidthInCharsToPixels(int chars, Text text) {
        if (fgHorizontalDialogUnitSize == 0.0) {
            SWTUtil.initializeDialogUnits((Control)text);
        }
        return SWTUtil.convertHorizontalDLUsToPixels(chars * 4);
    }

    public static int getButtonWidthHint(Button button) {
        if (button.getFont().equals((Object)JFaceResources.getDefaultFont())) {
            button.setFont(JFaceResources.getDialogFont());
        }
        if (fgHorizontalDialogUnitSize == 0.0) {
            SWTUtil.initializeDialogUnits((Control)button);
        }
        int widthHint = SWTUtil.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static int getButtonHeigthHint(Button button) {
        if (button.getFont().equals((Object)JFaceResources.getDefaultFont())) {
            button.setFont(JFaceResources.getDialogFont());
        }
        if (fgHorizontalDialogUnitSize == 0.0) {
            SWTUtil.initializeDialogUnits((Control)button);
        }
        return SWTUtil.convertVerticalDLUsToPixels(14);
    }

    public static void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).heightHint = SWTUtil.getButtonHeigthHint(button);
            ((GridData)gd).widthHint = SWTUtil.getButtonWidthHint(button);
        }
    }
}

