/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.ConnectionHandleManager;
import com.ibm.ejs.j2c.ConnectionManager;
import com.ibm.ejs.j2c.LocalTransactionWrapper;
import com.ibm.ejs.j2c.MCWrapper;
import com.ibm.ejs.j2c.poolmanager.PoolManager;
import com.ibm.ejs.j2c.poolmanager.SharedPool;
import com.ibm.ejs.j2c.poolmanager.UnSharedPool;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl;
import java.util.Set;
import java.util.Vector;
import javax.resource.spi.ConnectionRequestInfo;
import javax.security.auth.Subject;

public class DiagnosticModuleForJ2C
extends DiagnosticModule {
    TraceComponent tc = Tr.register((String)"ConnLeakLogic", (String)"WAS.j2c", (String)"com.ibm.ejs.resources.J2CAMessages");

    public void ffdcDumpDefaultJ2C(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        if (string.equals("com.ibm.ejs.j2c.ConnectionManager.allocateMCWrapper.dumpMaxConnectionsReached")) {
            this.ffdcDumpMaxConnectionsReached(throwable, incidentStream, object, objectArray, string);
        } else if (string.equals("com.ibm.ejs.j2c.LocalTransactionWrapper.enlist") && object instanceof LocalTransactionWrapper && objectArray != null && objectArray.length >= 1) {
            this.ffdcDumpIllegal1PCResourceMessage(throwable, incidentStream, object, objectArray, string);
        } else {
            incidentStream.writeLine("sourceId ", string);
            incidentStream.introspectAndWriteLine("This", object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ffdcDumpMaxConnectionsReached(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        incidentStream.write("Maximum number of connections has been reached, and the connection request has been waiting longer than", "");
        incidentStream.write("ConnectionWaitTime.  Two possible solutions  : increase the max number of connections, or increase the", "");
        incidentStream.writeLine("ConnectionWaitTime.", "");
        try {
            ConnectionManager connectionManager = (ConnectionManager)object;
            com.ibm.ws.j2c.poolmanager.PoolManager poolManager = connectionManager.getPoolManager();
            if (this.tc.isDebugEnabled()) {
                int n;
                long l = System.currentTimeMillis();
                SharedPool[] sharedPoolArray = ((PoolManager)poolManager).getSharedPool();
                Tr.debug((TraceComponent)this.tc, (String)"Dumping initial request stack traces");
                com.ibm.ws.j2c.MCWrapper[] mCWrapperArray = null;
                for (int i = 0; i < sharedPoolArray.length; ++i) {
                    if (sharedPoolArray[i] == null) continue;
                    mCWrapperArray = sharedPoolArray[i].getMCWrapperList();
                    for (n = 0; n < mCWrapperArray.length; ++n) {
                        Throwable throwable2;
                        if (mCWrapperArray[n] == null || (throwable2 = ((MCWrapper)mCWrapperArray[n]).getInitialRequestStackTrace()) == null) continue;
                        long l2 = ((MCWrapper)mCWrapperArray[n]).getCreatedTimeStamp();
                        Tr.debug((TraceComponent)this.tc, (String)(mCWrapperArray[n].toString() + " in-use for " + (l - l2) + "ms"), (Object)throwable2);
                    }
                }
                mCWrapperArray = null;
                UnSharedPool[] unSharedPoolArray = ((PoolManager)poolManager).getUnSharedPool();
                for (n = 0; n < unSharedPoolArray.length; ++n) {
                    if (unSharedPoolArray[n] == null) continue;
                    mCWrapperArray = unSharedPoolArray[n].getMCWrapperList();
                    for (int i = 0; i < mCWrapperArray.length; ++i) {
                        Throwable throwable3;
                        if (mCWrapperArray[i] == null || (throwable3 = ((MCWrapper)mCWrapperArray[i]).getInitialRequestStackTrace()) == null) continue;
                        long l3 = ((MCWrapper)mCWrapperArray[i]).getCreatedTimeStamp();
                        Tr.debug((TraceComponent)this.tc, (String)(mCWrapperArray[i].toString() + " in-use for " + (l - l3) + "ms"), (Object)throwable3);
                    }
                }
            }
            incidentStream.writeLine("   Maximum Connections           = ", poolManager.getMaxConnections());
            incidentStream.writeLine("   Current number of connections = ", poolManager.getConnectionCount());
            incidentStream.writeLine("   Connection Wait Timout        = ", poolManager.getConnectionTimeout());
            incidentStream.write("If the current number of connections is not greater than or equal to max connections, ", "");
            incidentStream.writeLine("there has been a WebSphere internal error.", "");
            incidentStream.writeLine("Dumping the list of J2EEComponents and their corresponding handle count", "");
            incidentStream.writeLine(ConnectionHandleManager.getConnectionHandleManager().dumpComponentListWithHandlesToString(), "");
        }
        catch (ClassCastException classCastException) {
            incidentStream.writeLine("Internal J2C FFDC Diagnostic Module error", "");
            incidentStream.writeLine("ClassCastException in ffdcDumpMaxConnectionsReached", "");
            incidentStream.writeLine("Object this was not of type ConnectionManager when ffdcDumpMaxConnectionsReached was called - introspecting the object: ", "");
        }
        catch (Exception exception) {
            incidentStream.writeLine("Internal J2C FFDC Diagnostic Module error", "");
            incidentStream.writeLine("Exception ", (Object)exception);
        }
        finally {
            incidentStream.introspectAndWriteLine("This = ", object);
        }
    }

    public void ffdcDumpIllegal1PCResourceMessage(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        MCWrapper mCWrapper;
        LocalTransactionWrapper localTransactionWrapper = (LocalTransactionWrapper)object;
        MCWrapper mCWrapper2 = mCWrapper = (MCWrapper)objectArray[0];
        UOWCoordinator uOWCoordinator = mCWrapper.getUOWCoordinator();
        PoolManager poolManager = (PoolManager)mCWrapper.getPoolManager();
        Vector vector = poolManager.getMCWrappersByTran(uOWCoordinator);
        if (vector != null && vector.size() > 0) {
            incidentStream.writeLine("DSRA9002E J2CA0030E WTRN0062E", "Possible misuse of connection manager may have caused a 2PC transaction a 1PC transaction was desired.");
            Subject subject = mCWrapper.getSubject();
            ConnectionRequestInfo connectionRequestInfo = mCWrapper.getCRI();
            String string2 = connectionRequestInfo instanceof WSConnectionRequestInfoImpl ? ((WSConnectionRequestInfoImpl)connectionRequestInfo).getPassword() : "";
            this.printMCWrapperDetails(mCWrapper, incidentStream, string2, subject);
            for (int i = 0; i < vector.size(); ++i) {
                mCWrapper = (MCWrapper)vector.elementAt(i);
                if (mCWrapper == mCWrapper2) continue;
                this.printMCWrapperDetails(mCWrapper, incidentStream, string2, subject);
            }
        }
    }

    private void printMCWrapperDetails(MCWrapper mCWrapper, IncidentStream incidentStream, String string, Subject subject) {
        Subject subject2 = mCWrapper.getSubject();
        ConnectionRequestInfo connectionRequestInfo = mCWrapper.getCRI();
        incidentStream.writeLine("MCWrapper", mCWrapper.toString());
        incidentStream.writeLine("PoolName", mCWrapper.getPoolManager().getPmiName());
        incidentStream.writeLine(connectionRequestInfo.toString(), "");
        if (!this.subjectsMatch(subject2, subject)) {
            incidentStream.writeLine("Subject does NOT match!", "");
        }
        if (subject2 == null) {
            incidentStream.writeLine("Subject", "null");
        }
        incidentStream.writeLine("Container Managed Auth", mCWrapper.getConnectionManager().getContainerManagedAuth() ? "Yes" : "No");
        if (connectionRequestInfo instanceof WSConnectionRequestInfoImpl) {
            String string2 = ((WSConnectionRequestInfoImpl)connectionRequestInfo).getPassword();
            if (string != null && !string.equals(string2)) {
                incidentStream.writeLine("Password does NOT match!", "");
            }
        }
    }

    private boolean subjectsMatch(Subject subject, Subject subject2) {
        if (subject == subject2) {
            return true;
        }
        if (subject == null && subject2 != null || subject != null && subject2 == null) {
            return false;
        }
        if (subject != null && subject2 != null) {
            Set<Object> set = subject.getPublicCredentials();
            Set<Object> set2 = subject2.getPublicCredentials();
            Set<Object> set3 = subject.getPrivateCredentials();
            Set<Object> set4 = subject2.getPrivateCredentials();
            if (set != null && ((Object)set).equals(set2)) {
                return set3 != null && ((Object)set3).equals(set4);
            }
        }
        return false;
    }

    public static void main(String[] stringArray) {
        System.out.println("Start of the test for the component DM");
        DiagnosticModuleForJ2C diagnosticModuleForJ2C = new DiagnosticModuleForJ2C();
        diagnosticModuleForJ2C.validate();
    }
}

