/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.ConnectorRuntime;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.xml.ParserFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.resource.ResourceException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLReader
extends DefaultHandler {
    private static final TraceComponent TC = Tr.register((Class)(class$com$ibm$ejs$j2c$XMLReader == null ? (class$com$ibm$ejs$j2c$XMLReader = XMLReader.class$("com.ibm.ejs.j2c.XMLReader")) : class$com$ibm$ejs$j2c$XMLReader), (String)"WAS.j2c", (String)"com.ibm.ejs.resources.J2CAMessages");
    private Document _document = null;
    private Element _rootElement = null;
    private String _xmlFileName = null;
    private String _filePath = null;
    private Node _node = null;
    private String _nl = ConnectorRuntime.nl;
    private final String _spaces = "    ";
    private int _indentLevel = 0;
    private File _j2cPropsFile;
    private boolean _valid = false;
    private StringBuffer _buf = new StringBuffer();
    private static final String FILESEP = System.getProperty("file.separator");
    static /* synthetic */ Class class$com$ibm$ejs$j2c$XMLReader;

    public XMLReader(String string, String string2) throws XMLReaderException {
        this.init(string, string2);
    }

    public XMLReader(String string) throws XMLReaderException {
        this.init(string, "j2c-customizations");
    }

    public XMLReader() throws XMLReaderException {
        this.init("j2c.properties", "j2c-customizations");
    }

    private void init(String string, String string2) throws XMLReaderException {
        Object[] objectArray;
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer(64);
        try {
            object2 = Class.forName("com.ibm.ws.security.core.SecurityConfig");
            object = object2.getMethod("getConfig", null);
            objectArray = ((Method)object).invoke(null, null);
            Class[] classArray = new Class[]{Class.forName("java.lang.String")};
            Method method = object2.getMethod("getValue", classArray);
            Object[] objectArray2 = new Object[]{"${WAS_PROPS_DIR}"};
            this._filePath = (String)method.invoke((Object)objectArray, objectArray2);
            stringBuffer.append(this._filePath);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.j2c.XMLReader", (String)"1676");
            Tr.warning((TraceComponent)TC, (String)"ERROR_GETTING_PROPERTIES_PATH_J2CA0115", (Object)exception);
            XMLReaderException xMLReaderException = new XMLReaderException("Error getting properties path");
            xMLReaderException.setLinkedException(exception);
            throw xMLReaderException;
        }
        this._xmlFileName = string;
        stringBuffer.append(FILESEP);
        stringBuffer.append(string);
        this._filePath = stringBuffer.toString();
        this._j2cPropsFile = new File(this._filePath);
        if (!this._j2cPropsFile.exists()) {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)("XMLReader did not find properties file " + this._filePath));
            }
            object2 = new XMLReaderException("XMLReader did not find properties file " + this._filePath);
            throw object2;
        }
        boolean bl = this.validate(this._filePath);
        if (!bl) {
            object = new XMLReaderException("XMLReader had error parsing document " + this._j2cPropsFile);
            throw object;
        }
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)("properties file:" + this._nl + this._buf.toString()));
        }
        try {
            object = ParserFactory.newDocumentBuilder((boolean)false, (boolean)true);
            this._document = ParserFactory.parseDocument((DocumentBuilder)object, (File)this._j2cPropsFile);
        }
        catch (Exception exception) {
            objectArray = new XMLReaderException("XMLReader had error parsing document " + this._j2cPropsFile);
            objectArray.setLinkedException(exception);
            Tr.warning((TraceComponent)TC, (String)"XML_PARSING_ERROR_J2CA0125", (Object)new Object[]{objectArray});
            throw objectArray;
        }
        this._document.normalize();
        this._rootElement = this._document.getDocumentElement();
        object = this._rootElement.getNodeName();
        if (!((String)object).equals(string2)) {
            objectArray = new Object[]{string, object};
            Tr.warning((TraceComponent)TC, (String)"MISSING_OR_UNRECOGNIZED_ROOT_ELEMENT_J2CA0116", (Object)objectArray);
        } else if (this._valid) {
            objectArray = new Object[]{string, object};
            Tr.info((TraceComponent)TC, (String)"XML_FILE_READ_J2CA0117", (Object)objectArray);
        }
    }

    public boolean setNode(String string) {
        if (TC.isEntryEnabled()) {
            Tr.entry((TraceComponent)TC, (String)("setNode(" + string + ")"));
        }
        boolean bl = false;
        NodeList nodeList = null;
        nodeList = this._rootElement.getElementsByTagName(string);
        if (nodeList != null) {
            int n = nodeList.getLength();
            if (n > 1) {
                Tr.warning((TraceComponent)TC, (String)("XMLReader:setNode found more than one element with name " + string + ".  Using first one"));
            }
            if (n == 1) {
                this._node = nodeList.item(0);
                bl = true;
            }
        }
        if (TC.isDebugEnabled() && !bl) {
            Tr.debug((TraceComponent)TC, (String)("XMLReader:setNode did not find elementName <" + string + ">.  Node unchanged."));
        }
        if (TC.isEntryEnabled()) {
            Tr.exit((TraceComponent)TC, (String)("setNode(" + string + ")"));
        }
        return bl;
    }

    public boolean setNode(String string, String string2, String string3) {
        if (TC.isEntryEnabled()) {
            Tr.entry((TraceComponent)TC, (String)("setNode(" + string + ", " + string2 + ", " + string3 + ")"));
        }
        NamedNodeMap namedNodeMap = null;
        Node node = null;
        NodeList nodeList = null;
        nodeList = this._rootElement.getElementsByTagName(string);
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                String string4;
                Node node2;
                node = nodeList.item(i);
                namedNodeMap = node.getAttributes();
                if (namedNodeMap == null || (node2 = namedNodeMap.getNamedItem(string2)) == null || !(string4 = node2.getNodeValue()).equals(string3)) continue;
                if (TC.isDebugEnabled()) {
                    Tr.debug((TraceComponent)TC, (String)("XMLReader:setNode found elementName <" + string + "> with attributeName <" + string2 + "> and attributeValue <" + string3 + ">."));
                }
                this._node = node;
                if (TC.isEntryEnabled()) {
                    Tr.exit((TraceComponent)TC, (String)("setNode(" + string + ", " + string2 + ", " + string3 + ") returning true"));
                }
                return true;
            }
        }
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)("XMLReader:setNode did not find elementName <" + string + "> with attributeName <" + string2 + "> and attributeValue <" + string3 + ">.  Node unchanged."));
        }
        if (TC.isEntryEnabled()) {
            Tr.exit((TraceComponent)TC, (String)("setNode(" + string + ", " + string2 + ", " + string3 + ") returning false"));
        }
        return false;
    }

    public String getElementValueString(String string) {
        NodeList nodeList = null;
        Node node = null;
        String string2 = null;
        String string3 = null;
        if (this._node == null) {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)("node not set when getting element <" + string + "> in XMLReader for " + this._xmlFileName + ".  Returning null."));
            }
            return string3;
        }
        nodeList = this._node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            node = nodeList.item(i);
            if (node == null || !(string2 = node.getNodeName()).equals(string)) continue;
            string3 = (node = node.getFirstChild()).getNodeValue();
            if (string3 != null) {
                string3 = string3.trim();
            }
            return string3;
        }
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)("getElementValueString did not find element <" + string + "> in node <" + this._node.getNodeName() + "> in XMLReader for " + this._xmlFileName + ".  Returning null"));
        }
        return null;
    }

    public String getElementValueString(String string, String string2) {
        String string3 = this.getElementValueString(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public int getElementValueInt(String string) {
        String string2 = this.getElementValueString(string);
        if (string2 == null) {
            return 0;
        }
        try {
            int n = Integer.parseInt(string2);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            Object[] objectArray = new Object[]{string, this._node.getNodeName(), this._xmlFileName, string2, String.valueOf(0)};
            Tr.warning((TraceComponent)TC, (String)"XML_FORMAT_ERROR_J2CA0126", (Object)objectArray);
            return 0;
        }
    }

    public int getElementValueInt(String string, int n) {
        String string2 = this.getElementValueString(string);
        if (string2 == null) {
            return n;
        }
        try {
            int n2 = Integer.parseInt(string2);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            Object[] objectArray = new Object[]{string, this._node.getNodeName(), this._xmlFileName, string2, String.valueOf(n)};
            Tr.warning((TraceComponent)TC, (String)"XML_FORMAT_ERROR_J2CA0126", (Object)objectArray);
            return n;
        }
    }

    public boolean getElementValueBoolean(String string) {
        String string2 = this.getElementValueString(string);
        if (string2 == null) {
            return false;
        }
        try {
            boolean bl = Boolean.valueOf(string2);
            return bl;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{string, this._node.getNodeName(), this._xmlFileName, String.valueOf(false)};
            Tr.warning((TraceComponent)TC, (String)"XML_FORMAT_ERROR_J2CA0126", (Object)objectArray);
            return false;
        }
    }

    public boolean getElementValueBoolean(String string, boolean bl) {
        String string2 = this.getElementValueString(string);
        if (string2 == null) {
            return bl;
        }
        try {
            boolean bl2 = Boolean.valueOf(string2);
            return bl2;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{string, this._node.getNodeName(), this._xmlFileName, String.valueOf(bl)};
            Tr.warning((TraceComponent)TC, (String)"XML_FORMAT_ERROR_J2CA0126", (Object)objectArray);
            return bl;
        }
    }

    public String getXmlFileName() {
        return this._xmlFileName;
    }

    private boolean validate(String string) throws XMLReaderException {
        try {
            SAXParser sAXParser = ParserFactory.newSAXParser();
            sAXParser.parse(new File(string), (DefaultHandler)this);
            return true;
        }
        catch (SAXParseException sAXParseException) {
            String string2 = this._nl + this._j2cPropsFile + "  ** Parsing error" + ", line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId() + "   " + sAXParseException.getMessage() + this._nl + this._buf;
            Tr.warning((TraceComponent)TC, (String)"XML_PARSING_ERROR_J2CA0125", (Object)new Object[]{string2});
            if (TC.isDebugEnabled()) {
                Exception exception = sAXParseException;
                if (sAXParseException.getException() != null) {
                    exception = sAXParseException.getException();
                }
                exception.printStackTrace();
            }
            return false;
        }
        catch (SAXException sAXException) {
            String string3 = this._nl + this._j2cPropsFile + "  ** Parsing error" + "   " + sAXException.getMessage() + this._nl + this._buf;
            Tr.warning((TraceComponent)TC, (String)"XML_PARSING_ERROR_J2CA0125", (Object)new Object[]{string3});
            if (TC.isDebugEnabled()) {
                Exception exception = sAXException;
                if (sAXException.getException() != null) {
                    exception = sAXException.getException();
                }
                exception.printStackTrace();
            }
            return false;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public void setDocumentLocator(Locator locator) {
        this._buf.append("LOCATOR");
        this._buf.append(this._nl + " SYS ID: " + locator.getSystemId());
    }

    public void startDocument() throws SAXException {
        this.newLine();
        this.newLine();
        this.emit("BEGIN DOCUMENT");
        this.newLine();
        this.emit("<?xml version='1.0' encoding='UTF-8'?>");
    }

    public void endDocument() throws SAXException {
        this.newLine();
        this.emit("END DOCUMENT");
        this.newLine();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this._indentLevel;
        this.newLine();
        this.emit("BEGIN ELEMENT: ");
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        this.emit("<" + string4);
        if (attributes != null) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                this.newLine();
                this.emit("   ATTRIBUTE: ");
                this.emit(string5);
                this.emit("\t\"");
                this.emit(attributes.getValue(i));
                this.emit("\"");
            }
        }
        this.emit(">");
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.newLine();
        this.emit("END_ELMENT: ");
        this.emit("</" + string2 + ">");
        --this._indentLevel;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.newLine();
        this.emit("CHARS:   ");
        String string = new String(cArray, n, n2);
        if (!string.trim().equals("")) {
            this.emit(string);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.newLine();
        this.emit("PROCESS: ");
        this.emit("<?" + string + " " + string2 + "?>");
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
        this.warning(sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        this.warning(sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        this._valid = false;
        throw sAXParseException;
    }

    private void emit(String string) throws SAXException {
        this._buf.append(string);
    }

    private void newLine() throws SAXException {
        this._buf.append(this._nl);
        for (int i = 0; i < this._indentLevel; ++i) {
            this._buf.append("    ");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class XMLReaderException
    extends ResourceException {
        XMLReaderException(String string) {
            super(string);
        }
    }
}

