/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c.poolmanager;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.ListIterator;

public class DBRequestMonitorPool {
    private int bitSetSize;
    private int stuckTime;
    private int timerTime;
    private int stuckThreshold;
    private LinkedList bsList;
    private BitSet currentBS;
    private int numBack;
    private BitSet connExists;
    private BitSet trueBS;
    private Object connExistsLockObject = new Object();
    private boolean lastStuckValue = false;
    private String dataSourceName;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$j2c$poolmanager$DBRequestMonitorPool == null ? (class$com$ibm$ejs$j2c$poolmanager$DBRequestMonitorPool = DBRequestMonitorPool.class$("com.ibm.ejs.j2c.poolmanager.DBRequestMonitorPool")) : class$com$ibm$ejs$j2c$poolmanager$DBRequestMonitorPool), null, (String)"com.ibm.ejs.resources.CONMMessages");
    static /* synthetic */ Class class$com$ibm$ejs$j2c$poolmanager$DBRequestMonitorPool;

    public DBRequestMonitorPool(int n, int n2, int n3, int n4, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        this.bitSetSize = n;
        this.stuckTime = n2;
        this.timerTime = n3;
        this.stuckThreshold = n4;
        this.dataSourceName = string;
        this.numBack = this.stuckTime / this.timerTime;
        if (this.stuckTime % this.timerTime != 0) {
            ++this.numBack;
        }
        this.bsList = new LinkedList();
        this.connExists = new BitSet(this.bitSetSize);
        this.trueBS = new BitSet(this.bitSetSize);
        for (int i = 0; i < this.bitSetSize; ++i) {
            this.trueBS.set(i);
        }
        this.currentBS = new BitSet(this.bitSetSize);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)new Object[]{"bitSetSize=" + this.bitSetSize, " stuckTime=" + this.stuckTime, " timerTime=" + this.timerTime, " stuckThreshold=" + this.stuckThreshold, " numBack=" + this.numBack});
        }
    }

    public BitSet set(int n) {
        BitSet bitSet;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"set(int)");
            }
            bitSet = this.currentBS;
            try {
                bitSet.set(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"caught exception doing set", (Object)indexOutOfBoundsException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"set(int)", (Object)bitSet);
        }
        return bitSet;
    }

    public void clear(int n, BitSet bitSet) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"clear(int, BitSet)", (Object)new Object[]{new Integer(n), bitSet});
            }
            try {
                bitSet.clear(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"caught exception doing clear", (Object)indexOutOfBoundsException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clear(int, BitSet)");
        }
    }

    public boolean processAlarm() {
        BitSet bitSet;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processAlarm()");
        }
        boolean bl = false;
        this.currentBS = bitSet = new BitSet(this.bitSetSize);
        this.bsList.addFirst(this.currentBS);
        int n = 0;
        if (this.bsList.size() > this.numBack) {
            ListIterator listIterator = this.bsList.listIterator(this.numBack + 1);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"There might be stuck connections.");
            }
            int n2 = 0;
            while (listIterator.hasNext()) {
                BitSet bitSet2 = (BitSet)listIterator.next();
                n2 = bitSet2.length();
                for (int i = 0; i < n2; ++i) {
                    if (!bitSet2.get(i)) continue;
                    ++n;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("numStuck is " + n));
            }
            if (n >= this.stuckThreshold) {
                bl = true;
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The list of BitSets is too small to have stuck connections.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("bsList.size() before removing empties is " + this.bsList.size()));
        }
        for (int i = this.bsList.size(); i > 1 && ((BitSet)this.bsList.getLast()).length() == 0; --i) {
            this.bsList.removeLast();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("bsList.size() after removing empties is " + this.bsList.size()));
        }
        if (!this.lastStuckValue && bl) {
            Tr.audit((TraceComponent)tc, (String)"MSG_CONM_2001I", (Object)new Object[]{new Integer(n), this.dataSourceName, new Integer(this.stuckTime)});
        } else if (this.lastStuckValue && !bl) {
            Tr.audit((TraceComponent)tc, (String)"MSG_CONM_2002I", (Object)new Object[]{this.dataSourceName, new Integer(n), new Integer(this.stuckThreshold)});
        }
        this.lastStuckValue = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processAlarm()", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setCreated() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setCreated()");
        }
        Object object = this.connExistsLockObject;
        synchronized (object) {
            BitSet bitSet = (BitSet)this.connExists.clone();
            bitSet.xor(this.trueBS);
            int n = bitSet.length();
            if (n != 0) {
                this.connExists.set(--n);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The BitSet is full during setCreated()");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setCreated()", (Object)new Integer(n));
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDestroyed(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setDestroyed(int)", (Object)new Integer(n));
        }
        Object object = this.connExistsLockObject;
        synchronized (object) {
            this.connExists.clear(n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setDestroyed(int)");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

