/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.ant.Policy;
import org.eclipse.core.runtime.IPath;

public class ConvertPath
extends Task {
    private IPath fileSystemPath = null;
    private IPath resourcePath = null;
    private String property = null;
    private String pathID = null;

    public void execute() throws BuildException {
        this.validateAttributes();
        if (this.fileSystemPath == null) {
            this.convertResourcePathToFileSystemPath(this.resourcePath);
        } else {
            this.convertFileSystemPathToResourcePath(this.fileSystemPath);
        }
    }

    protected void convertFileSystemPathToResourcePath(IPath path) {
        IContainer resource = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(path);
        if (resource == null) {
            throw new BuildException(Policy.bind("exception.noProjectMatchThePath", this.fileSystemPath.toOSString()));
        }
        if (this.property != null) {
            ((ProjectComponent)this).project.setUserProperty(this.property, resource.getFullPath().toString());
        }
        if (this.pathID != null) {
            Path newPath = new Path(((ProjectComponent)this).project, resource.getFullPath().toString());
            ((ProjectComponent)this).project.addReference(this.pathID, (Object)newPath);
        }
    }

    protected void convertResourcePathToFileSystemPath(IPath path) {
        Object resource = null;
        resource = path.segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment()) : ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (resource.getLocation() == null) {
            throw new BuildException(Policy.bind("exception.pathNotValid", path.toString()));
        }
        if (this.property != null) {
            ((ProjectComponent)this).project.setUserProperty(this.property, resource.getLocation().toOSString());
        }
        if (this.pathID != null) {
            Path newPath = new Path(((ProjectComponent)this).project, resource.getLocation().toOSString());
            ((ProjectComponent)this).project.addReference(this.pathID, (Object)newPath);
        }
    }

    public void setFileSystemPath(File value) {
        if (this.resourcePath != null) {
            throw new BuildException(Policy.bind("exception.cantUseBoth"));
        }
        this.fileSystemPath = new org.eclipse.core.runtime.Path(value.toString());
    }

    public void setResourcePath(String value) {
        if (this.fileSystemPath != null) {
            throw new BuildException(Policy.bind("exception.cantUseBoth"));
        }
        this.resourcePath = new org.eclipse.core.runtime.Path(value);
    }

    public void setProperty(String value) {
        this.property = value;
    }

    public void setPathId(String value) {
        this.pathID = value;
    }

    protected void validateAttributes() throws BuildException {
        if (this.property == null && this.pathID == null) {
            throw new BuildException(Policy.bind("exception.propertyAndPathIdNotSpecified"));
        }
        if (this.resourcePath != null && (!this.resourcePath.isValidPath(this.resourcePath.toString()) || this.resourcePath.isEmpty())) {
            throw new BuildException(Policy.bind("exception.invalidPath", this.resourcePath.toOSString()));
        }
        if (this.fileSystemPath != null && !this.fileSystemPath.isValidPath(this.fileSystemPath.toOSString())) {
            throw new BuildException(Policy.bind("exception.invalidPath", this.fileSystemPath.toOSString()));
        }
        if (this.resourcePath == null && this.fileSystemPath == null) {
            throw new BuildException(Policy.bind("exception.mustHaveOneAttribute"));
        }
    }
}

